/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.event;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.dto.event.meta.HeartbeatMetaEvent;
import com.mikuac.shiro.dto.event.meta.LifecycleMetaEvent;
import com.mikuac.shiro.enums.MetaEventEnum;
import com.mikuac.shiro.handler.injection.InjectionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetaEvent {
    private InjectionHandler injection;
    public final Map<String, BiConsumer<Bot, JSONObject>> handlers = new HashMap<String, BiConsumer<Bot, JSONObject>>();

    @Autowired
    public void setInjection(InjectionHandler injection) {
        this.injection = injection;
    }

    public void handler(Bot bot, JSONObject resp) {
        String type = resp.getString("meta_event_type");
        this.handlers.getOrDefault(type, (b, e) -> {}).accept(bot, resp);
    }

    public void heartbeat(Bot bot, JSONObject resp) {
        this.process(bot, resp, MetaEventEnum.HEARTBEAT);
    }

    public void lifecycle(Bot bot, JSONObject resp) {
        this.process(bot, resp, MetaEventEnum.LIFECYCLE);
    }

    private void process(Bot bot, JSONObject resp, MetaEventEnum type) {
        switch (type) {
            case HEARTBEAT: {
                HeartbeatMetaEvent event = (HeartbeatMetaEvent)resp.to(HeartbeatMetaEvent.class, new JSONReader.Feature[0]);
                this.injection.invokeHeartbeat(bot, event);
                break;
            }
            case LIFECYCLE: {
                LifecycleMetaEvent event = (LifecycleMetaEvent)resp.to(LifecycleMetaEvent.class, new JSONReader.Feature[0]);
                this.injection.invokeLifecycle(bot, event);
                break;
            }
        }
    }
}

