/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.injection;

import com.mikuac.shiro.annotation.AnyMessageHandler;
import com.mikuac.shiro.annotation.FriendAddNoticeHandler;
import com.mikuac.shiro.annotation.FriendAddRequestHandler;
import com.mikuac.shiro.annotation.GroupAddRequestHandler;
import com.mikuac.shiro.annotation.GroupAdminHandler;
import com.mikuac.shiro.annotation.GroupBanNoticeHandler;
import com.mikuac.shiro.annotation.GroupCardChangeNoticeHandler;
import com.mikuac.shiro.annotation.GroupDecreaseHandler;
import com.mikuac.shiro.annotation.GroupIncreaseHandler;
import com.mikuac.shiro.annotation.GroupMessageHandler;
import com.mikuac.shiro.annotation.GroupMsgDeleteNoticeHandler;
import com.mikuac.shiro.annotation.GroupPokeNoticeHandler;
import com.mikuac.shiro.annotation.GroupUploadNoticeHandler;
import com.mikuac.shiro.annotation.GuildMessageHandler;
import com.mikuac.shiro.annotation.MessageHandlerFilter;
import com.mikuac.shiro.annotation.MetaHandler;
import com.mikuac.shiro.annotation.PrivateMessageHandler;
import com.mikuac.shiro.annotation.PrivateMsgDeleteNoticeHandler;
import com.mikuac.shiro.annotation.PrivatePokeNoticeHandler;
import com.mikuac.shiro.common.utils.CheckResult;
import com.mikuac.shiro.common.utils.CommonUtils;
import com.mikuac.shiro.common.utils.InternalUtils;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.dto.event.message.AnyMessageEvent;
import com.mikuac.shiro.dto.event.message.GroupMessageEvent;
import com.mikuac.shiro.dto.event.message.GuildMessageEvent;
import com.mikuac.shiro.dto.event.message.MessageEvent;
import com.mikuac.shiro.dto.event.message.PrivateMessageEvent;
import com.mikuac.shiro.dto.event.meta.HeartbeatMetaEvent;
import com.mikuac.shiro.dto.event.meta.LifecycleMetaEvent;
import com.mikuac.shiro.dto.event.notice.FriendAddNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupAdminNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupBanNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupCardChangeNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupDecreaseNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupIncreaseNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupMsgDeleteNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupUploadNoticeEvent;
import com.mikuac.shiro.dto.event.notice.PokeNoticeEvent;
import com.mikuac.shiro.dto.event.notice.PrivateMsgDeleteNoticeEvent;
import com.mikuac.shiro.dto.event.request.FriendAddRequestEvent;
import com.mikuac.shiro.dto.event.request.GroupAddRequestEvent;
import com.mikuac.shiro.enums.AdminNoticeTypeEnum;
import com.mikuac.shiro.enums.CommonEnum;
import com.mikuac.shiro.enums.MetaEventEnum;
import com.mikuac.shiro.model.HandlerMethod;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InjectionHandler {
    private static final Logger log = LoggerFactory.getLogger(InjectionHandler.class);

    private void invokeMethod(HandlerMethod method, Map<Class<?>, Object> params) {
        Class<?>[] types = method.getMethod().getParameterTypes();
        Object[] objects = new Object[types.length];
        Arrays.stream(types).forEach(InternalUtils.consumerWithIndex((item, index) -> {
            if (params.containsKey(item)) {
                objects[index] = params.remove(item);
                return;
            }
            objects[index] = null;
        }));
        try {
            method.getMethod().invoke(method.getObject(), objects);
        }
        catch (Exception e) {
            log.error("Invoke method exception: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private <T> void invoke(Bot bot, T event, Class<? extends Annotation> type) {
        Optional<List> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(type));
        if (methods.isEmpty()) {
            return;
        }
        HashMap params = new HashMap();
        params.put(Bot.class, bot);
        params.put(event.getClass(), (Bot)event);
        methods.get().forEach(method -> this.invokeMethod((HandlerMethod)method, params));
    }

    private <T> void invoke(Bot bot, T event, HandlerMethod method, Matcher matcher) {
        HashMap params = new HashMap();
        if (matcher != null) {
            params.put(Matcher.class, matcher);
        }
        params.put(Bot.class, bot);
        params.put(event.getClass(), event);
        this.invokeMethod(method, params);
    }

    public void invokeGroupRecall(Bot bot, GroupMsgDeleteNoticeEvent event) {
        this.invoke(bot, event, GroupMsgDeleteNoticeHandler.class);
    }

    public void invokeFriendRecall(Bot bot, PrivateMsgDeleteNoticeEvent event) {
        this.invoke(bot, event, PrivateMsgDeleteNoticeHandler.class);
    }

    public void invokeFriendAdd(Bot bot, FriendAddNoticeEvent event) {
        this.invoke(bot, event, FriendAddNoticeHandler.class);
    }

    public void invokeGroupIncrease(Bot bot, GroupIncreaseNoticeEvent event) {
        this.invoke(bot, event, GroupIncreaseHandler.class);
    }

    public void invokeGroupDecrease(Bot bot, GroupDecreaseNoticeEvent event) {
        this.invoke(bot, event, GroupDecreaseHandler.class);
    }

    public void invokeFriendAddRequest(Bot bot, FriendAddRequestEvent event) {
        this.invoke(bot, event, FriendAddRequestHandler.class);
    }

    public void invokeGroupAddRequest(Bot bot, GroupAddRequestEvent event) {
        this.invoke(bot, event, GroupAddRequestHandler.class);
    }

    public void invokeGroupBanNotice(Bot bot, GroupBanNoticeEvent event) {
        this.invoke(bot, event, GroupBanNoticeHandler.class);
    }

    public void invokeGroupCardChangeNotice(Bot bot, GroupCardChangeNoticeEvent event) {
        this.invoke(bot, event, GroupCardChangeNoticeHandler.class);
    }

    public void invokeGroupPokeNotice(Bot bot, PokeNoticeEvent event) {
        this.invoke(bot, event, GroupPokeNoticeHandler.class);
    }

    public void invokeGroupUploadNotice(Bot bot, GroupUploadNoticeEvent event) {
        this.invoke(bot, event, GroupUploadNoticeHandler.class);
    }

    public void invokePrivatePokeNotice(Bot bot, PokeNoticeEvent event) {
        this.invoke(bot, event, PrivatePokeNoticeHandler.class);
    }

    public void invokeAnyMessage(Bot bot, AnyMessageEvent event) {
        Optional<List<HandlerMethod>> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(AnyMessageHandler.class));
        this.invokeMessage(bot, event, methods);
    }

    public void invokeGuildMessage(Bot bot, GuildMessageEvent event) {
        Optional<List<HandlerMethod>> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(GuildMessageHandler.class));
        this.invokeMessage(bot, event, methods);
    }

    public void invokeGroupMessage(Bot bot, GroupMessageEvent event) {
        Optional<List<HandlerMethod>> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(GroupMessageHandler.class));
        this.invokeMessage(bot, event, methods);
    }

    public void invokePrivateMessage(Bot bot, PrivateMessageEvent event) {
        Optional<List<HandlerMethod>> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(PrivateMessageHandler.class));
        this.invokeMessage(bot, event, methods);
    }

    public void invokeMessage(Bot bot, MessageEvent event, Optional<List<HandlerMethod>> handlerMethods) {
        if (handlerMethods.isEmpty()) {
            return;
        }
        handlerMethods.get().forEach(method -> {
            MessageHandlerFilter filter = method.getMethod().getAnnotation(MessageHandlerFilter.class);
            if (Objects.isNull(filter)) {
                this.invoke(bot, (Object)event, (HandlerMethod)method, null);
            } else {
                CheckResult result = CommonUtils.allFilterCheck(event, bot.getSelfId(), filter);
                if (result.isResult()) {
                    this.invoke(bot, (Object)event, (HandlerMethod)method, result.getMatcher());
                }
            }
        });
    }

    public void invokeGroupAdmin(Bot bot, GroupAdminNoticeEvent event) {
        Optional<List> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(GroupAdminHandler.class));
        if (methods.isEmpty()) {
            return;
        }
        methods.get().forEach(method -> {
            AdminNoticeTypeEnum type = method.getMethod().getAnnotation(GroupAdminHandler.class).type();
            if (type == AdminNoticeTypeEnum.OFF) {
                return;
            }
            if (type == AdminNoticeTypeEnum.UNSET && !CommonEnum.UNSET.value().equals(event.getSubType())) {
                return;
            }
            if (type == AdminNoticeTypeEnum.SET && !CommonEnum.SET.value().equals(event.getSubType())) {
                return;
            }
            this.invoke(bot, event, GroupAdminHandler.class);
        });
    }

    public void invokeHeartbeat(Bot bot, HeartbeatMetaEvent event) {
        Optional<List> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(MetaHandler.class));
        if (methods.isEmpty()) {
            return;
        }
        HashMap<Class, Object> params = new HashMap<Class, Object>();
        params.put(Bot.class, bot);
        params.put(HeartbeatMetaEvent.class, event);
        methods.get().forEach(method -> {
            MetaHandler anno = method.getMethod().getAnnotation(MetaHandler.class);
            if (anno.type() != MetaEventEnum.HEARTBEAT) {
                return;
            }
            this.invokeMethod((HandlerMethod)method, (Map<Class<?>, Object>)params);
        });
    }

    public void invokeLifecycle(Bot bot, LifecycleMetaEvent event) {
        Optional<List> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(MetaHandler.class));
        HashMap<Class, Object> params = new HashMap<Class, Object>();
        if (methods.isEmpty()) {
            return;
        }
        params.put(Bot.class, bot);
        params.put(LifecycleMetaEvent.class, event);
        methods.get().forEach(method -> {
            MetaHandler anno = method.getMethod().getAnnotation(MetaHandler.class);
            if (anno.type() != MetaEventEnum.LIFECYCLE) {
                return;
            }
            this.invokeMethod((HandlerMethod)method, (Map<Class<?>, Object>)params);
        });
    }
}

