/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.boot;

import com.mikuac.shiro.adapter.WebSocketClientHandler;
import com.mikuac.shiro.adapter.WebSocketServerHandler;
import com.mikuac.shiro.core.BotContainer;
import com.mikuac.shiro.core.BotFactory;
import com.mikuac.shiro.handler.ActionHandler;
import com.mikuac.shiro.handler.EventHandler;
import com.mikuac.shiro.properties.WebSocketServerProperties;
import com.mikuac.shiro.task.ShiroAsyncTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;

@Configuration
public class Shiro {
    private WebSocketServerProperties wsServerProp;
    private BotFactory botFactory;
    private EventHandler eventHandler;
    private ActionHandler actionHandler;
    private ShiroAsyncTask shiroAsyncTask;
    private BotContainer botContainer;

    @Autowired
    public void setWebSocketServerProperties(WebSocketServerProperties wsServerProp) {
        this.wsServerProp = wsServerProp;
    }

    @Autowired
    public void setBotFactory(BotFactory botFactory) {
        this.botFactory = botFactory;
    }

    @Autowired
    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Autowired
    public void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Autowired
    public void setShiroAsyncTask(ShiroAsyncTask shiroAsyncTask) {
        this.shiroAsyncTask = shiroAsyncTask;
    }

    @Autowired
    public void setBotContainer(BotContainer botContainer) {
        this.botContainer = botContainer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"shiro.ws.server.enable"}, havingValue="true")
    public WebSocketServerHandler webSocketServerHandler() {
        return new WebSocketServerHandler(this.eventHandler, this.botFactory, this.actionHandler, this.shiroAsyncTask, this.botContainer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"shiro.ws.client.enable"}, havingValue="true")
    public WebSocketClientHandler webSocketClientHandler() {
        return new WebSocketClientHandler(this.eventHandler, this.botFactory, this.actionHandler, this.shiroAsyncTask, this.botContainer);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServletServerContainerFactoryBean createWebSocketServerContainer() {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        container.setMaxTextMessageBufferSize(this.wsServerProp.getMaxTextMessageBufferSize());
        container.setMaxBinaryMessageBufferSize(this.wsServerProp.getMaxBinaryMessageBufferSize());
        container.setMaxSessionIdleTimeout(this.wsServerProp.getMaxSessionIdleTimeout());
        return container;
    }
}

