/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class SendUtils {
    private static final Logger log = LoggerFactory.getLogger(SendUtils.class);
    private final int timeout;
    private final WebSocketSession session;
    private JSONObject resp;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public SendUtils(WebSocketSession session, int timeout) {
        this.session = session;
        this.timeout = timeout;
    }

    public JSONObject send(@NonNull JSONObject payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.lock.lock();
        try {
            String json = payload.toJSONString(new JSONWriter.Feature[0]);
            this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
            log.debug("[Action] {}", (Object)json);
            this.condition.await(payload.getIntValue("echo") == 0 ? 1L : (long)this.timeout, TimeUnit.SECONDS);
        }
        catch (IOException e) {
            log.error("Send action payload exception: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
        return this.resp;
    }

    public void onCallback(JSONObject resp) {
        this.lock.lock();
        try {
            this.resp = resp;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

