/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.core;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.mikuac.shiro.action.GensokyoExtend;
import com.mikuac.shiro.action.GoCQHTTPExtend;
import com.mikuac.shiro.action.LLOneBotExtend;
import com.mikuac.shiro.action.LagrangeExtend;
import com.mikuac.shiro.action.OneBot;
import com.mikuac.shiro.core.BotMessageEventInterceptor;
import com.mikuac.shiro.core.BotPlugin;
import com.mikuac.shiro.dto.action.common.ActionData;
import com.mikuac.shiro.dto.action.common.ActionList;
import com.mikuac.shiro.dto.action.common.ActionRaw;
import com.mikuac.shiro.dto.action.common.Anonymous;
import com.mikuac.shiro.dto.action.common.GuildMsgId;
import com.mikuac.shiro.dto.action.common.MsgId;
import com.mikuac.shiro.dto.action.response.BooleanResp;
import com.mikuac.shiro.dto.action.response.ChannelInfoResp;
import com.mikuac.shiro.dto.action.response.CheckUrlSafelyResp;
import com.mikuac.shiro.dto.action.response.ClientsResp;
import com.mikuac.shiro.dto.action.response.DownloadFileResp;
import com.mikuac.shiro.dto.action.response.EssenceMsgResp;
import com.mikuac.shiro.dto.action.response.FriendInfoResp;
import com.mikuac.shiro.dto.action.response.GetGuildMsgResp;
import com.mikuac.shiro.dto.action.response.GetMsgResp;
import com.mikuac.shiro.dto.action.response.GetStatusResp;
import com.mikuac.shiro.dto.action.response.GroupAtAllRemainResp;
import com.mikuac.shiro.dto.action.response.GroupFilesResp;
import com.mikuac.shiro.dto.action.response.GroupHonorInfoResp;
import com.mikuac.shiro.dto.action.response.GroupInfoResp;
import com.mikuac.shiro.dto.action.response.GroupMemberInfoResp;
import com.mikuac.shiro.dto.action.response.GuildListResp;
import com.mikuac.shiro.dto.action.response.GuildMemberListResp;
import com.mikuac.shiro.dto.action.response.GuildMemberProfileResp;
import com.mikuac.shiro.dto.action.response.GuildMetaByGuestResp;
import com.mikuac.shiro.dto.action.response.GuildServiceProfileResp;
import com.mikuac.shiro.dto.action.response.LoginInfoResp;
import com.mikuac.shiro.dto.action.response.OcrResp;
import com.mikuac.shiro.dto.action.response.StrangerInfoResp;
import com.mikuac.shiro.dto.action.response.UnidirectionalFriendListResp;
import com.mikuac.shiro.dto.action.response.UrlResp;
import com.mikuac.shiro.dto.action.response.WordSlicesResp;
import com.mikuac.shiro.dto.event.message.AnyMessageEvent;
import com.mikuac.shiro.enums.ActionPath;
import com.mikuac.shiro.enums.ActionPathEnum;
import com.mikuac.shiro.handler.ActionHandler;
import com.mikuac.shiro.model.ArrayMsg;
import com.mikuac.shiro.model.HandlerMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.WebSocketSession;

public class Bot
implements OneBot,
GoCQHTTPExtend,
GensokyoExtend,
LagrangeExtend,
LLOneBotExtend {
    private long selfId;
    private ActionHandler actionHandler;
    private WebSocketSession session;
    private List<Class<? extends BotPlugin>> pluginList;
    private MultiValueMap<Class<? extends Annotation>, HandlerMethod> annotationHandler;
    private Class<? extends BotMessageEventInterceptor> botMessageEventInterceptor;

    public Bot(long selfId, WebSocketSession session, ActionHandler actionHandler, List<Class<? extends BotPlugin>> pluginList, MultiValueMap<Class<? extends Annotation>, HandlerMethod> annotationHandler, Class<? extends BotMessageEventInterceptor> botMessageEventInterceptor) {
        this.selfId = selfId;
        this.session = session;
        this.actionHandler = actionHandler;
        this.pluginList = pluginList;
        this.annotationHandler = annotationHandler;
        this.botMessageEventInterceptor = botMessageEventInterceptor;
    }

    @Override
    public ActionData<MsgId> sendMsg(AnyMessageEvent event, String msg, boolean autoEscape) {
        if ("private".equals(event.getMessageType())) {
            return this.sendPrivateMsg((long)event.getUserId(), msg, autoEscape);
        }
        if ("group".equals(event.getMessageType())) {
            return this.sendGroupMsg((long)event.getGroupId(), msg, autoEscape);
        }
        return null;
    }

    @Override
    public ActionData<MsgId> sendMsg(AnyMessageEvent event, List<ArrayMsg> msg, boolean autoEscape) {
        if ("private".equals(event.getMessageType())) {
            return this.sendPrivateMsg((long)event.getUserId(), msg, autoEscape);
        }
        if ("group".equals(event.getMessageType())) {
            return this.sendGroupMsg((long)event.getGroupId(), msg, autoEscape);
        }
        return null;
    }

    @Override
    public ActionData<MsgId> sendPrivateMsg(long userId, String msg, boolean autoEscape) {
        JSONObject params = new JSONObject();
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"message", (Object)msg);
        params.put((Object)"auto_escape", (Object)autoEscape);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendPrivateMsg(long userId, List<ArrayMsg> msg, boolean autoEscape) {
        JSONObject params = new JSONObject();
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"message", msg);
        params.put((Object)"auto_escape", (Object)autoEscape);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendPrivateMsg(long groupId, long userId, String msg, boolean autoEscape) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"message", (Object)msg);
        params.put((Object)"auto_escape", (Object)autoEscape);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendPrivateMsg(long groupId, long userId, List<ArrayMsg> msg, boolean autoEscape) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"message", msg);
        params.put((Object)"auto_escape", (Object)autoEscape);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupMsg(long groupId, String msg, boolean autoEscape) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"message", (Object)msg);
        params.put((Object)"auto_escape", (Object)autoEscape);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupMsg(long groupId, List<ArrayMsg> msg, boolean autoEscape) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"message", msg);
        params.put((Object)"auto_escape", (Object)autoEscape);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupMsg(long groupId, long userId, String msg, boolean autoEscape) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"message", (Object)msg);
        params.put((Object)"auto_escape", (Object)autoEscape);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupMsg(long groupId, long userId, List<ArrayMsg> msg, boolean autoEscape) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"message", msg);
        params.put((Object)"auto_escape", (Object)autoEscape);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GuildMemberListResp> getGuildMemberList(String guildId, String nextToken) {
        JSONObject params = new JSONObject();
        params.put((Object)"guild_id", (Object)guildId);
        params.put((Object)"next_token", (Object)nextToken);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_LIST, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GuildMemberListResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GuildMsgId> sendGuildMsg(String guildId, String channelId, String msg) {
        JSONObject params = new JSONObject();
        params.put((Object)"guild_id", (Object)guildId);
        params.put((Object)"channel_id", (Object)channelId);
        params.put((Object)"message", (Object)msg);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GUILD_CHANNEL_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GuildMsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GetGuildMsgResp> getGuildMsg(String guildMsgId, boolean noCache) {
        JSONObject params = new JSONObject();
        params.put((Object)"message_id", (Object)guildMsgId);
        params.put((Object)"no_cache", (Object)noCache);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GetGuildMsgResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GuildServiceProfileResp> getGuildServiceProfile() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_SERVICE_PROFILE, null);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GuildServiceProfileResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionList<GuildListResp> getGuildList() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_LIST, null);
        return result != null ? (ActionList)result.to(new TypeReference<ActionList<GuildListResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GuildMetaByGuestResp> getGuildMetaByGuest(String guildId) {
        JSONObject params = new JSONObject();
        params.put((Object)"guild_id", (Object)guildId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_META_BY_GUEST, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GuildMetaByGuestResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionList<ChannelInfoResp> getGuildChannelList(String guildId, boolean noCache) {
        JSONObject params = new JSONObject();
        params.put((Object)"guild_id", (Object)guildId);
        params.put((Object)"no_cache", (Object)noCache);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_CHANNEL_LIST, (Map<String, Object>)params);
        return result != null ? (ActionList)result.to(new TypeReference<ActionList<ChannelInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GuildMemberProfileResp> getGuildMemberProfile(String guildId, String userId) {
        JSONObject params = new JSONObject();
        params.put((Object)"guild_id", (Object)guildId);
        params.put((Object)"user_id", (Object)userId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_MEMBER_PROFILE, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GuildMemberProfileResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GetMsgResp> getMsg(int msgId) {
        JSONObject params = new JSONObject();
        params.put((Object)"message_id", (Object)msgId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GetMsgResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw deleteMsg(int msgId) {
        JSONObject params = new JSONObject();
        params.put((Object)"message_id", (Object)msgId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_MSG, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw deleteMsg(long groupId, long userId, int msgId) {
        JSONObject params = new JSONObject();
        params.put((Object)"message_id", (Object)msgId);
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_MSG, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupKick(long groupId, long userId, boolean rejectAddRequest) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"reject_add_request", (Object)rejectAddRequest);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_KICK, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupBan(long groupId, long userId, int duration) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"duration", (Object)duration);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_BAN, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupWholeBan(long groupId, boolean enable) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"enable", (Object)enable);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_WHOLE_BAN, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupAdmin(long groupId, long userId, boolean enable) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"enable", (Object)enable);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ADMIN, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupAnonymous(long groupId, boolean enable) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"enable", (Object)enable);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ANONYMOUS, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupCard(long groupId, long userId, String card) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"card", (Object)card);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_CARD, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupName(long groupId, String groupName) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"group_name", (Object)groupName);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_NAME, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupLeave(long groupId, boolean isDismiss) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"is_dismiss", (Object)isDismiss);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_LEAVE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupSpecialTitle(long groupId, long userId, String specialTitle, int duration) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"special_title", (Object)specialTitle);
        params.put((Object)"duration", (Object)duration);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_SPECIAL_TITLE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setFriendAddRequest(String flag, boolean approve, String remark) {
        JSONObject params = new JSONObject();
        params.put((Object)"flag", (Object)flag);
        params.put((Object)"approve", (Object)approve);
        params.put((Object)"remark", (Object)remark);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_FRIEND_ADD_REQUEST, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupAddRequest(String flag, String subType, boolean approve, String reason) {
        JSONObject params = new JSONObject();
        params.put((Object)"flag", (Object)flag);
        params.put((Object)"sub_type", (Object)subType);
        params.put((Object)"approve", (Object)approve);
        params.put((Object)"reason", (Object)reason);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ADD_REQUEST, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<LoginInfoResp> getLoginInfo() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_LOGIN_INFO, null);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<LoginInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<StrangerInfoResp> getStrangerInfo(long userId, boolean noCache) {
        JSONObject params = new JSONObject();
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"no_cache", (Object)noCache);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_STRANGER_INFO, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<StrangerInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionList<FriendInfoResp> getFriendList() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_FRIEND_LIST, null);
        return result != null ? (ActionList)result.to(new TypeReference<ActionList<FriendInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw deleteFriend(long friendId) {
        JSONObject params = new JSONObject();
        params.put((Object)"user_id", (Object)friendId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_FRIEND, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GroupInfoResp> getGroupInfo(long groupId, boolean noCache) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"no_cache", (Object)noCache);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_INFO, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GroupInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionList<GroupInfoResp> getGroupList() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_LIST, null);
        return result != null ? (ActionList)result.to(new TypeReference<ActionList<GroupInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GroupMemberInfoResp> getGroupMemberInfo(long groupId, long userId, boolean noCache) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"no_cache", (Object)noCache);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_MEMBER_INFO, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GroupMemberInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionList<GroupMemberInfoResp> getGroupMemberList(long groupId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_MEMBER_LIST, (Map<String, Object>)params);
        return result != null ? (ActionList)result.to(new TypeReference<ActionList<GroupMemberInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GroupHonorInfoResp> getGroupHonorInfo(long groupId, String type) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"type", (Object)type);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_HONOR_INFO, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GroupHonorInfoResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<BooleanResp> canSendImage() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.CAN_SEND_IMAGE, null);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<BooleanResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<BooleanResp> canSendRecord() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.CAN_SEND_RECORD, null);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<BooleanResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupPortrait(long groupId, String file, int cache) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"file", (Object)file);
        params.put((Object)"cache", (Object)cache);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_PORTRAIT, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<CheckUrlSafelyResp> checkUrlSafely(String url) {
        JSONObject params = new JSONObject();
        params.put((Object)"url", (Object)url);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.CHECK_URL_SAFELY, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<CheckUrlSafelyResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw sendGroupNotice(long groupId, String content) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"content", (Object)content);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEN_GROUP_NOTICE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GroupAtAllRemainResp> getGroupAtAllRemain(long groupId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_AT_ALL_REMAIN, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GroupAtAllRemainResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw uploadGroupFile(long groupId, String file, String name, String folder) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"file", (Object)file);
        params.put((Object)"name", (Object)name);
        params.put((Object)"folder", (Object)folder);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.UPLOAD_GROUP_FILE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw uploadGroupFile(long groupId, String file, String name) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"file", (Object)file);
        params.put((Object)"name", (Object)name);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.UPLOAD_GROUP_FILE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupAnonymousBan(long groupId, Anonymous anonymous, int duration) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"anonymous", (Object)anonymous);
        params.put((Object)"duration", (Object)duration);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ANONYMOUS_BAN, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setGroupAnonymousBan(long groupId, String flag, int duration) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"flag", (Object)flag);
        params.put((Object)"duration", (Object)duration);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ANONYMOUS_BAN, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<DownloadFileResp> downloadFile(String url, int threadCount, String headers) {
        JSONObject params = new JSONObject();
        params.put((Object)"url", (Object)url);
        params.put((Object)"headers", (Object)headers);
        params.put((Object)"thread_count", (Object)threadCount);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DOWNLOAD_FILE, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<DownloadFileResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<DownloadFileResp> downloadFile(String url) {
        JSONObject params = new JSONObject();
        params.put((Object)"url", (Object)url);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DOWNLOAD_FILE, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<DownloadFileResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupForwardMsg(long groupId, List<Map<String, Object>> msg) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"messages", msg);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_FORWARD_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GroupFilesResp> getGroupRootFiles(long groupId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_ROOT_FILES, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GroupFilesResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GroupFilesResp> getGroupFilesByFolder(long groupId, String folderId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"folder_id", (Object)folderId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_FILES_BY_FOLDER, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GroupFilesResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionList<EssenceMsgResp> getEssenceMsgList(long groupId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_ESSENCE_MSG_LIST, (Map<String, Object>)params);
        return result != null ? (ActionList)result.to(new TypeReference<ActionList<EssenceMsgResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setEssenceMsg(int msgId) {
        JSONObject params = new JSONObject();
        params.put((Object)"message_id", (Object)msgId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_ESSENCE_MSG, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw deleteEssenceMsg(int msgId) {
        JSONObject params = new JSONObject();
        params.put((Object)"message_id", (Object)msgId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_ESSENCE_MSG, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw setBotProfile(String nickname, String company, String email, String college, String personalNote) {
        JSONObject params = new JSONObject();
        params.put((Object)"nickname", (Object)nickname);
        params.put((Object)"company", (Object)company);
        params.put((Object)"email", (Object)email);
        params.put((Object)"college", (Object)college);
        params.put((Object)"personalNote", (Object)personalNote);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SET_QQ_PROFILE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendPrivateForwardMsg(long userId, List<Map<String, Object>> msg) {
        JSONObject params = new JSONObject();
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"messages", msg);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_FORWARD_MSG, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<MsgId> sendForwardMsg(AnyMessageEvent event, List<Map<String, Object>> msg) {
        JSONObject result;
        JSONObject params = new JSONObject();
        params.put((Object)"messages", msg);
        if ("group".equals(event.getMessageType())) {
            params.put((Object)"group_id", (Object)event.getGroupId());
        }
        if ("private".equals(event.getMessageType())) {
            params.put((Object)"user_id", (Object)event.getUserId());
        }
        return (result = this.actionHandler.action(this.session, ActionPathEnum.SEND_FORWARD_MSG, (Map<String, Object>)params)) != null ? (ActionData)result.to(new TypeReference<ActionData<MsgId>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<WordSlicesResp> getWordSlices(String content) {
        JSONObject params = new JSONObject();
        params.put((Object)"content", (Object)content);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_WORD_SLICES, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<WordSlicesResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<ClientsResp> getOnlineClients(boolean noCache) {
        JSONObject params = new JSONObject();
        params.put((Object)"no_cache", (Object)noCache);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_ONLINE_CLIENTS, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<ClientsResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<OcrResp> ocrImage(String image) {
        JSONObject params = new JSONObject();
        params.put((Object)"image", (Object)image);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.OCR_IMAGE, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<OcrResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw uploadPrivateFile(long userId, String file, String name) {
        JSONObject params = new JSONObject();
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"file", (Object)file);
        params.put((Object)"name", (Object)name);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.UPLOAD_PRIVATE_FILE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw sendGroupSign(long groupId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_SIGN, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw deleteUnidirectionalFriend(long userId) {
        JSONObject params = new JSONObject();
        params.put((Object)"user_id", (Object)userId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_UNIDIRECTIONAL_FRIEND, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionList<UnidirectionalFriendListResp> getUnidirectionalFriendList() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_UNIDIRECTIONAL_FRIEND_LIST, null);
        return result != null ? (ActionList)result.to(new TypeReference<ActionList<UnidirectionalFriendListResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<UrlResp> getGroupFileUrl(long groupId, String fileId, int busId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"file_id", (Object)fileId);
        params.put((Object)"busid", (Object)busId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_FILE_URL, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<UrlResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionData<GroupFilesResp> getFile(long groupId, String fileId, int busId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"file_id", (Object)fileId);
        params.put((Object)"busid", (Object)busId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_FILE, (Map<String, Object>)params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<GroupFilesResp>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw createGroupFileFolder(long groupId, String folderName) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"name", (Object)folderName);
        params.put((Object)"parent_id", (Object)"/");
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.CREATE_GROUP_FILE_FOLDER, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw deleteGroupFileFolder(long groupId, String folderId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"folder_id", (Object)folderId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_GROUP_FOLDER, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw deleteGroupFile(long groupId, String fileId, int busId) {
        JSONObject params = new JSONObject();
        params.put((Object)"group_id", (Object)groupId);
        params.put((Object)"file_id", (Object)fileId);
        params.put((Object)"busid", (Object)busId);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_GROUP_FILE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public ActionRaw sendLike(long userId, int times) {
        JSONObject params = new JSONObject();
        params.put((Object)"user_id", (Object)userId);
        params.put((Object)"times", (Object)times);
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.SEND_LIKE, (Map<String, Object>)params);
        return result != null ? (ActionRaw)result.to(ActionRaw.class, new JSONReader.Feature[0]) : null;
    }

    @Override
    public GetStatusResp getStatus() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.GET_STATUS, null);
        return result != null ? (GetStatusResp)((ActionData)result.to((TypeReference)new TypeReference<ActionData<GetStatusResp>>(){}, new JSONReader.Feature[0])).getData() : null;
    }

    @Override
    public ActionList<String> fetchCustomFace() {
        JSONObject result = this.actionHandler.action(this.session, ActionPathEnum.FETCH_CUSTOM_FACE, null);
        return result != null ? (ActionList)result.to(new TypeReference<ActionList<String>>(){}.getType(), new JSONReader.Feature[0]) : null;
    }

    public ActionData customRequest(ActionPath action, Map<String, Object> params) {
        JSONObject result = this.actionHandler.action(this.session, action, params);
        return result != null ? (ActionData)result.to(ActionData.class, new JSONReader.Feature[0]) : null;
    }

    public <T> ActionData<T> customRequest(ActionPath action, Map<String, Object> params, Class<T> clazz) {
        JSONObject result = this.actionHandler.action(this.session, action, params);
        return result != null ? (ActionData)result.to(new TypeReference<ActionData<T>>(new Type[]{clazz}){}, new JSONReader.Feature[0]) : null;
    }

    public long getSelfId() {
        return this.selfId;
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    public List<Class<? extends BotPlugin>> getPluginList() {
        return this.pluginList;
    }

    public MultiValueMap<Class<? extends Annotation>, HandlerMethod> getAnnotationHandler() {
        return this.annotationHandler;
    }

    public Class<? extends BotMessageEventInterceptor> getBotMessageEventInterceptor() {
        return this.botMessageEventInterceptor;
    }

    public void setSelfId(long selfId) {
        this.selfId = selfId;
    }

    public void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    public void setPluginList(List<Class<? extends BotPlugin>> pluginList) {
        this.pluginList = pluginList;
    }

    public void setAnnotationHandler(MultiValueMap<Class<? extends Annotation>, HandlerMethod> annotationHandler) {
        this.annotationHandler = annotationHandler;
    }

    public void setBotMessageEventInterceptor(Class<? extends BotMessageEventInterceptor> botMessageEventInterceptor) {
        this.botMessageEventInterceptor = botMessageEventInterceptor;
    }
}

