/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.event;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.mikuac.shiro.common.utils.EventUtils;
import com.mikuac.shiro.common.utils.GroupMessageFilterUtils;
import com.mikuac.shiro.common.utils.ShiroUtils;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.core.BotContainer;
import com.mikuac.shiro.dto.event.message.GroupMessageEvent;
import com.mikuac.shiro.dto.event.message.GuildMessageEvent;
import com.mikuac.shiro.dto.event.message.PrivateMessageEvent;
import com.mikuac.shiro.enums.MessageEventEnum;
import com.mikuac.shiro.handler.injection.InjectionHandler;
import com.mikuac.shiro.properties.ShiroProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageEvent {
    private static final Logger log = LoggerFactory.getLogger(MessageEvent.class);
    private EventUtils utils;
    private ShiroProperties shiroProperties;
    private BotContainer botContainer;
    private InjectionHandler injection;
    public final Map<String, BiConsumer<Bot, JSONObject>> handlers = new HashMap<String, BiConsumer<Bot, JSONObject>>();

    @Autowired
    public void setUtils(EventUtils utils, ShiroProperties shiroProperties, BotContainer botContainer) {
        this.utils = utils;
        this.shiroProperties = shiroProperties;
        this.botContainer = botContainer;
    }

    @Autowired
    public void setInjection(InjectionHandler injection) {
        this.injection = injection;
    }

    public void handler(Bot bot, JSONObject resp) {
        String type = resp.getString("message_type");
        this.handlers.getOrDefault(type, (b, e) -> {}).accept(bot, resp);
    }

    private void process(Bot bot, JSONObject resp, MessageEventEnum type) {
        try {
            com.mikuac.shiro.dto.event.message.MessageEvent event;
            if (type == MessageEventEnum.FRIEND) {
                event = (PrivateMessageEvent)resp.to(PrivateMessageEvent.class, new JSONReader.Feature[0]);
                if (this.utils.setInterceptor(bot, event)) {
                    return;
                }
                ShiroUtils.rawConvert(event.getMessage(), event);
                resp.put((Object)"message", (Object)event.getMessage());
                this.utils.pushAnyMessageEvent(bot, resp, event.getArrayMsg());
                this.injection.invokePrivateMessage(bot, (PrivateMessageEvent)event);
                bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$1(bot, (PrivateMessageEvent)event, arg_0));
                this.utils.getInterceptor(bot.getBotMessageEventInterceptor()).afterCompletion(bot, event);
            }
            if (type == MessageEventEnum.GROUP) {
                event = (GroupMessageEvent)resp.to(GroupMessageEvent.class, new JSONReader.Feature[0]);
                if (Boolean.TRUE.equals(this.shiroProperties.getGroupEventFilter())) {
                    Long senderId = ((GroupMessageEvent)event).getSender().getUserId();
                    if (!GroupMessageFilterUtils.insertMessage((GroupMessageEvent)event, this.shiroProperties.getGroupEventFilterTime()) || this.shiroProperties.getGroupSelfBotEventFilter().booleanValue() && this.botContainer.robots.containsKey(senderId)) {
                        return;
                    }
                }
                if (this.utils.setInterceptor(bot, event)) {
                    return;
                }
                ShiroUtils.rawConvert(event.getMessage(), event);
                resp.put((Object)"message", (Object)event.getMessage());
                this.utils.pushAnyMessageEvent(bot, resp, event.getArrayMsg());
                this.injection.invokeGroupMessage(bot, (GroupMessageEvent)event);
                bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$2(bot, (GroupMessageEvent)event, arg_0));
                this.utils.getInterceptor(bot.getBotMessageEventInterceptor()).afterCompletion(bot, event);
            }
            if (type == MessageEventEnum.GUILD) {
                event = (GuildMessageEvent)resp.to(GuildMessageEvent.class, new JSONReader.Feature[0]);
                if (this.utils.setInterceptor(bot, event)) {
                    return;
                }
                ShiroUtils.rawConvert(event.getMessage(), event);
                this.injection.invokeGuildMessage(bot, (GuildMessageEvent)event);
                bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$3(bot, (GuildMessageEvent)event, arg_0));
                this.utils.getInterceptor(bot.getBotMessageEventInterceptor()).afterCompletion(bot, event);
            }
        }
        catch (Exception e) {
            log.error("Message event process exception: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void friend(Bot bot, JSONObject resp) {
        this.process(bot, resp, MessageEventEnum.FRIEND);
    }

    public void group(Bot bot, JSONObject resp) {
        this.process(bot, resp, MessageEventEnum.GROUP);
    }

    public void guild(Bot bot, JSONObject resp) {
        this.process(bot, resp, MessageEventEnum.GUILD);
    }

    private /* synthetic */ boolean lambda$process$3(Bot bot, GuildMessageEvent event, Class o) {
        return this.utils.getPlugin(o).onGuildMessage(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$2(Bot bot, GroupMessageEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupMessage(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$1(Bot bot, PrivateMessageEvent event, Class o) {
        return this.utils.getPlugin(o).onPrivateMessage(bot, event) == 1;
    }
}

