/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.task;

import com.mikuac.shiro.properties.TaskPoolProperties;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ShiroTaskPoolConfig {
    private TaskPoolProperties taskPoolProperties;

    @Autowired
    public void setTaskPoolProperties(TaskPoolProperties taskPoolProperties) {
        this.taskPoolProperties = taskPoolProperties;
    }

    @Bean(value={"shiroTaskExecutor"})
    @ConditionalOnProperty(value={"shiro.task-pool.enable-task-pool"}, havingValue="true", matchIfMissing=true)
    public ThreadPoolTaskExecutor shiroTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.taskPoolProperties.getCorePoolSize().intValue());
        executor.setMaxPoolSize(this.taskPoolProperties.getMaxPoolSize().intValue());
        executor.setQueueCapacity(this.taskPoolProperties.getQueueCapacity().intValue());
        executor.setKeepAliveSeconds(this.taskPoolProperties.getKeepAliveTime().intValue());
        executor.setThreadNamePrefix(this.taskPoolProperties.getThreadNamePrefix());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.initialize();
        return executor;
    }
}

