/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.boot;

import ch.qos.logback.classic.Level;
import com.mikuac.shiro.adapter.WebSocketClientHandler;
import com.mikuac.shiro.adapter.WebSocketServerHandler;
import com.mikuac.shiro.boot.Shiro;
import com.mikuac.shiro.properties.ShiroProperties;
import com.mikuac.shiro.properties.WebSocketClientProperties;
import com.mikuac.shiro.properties.WebSocketProperties;
import com.mikuac.shiro.properties.WebSocketServerProperties;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.WebSocketConnectionManager;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Component
@EnableAsync
@EnableWebSocket
@Import(value={Shiro.class})
@ComponentScan(value={"com.mikuac.shiro"})
public class ShiroAutoConfiguration
implements WebSocketConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ShiroAutoConfiguration.class);
    private WebSocketServerProperties wsServerProp;
    private WebSocketClientProperties wsClientProp;
    private ScheduledExecutorService scheduledExecutorService;
    private WebSocketProperties wsProp;
    private ShiroProperties shiroProperties;
    private WebSocketServerHandler webSocketServerHandler;
    private WebSocketClientHandler webSocketClientHandler;

    @Autowired
    public void setWebSocketServerProperties(WebSocketServerProperties wsServerProp) {
        this.wsServerProp = wsServerProp;
    }

    @Autowired
    public void setWebSocketClientProperties(WebSocketClientProperties wsClientProp) {
        this.wsClientProp = wsClientProp;
    }

    @Autowired
    public void setScheduledExecutorService(ThreadPoolTaskExecutor shiroTaskExecutor) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(shiroTaskExecutor.getCorePoolSize(), shiroTaskExecutor.getThreadPoolExecutor().getThreadFactory());
        executor.setRemoveOnCancelPolicy(true);
        this.scheduledExecutorService = executor;
    }

    @Autowired
    public void setWebSocketProperties(WebSocketProperties wsProp) {
        this.wsProp = wsProp;
    }

    @Autowired
    public void setShiroProperties(ShiroProperties shiroProperties) {
        this.shiroProperties = shiroProperties;
        WebSocketServerHandler.setWaitWebsocketConnect(shiroProperties.getWaitBotConnect());
    }

    @Autowired(required=false)
    public void setWebSocketServerHandler(WebSocketServerHandler webSocketServerHandler) {
        this.webSocketServerHandler = webSocketServerHandler;
    }

    @Autowired(required=false)
    public void setWebSocketClientHandler(WebSocketClientHandler webSocketClientHandler) {
        this.webSocketClientHandler = webSocketClientHandler;
    }

    public void registerWebSocketHandlers(@Nonnull WebSocketHandlerRegistry registry) {
        this.setLogLevel();
        if (Boolean.TRUE.equals(this.wsServerProp.getEnable()) && Boolean.TRUE.equals(this.wsClientProp.getEnable())) {
            log.error("Cannot be simultaneously enabled ws client and server");
            System.exit(0);
            return;
        }
        if (Boolean.TRUE.equals(this.wsServerProp.getEnable())) {
            registry.addHandler((WebSocketHandler)this.webSocketServerHandler, new String[]{this.wsServerProp.getUrl()}).setAllowedOrigins(new String[]{"*"});
        }
        if (Boolean.TRUE.equals(this.wsClientProp.getEnable())) {
            this.createWebsocketClient();
        }
    }

    private void setLogLevel() {
        if (Boolean.TRUE.equals(this.shiroProperties.getDebug())) {
            ch.qos.logback.classic.Logger pkg = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"com.mikuac.shiro");
            pkg.setLevel(Level.DEBUG);
            log.warn("Enabled debug mode");
        }
    }

    private void createWebsocketClient() {
        StandardWebSocketClient client = new StandardWebSocketClient();
        WebSocketHttpHeaders headers = new WebSocketHttpHeaders();
        if (!Objects.equals(this.wsProp.getAccessToken(), "")) {
            headers.add("Authorization", this.wsProp.getAccessToken());
        }
        WebSocketConnectionManager manager = new WebSocketConnectionManager((WebSocketClient)client, (WebSocketHandler)this.webSocketClientHandler, this.wsClientProp.getUrl(), new Object[0]);
        manager.setHeaders((HttpHeaders)headers);
        manager.setAutoStartup(true);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            if (!manager.isConnected()) {
                manager.startInternal();
            }
        }, 0L, this.wsClientProp.getReconnectInterval().intValue(), TimeUnit.SECONDS);
    }
}

