/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.limit;

import com.mikuac.shiro.properties.RateLimiterProperties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class RateLimiter
implements ApplicationRunner {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private long rate;
    private long capacity;
    private long currentTokenQuantities;
    private int timeout;

    @Autowired
    public void setProperties(RateLimiterProperties properties) {
        this.capacity = properties.getCapacity().intValue();
        this.rate = properties.getRate().intValue();
        this.timeout = properties.getTimeout();
        this.currentTokenQuantities = this.capacity;
    }

    public void run(ApplicationArguments args) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                RateLimiter.this.supplementToken();
            }
        }, 0L, 1000L);
    }

    public boolean acquire() {
        return this.acquire(1);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    public boolean tryAcquire(int permits) {
        this.lock.lock();
        try {
            boolean bl = this.getToken(permits);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(int permits) {
        this.lock.lock();
        try {
            boolean await;
            while (!this.getToken(permits)) {
                await = this.condition.await(this.timeout, TimeUnit.SECONDS);
                if (!await) continue;
                boolean bl = false;
                return bl;
            }
            await = true;
            return await;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean getToken(int permits) {
        if ((long)permits > this.currentTokenQuantities) {
            return false;
        }
        this.currentTokenQuantities -= (long)permits;
        return true;
    }

    private void supplementToken() {
        this.lock.lock();
        try {
            this.currentTokenQuantities = Math.min(this.currentTokenQuantities + this.rate, this.capacity);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

