/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import java.lang.reflect.Field;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ReflectionUtils;

public class AopTargetUtils {
    private AopTargetUtils() {
    }

    public static Object getTarget(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        proxy = AopUtils.isJdkDynamicProxy((Object)proxy) ? AopTargetUtils.getJdkDynamicProxyTargetObject(proxy) : AopTargetUtils.getCglibProxyTargetObject(proxy);
        return AopTargetUtils.getTarget(proxy);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        ReflectionUtils.makeAccessible((Field)h);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        ReflectionUtils.makeAccessible((Field)advised);
        return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        ReflectionUtils.makeAccessible((Field)h);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        ReflectionUtils.makeAccessible((Field)advised);
        return ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
    }
}

