/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.mikuac.shiro.common.utils.OneBotMedia;
import com.mikuac.shiro.common.utils.ShiroUtils;

public class MsgUtils {
    private final StringBuilder builder = new StringBuilder();

    public static MsgUtils builder() {
        return new MsgUtils();
    }

    public MsgUtils text(String text) {
        this.builder.append(text);
        return this;
    }

    public MsgUtils img(String img) {
        String code = String.format("[CQ:image,file=%s]", ShiroUtils.escape(img));
        this.builder.append(code);
        return this;
    }

    public MsgUtils img(OneBotMedia media) {
        this.builder.append("[CQ:image,").append(media.escape()).append("]");
        return this;
    }

    public MsgUtils video(String video, String cover) {
        String code = String.format("[CQ:video,file=%s,cover=%s]", ShiroUtils.escape(video), ShiroUtils.escape(cover));
        this.builder.append(code);
        return this;
    }

    public MsgUtils flashImg(String img) {
        String code = String.format("[CQ:image,type=flash,file=%s]", ShiroUtils.escape(img));
        this.builder.append(code);
        return this;
    }

    public MsgUtils face(int id) {
        String code = String.format("[CQ:face,id=%s]", id);
        this.builder.append(code);
        return this;
    }

    public MsgUtils voice(OneBotMedia media) {
        this.builder.append("[CQ:record,").append(media.escape()).append("]");
        return this;
    }

    public MsgUtils voice(String voice) {
        String code = String.format("[CQ:record,file=%s]", ShiroUtils.escape(voice));
        this.builder.append(code);
        return this;
    }

    public MsgUtils at(long userId) {
        String code = String.format("[CQ:at,qq=%s]", userId);
        this.builder.append(code);
        return this;
    }

    public MsgUtils atAll() {
        this.builder.append("[CQ:at,qq=all]");
        return this;
    }

    public MsgUtils poke(long userId) {
        String code = String.format("[CQ:poke,qq=%s]", userId);
        this.builder.append(code);
        return this;
    }

    public MsgUtils reply(int msgId) {
        String code = String.format("[CQ:reply,id=%s]", msgId);
        this.builder.append(code);
        return this;
    }

    public MsgUtils reply(String msgId) {
        String code = String.format("[CQ:reply,id=\"%s\"]", msgId);
        this.builder.append(code);
        return this;
    }

    public MsgUtils gift(long userId, int giftId) {
        String code = String.format("[CQ:gift,qq=%s,id=%s]", userId, giftId);
        this.builder.append(code);
        return this;
    }

    public MsgUtils tts(String text) {
        String code = String.format("[CQ:tts,text=%s]", ShiroUtils.escape(text));
        this.builder.append(code);
        return this;
    }

    public MsgUtils xml(String data) {
        String xmlCode = String.format("[CQ:xml,data=%s]", ShiroUtils.escape(data));
        this.builder.append(xmlCode);
        return this;
    }

    public MsgUtils xml(String data, int resId) {
        String code = String.format("[CQ:xml,data=%s,resid=%s]", ShiroUtils.escape(data), resId);
        this.builder.append(code);
        return this;
    }

    public MsgUtils json(String data) {
        String code = String.format("[CQ:json,data=%s]", ShiroUtils.escape(data));
        this.builder.append(code);
        return this;
    }

    public MsgUtils json(String data, int resId) {
        String code = String.format("[CQ:json,data=%s,resid=%s]", ShiroUtils.escape(data), resId);
        this.builder.append(code);
        return this;
    }

    public MsgUtils cardImage(String file) {
        String code = String.format("[CQ:cardimage,file=%s]", ShiroUtils.escape(file));
        this.builder.append(code);
        return this;
    }

    public MsgUtils cardImage(String file, long minWidth, long minHeight, long maxWidth, long maxHeight, String source, String icon) {
        String code = String.format("[CQ:cardimage,file=%s,minwidth=%s,minheight=%s,maxwidth=%s,maxheight=%s,source=%s,icon=%s]", ShiroUtils.escape(file), minWidth, minHeight, maxWidth, maxHeight, ShiroUtils.escape(source), ShiroUtils.escape(icon));
        this.builder.append(code);
        return this;
    }

    public MsgUtils music(String type, long id) {
        String code = String.format("[CQ:music,type=%s,id=%s]", ShiroUtils.escape(type), id);
        this.builder.append(code);
        return this;
    }

    public MsgUtils customMusic(String url, String audio, String title, String content, String image) {
        String code = String.format("[CQ:music,type=custom,url=%s,audio=%s,title=%s,content=%s,image=%s]", ShiroUtils.escape(url), ShiroUtils.escape(audio), ShiroUtils.escape(title), ShiroUtils.escape(content), ShiroUtils.escape(image));
        this.builder.append(code);
        return this;
    }

    public MsgUtils customMusic(String url, String audio, String title) {
        String code = String.format("[CQ:music,type=custom,url=%s,audio=%s,title=%s]", ShiroUtils.escape(url), ShiroUtils.escape(audio), ShiroUtils.escape(title));
        this.builder.append(code);
        return this;
    }

    public MsgUtils rps(int value) {
        String code = String.format("[CQ:rps,value=%s]", value);
        this.builder.append(code);
        return this;
    }

    public MsgUtils longMsg(String id) {
        String code = String.format("[CQ:longmsg,id=%s]", id);
        this.builder.append(code);
        return this;
    }

    public MsgUtils forward(String id) {
        String code = String.format("[CQ:forward,id=%s]", id);
        this.builder.append(code);
        return this;
    }

    public String build() {
        return this.builder.toString();
    }
}

