/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.alibaba.fastjson2.JSON;
import com.mikuac.shiro.common.utils.NetUtils;
import com.mikuac.shiro.common.utils.RegexUtils;
import com.mikuac.shiro.dto.event.message.MessageEvent;
import com.mikuac.shiro.enums.MsgTypeEnum;
import com.mikuac.shiro.model.ArrayMsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroUtils {
    private static final Logger log = LoggerFactory.getLogger(ShiroUtils.class);
    private static final String CQ_CODE_SPLIT = "(?<=\\[CQ:[^]]{1,99999}])|(?=\\[CQ:[^]]{1,99999}])";
    private static final String CQ_CODE_REGEX = "\\[CQ:([^,\\[\\]]+)((?:,[^,=\\[\\]]+=[^,\\[\\]]*)*)]";

    private ShiroUtils() {
    }

    public static boolean isAtAll(String msg) {
        return msg.contains("[CQ:at,qq=all]");
    }

    public static boolean isAtAll(List<ArrayMsg> arrayMsg) {
        return arrayMsg.stream().anyMatch(it -> "all".equals(it.getData().get("qq")));
    }

    public static List<Long> getAtList(List<ArrayMsg> arrayMsg) {
        return arrayMsg.stream().filter(it -> MsgTypeEnum.at == it.getType() && !"all".equals(it.getData().get("qq"))).map(it -> Long.parseLong(it.getData().get("qq"))).toList();
    }

    public static List<String> getMsgImgUrlList(List<ArrayMsg> arrayMsg) {
        return arrayMsg.stream().filter(it -> MsgTypeEnum.image == it.getType()).map(it -> it.getData().get("url")).toList();
    }

    public static List<String> getMsgVideoUrlList(List<ArrayMsg> arrayMsg) {
        return arrayMsg.stream().filter(it -> MsgTypeEnum.video == it.getType()).map(it -> it.getData().get("url")).toList();
    }

    public static String getGroupAvatar(long groupId, int size) {
        return String.format("https://p.qlogo.cn/gh/%s/%s/%s", groupId, groupId, size);
    }

    @Deprecated(since="2.1.3")
    public static String getNickname(long userId) {
        String url = String.format("https://r.qzone.qq.com/fcg-bin/cgi_get_portrait.fcg?uins=%s", userId);
        String result = NetUtils.asyncGet(url, 10);
        if (result != null && !result.isEmpty()) {
            String nickname = result.split(",")[6];
            return nickname.substring(1, nickname.length() - 1);
        }
        return null;
    }

    public static String getUserAvatar(long userId, int size) {
        return String.format("https://q2.qlogo.cn/headimg_dl?dst_uin=%s&spec=%s", userId, size);
    }

    public static String unescape(String string) {
        return string.replace("&#44;", ",").replace("&#91;", "[").replace("&#93;", "]").replace("&amp;", "&");
    }

    public static String escape(String string) {
        return string.replace("&", "&amp;").replace(",", "&#44;").replace("[", "&#91;").replace("]", "&#93;");
    }

    public static String escape2(String string) {
        return string.replace("[", "&#91;").replace("]", "&#93;");
    }

    public static List<ArrayMsg> rawToArrayMsg(@NonNull String msg) {
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        ArrayList<ArrayMsg> chain = new ArrayList<ArrayMsg>();
        try {
            Arrays.stream(msg.split(CQ_CODE_SPLIT)).filter(s -> !s.isEmpty()).forEach(s -> {
                Optional<Matcher> matcher = RegexUtils.matcher(CQ_CODE_REGEX, s);
                ArrayMsg item = new ArrayMsg();
                HashMap<String, String> data = new HashMap<String, String>();
                if (matcher.isEmpty()) {
                    item.setType(MsgTypeEnum.text);
                    data.put("text", ShiroUtils.unescape(s));
                    item.setData(data);
                }
                if (matcher.isPresent()) {
                    MsgTypeEnum type = MsgTypeEnum.typeOf(matcher.get().group(1));
                    String[] params = matcher.get().group(2).split(",");
                    item.setType(type);
                    Arrays.stream(params).filter(args -> !args.isEmpty()).forEach(args -> {
                        String k = args.substring(0, args.indexOf("="));
                        String v = ShiroUtils.unescape(args.substring(args.indexOf("=") + 1));
                        data.put(k, v);
                    });
                    item.setData(data);
                }
                chain.add(item);
            });
        }
        catch (Exception e) {
            log.error("Conversion failed: {}", (Object)e.getMessage());
        }
        return chain;
    }

    public static void rawConvert(@NonNull String msg, MessageEvent event) {
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (JSON.isValidArray((String)msg)) {
            List arrayMsg = JSON.parseArray((String)msg, ArrayMsg.class);
            event.setArrayMsg(arrayMsg);
            event.setMessage(ShiroUtils.arrayMsgToCode(arrayMsg));
            return;
        }
        event.setArrayMsg(ShiroUtils.rawToArrayMsg(msg));
    }

    public static String arrayMsgToCode(ArrayMsg arrayMsg) {
        StringBuilder builder = new StringBuilder();
        if (Objects.isNull((Object)arrayMsg.getType()) || MsgTypeEnum.unknown.equals((Object)arrayMsg.getType())) {
            builder.append("[CQ:").append((Object)MsgTypeEnum.unknown);
        } else {
            builder.append("[CQ:").append((Object)arrayMsg.getType());
        }
        arrayMsg.getData().forEach((k, v) -> builder.append(",").append((String)k).append("=").append((String)v));
        builder.append("]");
        return builder.toString();
    }

    public static String arrayMsgToCode(List<ArrayMsg> arrayMsgs) {
        StringBuilder builder = new StringBuilder();
        for (ArrayMsg item : arrayMsgs) {
            if (!MsgTypeEnum.text.equals((Object)item.getType())) {
                builder.append("[CQ:").append((Object)item.getType());
                item.getData().forEach((k, v) -> builder.append(",").append((String)k).append("=").append(ShiroUtils.escape(v)));
                builder.append("]");
                continue;
            }
            builder.append(ShiroUtils.escape(item.getData().get(MsgTypeEnum.text.toString())));
        }
        return builder.toString();
    }

    public static List<Map<String, Object>> generateForwardMsg(long uin, String name, List<String> contents) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        contents.forEach(msg -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", name);
            data.put("uin", uin);
            data.put("content", msg);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }

    public static List<Map<String, Object>> generateForwardMsg(List<String> contents) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        contents.forEach(msg -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("content", (String)msg);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }

    public static List<Map<String, Object>> generateForwardMsg(String uin, String name, List<?> contents) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        contents.forEach(msg -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", name);
            data.put("uin", uin);
            data.put("content", msg);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }

    public static List<Map<String, Object>> generateForwardMsg(List<String> contents, List<String> quoteMsgId) {
        List<Map<String, Object>> nodes = ShiroUtils.generateForwardMsg(contents);
        quoteMsgId.forEach(id -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", (String)id);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }
}

