/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.event;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.mikuac.shiro.common.utils.EventUtils;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.dto.event.notice.GroupHonorChangeNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupLuckyKingNoticeEvent;
import com.mikuac.shiro.dto.event.notice.NoticeEvent;
import com.mikuac.shiro.dto.event.notice.PokeNoticeEvent;
import com.mikuac.shiro.enums.NotifyEventEnum;
import com.mikuac.shiro.handler.injection.InjectionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyEvent {
    private EventUtils utils;
    private InjectionHandler injection;
    public final Map<String, BiConsumer<Bot, JSONObject>> handlers = new HashMap<String, BiConsumer<Bot, JSONObject>>();

    @Autowired
    public void setUtils(EventUtils utils) {
        this.utils = utils;
    }

    @Autowired
    public void setInjection(InjectionHandler injection) {
        this.injection = injection;
    }

    public void handler(Bot bot, JSONObject resp) {
        String type = resp.getString("sub_type");
        this.handlers.getOrDefault(type, (b, e) -> {}).accept(bot, resp);
    }

    private void process(Bot bot, JSONObject resp, NotifyEventEnum type) {
        NoticeEvent event;
        if (type == NotifyEventEnum.POKE) {
            event = (PokeNoticeEvent)resp.to(PokeNoticeEvent.class, new JSONReader.Feature[0]);
            if (((PokeNoticeEvent)event).getGroupId() != null && ((PokeNoticeEvent)event).getGroupId() > 0L) {
                this.injection.invokeGroupPokeNotice(bot, (PokeNoticeEvent)event);
                bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$1(bot, (PokeNoticeEvent)event, arg_0));
            } else {
                this.injection.invokePrivatePokeNotice(bot, (PokeNoticeEvent)event);
                bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$2(bot, (PokeNoticeEvent)event, arg_0));
            }
        }
        if (type == NotifyEventEnum.HONOR) {
            event = (GroupHonorChangeNoticeEvent)resp.to(GroupHonorChangeNoticeEvent.class, new JSONReader.Feature[0]);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$3(bot, (GroupHonorChangeNoticeEvent)event, arg_0));
        }
        if (type == NotifyEventEnum.LUCKY_KING) {
            event = (GroupLuckyKingNoticeEvent)resp.to(GroupLuckyKingNoticeEvent.class, new JSONReader.Feature[0]);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$4(bot, (GroupLuckyKingNoticeEvent)event, arg_0));
        }
    }

    public void poke(Bot bot, JSONObject resp) {
        this.process(bot, resp, NotifyEventEnum.POKE);
    }

    public void luckyKing(Bot bot, JSONObject resp) {
        this.process(bot, resp, NotifyEventEnum.LUCKY_KING);
    }

    public void honor(Bot bot, JSONObject resp) {
        this.process(bot, resp, NotifyEventEnum.HONOR);
    }

    private /* synthetic */ boolean lambda$process$4(Bot bot, GroupLuckyKingNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupLuckyKingNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$3(Bot bot, GroupHonorChangeNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupHonorChangeNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$2(Bot bot, PokeNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onPrivatePokeNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$1(Bot bot, PokeNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupPokeNotice(bot, event) == 1;
    }
}

