/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.model;

import com.mikuac.shiro.enums.MsgTypeEnum;
import java.util.Map;

public class ArrayMsg {
    private String type;
    private Map<String, String> data;

    public MsgTypeEnum getType() {
        return MsgTypeEnum.typeOf(this.type);
    }

    public ArrayMsg setType(MsgTypeEnum typeEnum) {
        this.type = typeEnum == null || !MsgTypeEnum.isValidMsgType(typeEnum) ? MsgTypeEnum.unknown.name() : typeEnum.name();
        return this;
    }

    public String getRowType() {
        return this.type;
    }

    public ArrayMsg setRowType(String type) {
        this.type = type;
        return this;
    }

    public String toCQCode() {
        if ("text".equalsIgnoreCase(this.type)) {
            return this.data.getOrDefault("text", "");
        }
        StringBuilder stringBuilder = new StringBuilder("[CQ:");
        stringBuilder.append(this.getRowType());
        this.data.forEach((key, val) -> {
            stringBuilder.append(',');
            stringBuilder.append((String)key);
            stringBuilder.append('=');
            stringBuilder.append((String)val);
        });
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public ArrayMsg setData(Map<String, String> data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayMsg)) {
            return false;
        }
        ArrayMsg other = (ArrayMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MsgTypeEnum this$type = this.getType();
        MsgTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Map<String, String> this$data = this.getData();
        Map<String, String> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArrayMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MsgTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Map<String, String> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "ArrayMsg(type=" + this.getType() + ", data=" + this.getData() + ")";
    }
}

