/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.core;

import com.mikuac.shiro.core.BotPlugin;
import com.mikuac.shiro.core.DependencyResolver;
import com.mikuac.shiro.properties.ShiroProperties;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class PluginManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private final ShiroProperties shiroProperties;
    private final ApplicationContext applicationContext;
    private final DependencyResolver dependencyResolver;
    private URLClassLoader pluginClassLoader;

    @PostConstruct
    public void initPlugins() {
        try {
            this.loadPlugins();
        }
        catch (IOException e) {
            log.error("Plugin loading failed due to I/O error", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Plugin loading failed", (Throwable)e);
        }
    }

    @PreDestroy
    public void cleanup() {
        if (this.pluginClassLoader != null) {
            try {
                this.pluginClassLoader.close();
                log.debug("Plugin class loader closed successfully");
            }
            catch (IOException e) {
                log.warn("Failed to close plugin class loader", (Throwable)e);
            }
        }
    }

    private void loadPlugins() throws IOException {
        File pluginDir = this.getPluginDirectory();
        if (pluginDir == null) {
            return;
        }
        ArrayList<URL> pluginUrls = new ArrayList<URL>();
        for (File jar : Objects.requireNonNull(pluginDir.listFiles((dir, name) -> name.endsWith(".jar")))) {
            Set<String> dependencies = this.parseDependencies(jar);
            log.info("Parsing plugin: {}", (Object)jar.getAbsolutePath());
            this.resolveDependencies(dependencies);
            pluginUrls.add(jar.toURI().toURL());
        }
        if (pluginUrls.isEmpty()) {
            return;
        }
        pluginUrls.addAll(this.scanDependencyJars());
        this.pluginClassLoader = this.createPluginClassLoader(pluginUrls);
        this.registerPlugins(this.pluginClassLoader);
    }

    private Set<String> parseDependencies(File jarFile) throws IOException {
        HashSet<String> dependencies = new HashSet<String>();
        try (JarFile jar = new JarFile(jarFile);){
            String deps;
            Manifest manifest = jar.getManifest();
            if (manifest != null && (deps = manifest.getMainAttributes().getValue("Dependencies")) != null) {
                dependencies.addAll(Arrays.asList(deps.split(",\\s*")));
            }
        }
        return dependencies;
    }

    private void resolveDependencies(Set<String> dependencies) {
        dependencies.stream().filter(this::isDependencyMissing).forEach(dep -> {
            try {
                this.dependencyResolver.resolveDependency((String)dep);
            }
            catch (ArtifactResolutionException e) {
                log.error("Failed to resolve dependency: {}", dep, (Object)e);
            }
        });
    }

    private boolean isDependencyMissing(String groupArtifact) {
        String[] parts = groupArtifact.split(":");
        try {
            Class.forName(parts[0].replace('.', '/') + "/" + parts[1] + "/Application");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    private List<URL> scanDependencyJars() throws IOException {
        File depDir = DependencyResolver.DEPENDENCIES_DIR;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (depDir.exists()) {
            try (Stream<Path> pathStream = Files.walk(depDir.toPath(), new FileVisitOption[0]);){
                pathStream.filter(path -> path.toString().endsWith(".jar")).forEach(path -> {
                    try {
                        urls.add(path.toUri().toURL());
                        log.debug("Added dependency: {}", (Object)path.getFileName());
                    }
                    catch (MalformedURLException e) {
                        log.error("Invalid dependency path: {}", path, (Object)e);
                    }
                });
            }
        }
        return urls;
    }

    private File getPluginDirectory() {
        String pluginScanPath = this.shiroProperties.getPluginScanPath();
        File pluginDir = new File(pluginScanPath);
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            log.info("Plugin directory does not exist or is not a directory: {}", (Object)pluginScanPath);
            return null;
        }
        return pluginDir;
    }

    private URLClassLoader createPluginClassLoader(List<URL> urls) {
        final ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        final Set<String> forbiddenPackages = Set.of("ch.qos.logback.", "org.slf4j.", "org.apache.logging.");
        return new URLClassLoader(urls.toArray(new URL[0]), parentLoader){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                for (String pkg : forbiddenPackages) {
                    if (!name.startsWith(pkg)) continue;
                    return parentLoader.loadClass(name);
                }
                try {
                    return this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    return super.loadClass(name);
                }
            }

            @Override
            public URL getResource(String name) {
                URL url = parentLoader.getResource(name);
                if (url == null) {
                    url = this.findResource(name);
                }
                if (url == null) {
                    url = super.getResource(name);
                }
                return url;
            }
        };
    }

    private void registerPlugins(URLClassLoader classLoader) {
        ServiceLoader<BotPlugin> loader = ServiceLoader.load(BotPlugin.class, classLoader);
        int count = 0;
        for (BotPlugin plugin : loader) {
            if (!plugin.getClass().isAnnotationPresent(Component.class)) continue;
            this.registerPlugin(plugin);
            ++count;
        }
        log.info("Successfully loaded {} plugins", (Object)count);
    }

    private void registerPlugin(BotPlugin plugin) {
        Class<BotPlugin> pluginClass = plugin.getClass().asSubclass(BotPlugin.class);
        String beanName = this.generateBeanName(pluginClass);
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        beanFactory.registerSingleton(beanName, (Object)plugin);
        this.shiroProperties.getPluginList().add(pluginClass);
        log.debug("Registered plugin: {}", (Object)pluginClass.getName());
    }

    private String generateBeanName(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
    }

    @Autowired
    @Generated
    public PluginManager(ShiroProperties shiroProperties, ApplicationContext applicationContext, DependencyResolver dependencyResolver) {
        this.shiroProperties = shiroProperties;
        this.applicationContext = applicationContext;
        this.dependencyResolver = dependencyResolver;
    }

    @Generated
    public URLClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }
}

