/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.adapter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.mikuac.shiro.common.utils.CommonUtils;
import com.mikuac.shiro.common.utils.ConnectionUtils;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.core.BotContainer;
import com.mikuac.shiro.core.BotFactory;
import com.mikuac.shiro.core.CoreEvent;
import com.mikuac.shiro.enums.AdapterEnum;
import com.mikuac.shiro.handler.ActionHandler;
import com.mikuac.shiro.handler.EventHandler;
import com.mikuac.shiro.properties.WebSocketProperties;
import com.mikuac.shiro.task.ShiroAsyncTask;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WebSocketClientHandler
extends TextWebSocketHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final CoreEvent coreEvent;
    private final EventHandler eventHandler;
    private final BotFactory botFactory;
    private final ActionHandler actionHandler;
    private final ShiroAsyncTask shiroAsyncTask;
    private final BotContainer botContainer;
    private final WebSocketProperties wsProp;
    private final ThreadPoolTaskExecutor shiroTaskExecutor;

    public WebSocketClientHandler(EventHandler eventHandler, BotFactory botFactory, ActionHandler actionHandler, ShiroAsyncTask shiroAsyncTask, BotContainer botContainer, CoreEvent coreEvent, WebSocketProperties wsProp, ThreadPoolTaskExecutor shiroTaskExecutor) {
        this.eventHandler = eventHandler;
        this.botFactory = botFactory;
        this.actionHandler = actionHandler;
        this.shiroAsyncTask = shiroAsyncTask;
        this.botContainer = botContainer;
        this.coreEvent = coreEvent;
        this.wsProp = wsProp;
        this.shiroTaskExecutor = shiroTaskExecutor;
    }

    public void afterConnectionEstablished(@NonNull WebSocketSession session) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        try {
            session.setTextMessageSizeLimit(this.wsProp.getMaxTextMessageBufferSize().intValue());
            session.setBinaryMessageSizeLimit(this.wsProp.getMaxBinaryMessageBufferSize().intValue());
            session.getAttributes().put("adapter", AdapterEnum.CLIENT);
            long xSelfId = ConnectionUtils.parseSelfId(session);
            if (xSelfId == 0L) {
                return;
            }
            if (!this.coreEvent.session(session)) {
                session.close();
                return;
            }
            Bot bot = this.botFactory.createBot(xSelfId, session);
            this.botContainer.robots.put(xSelfId, bot);
            log.info("Account {} connected", (Object)xSelfId);
            CompletableFuture.runAsync(() -> this.coreEvent.online(bot), (Executor)this.shiroTaskExecutor);
        }
        catch (IOException e) {
            log.error("Failed close websocket session: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus status) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        Map.Entry bot = this.botContainer.robots.entrySet().stream().findFirst().orElse(null);
        if (bot != null) {
            log.warn("Account {} disconnected", bot.getKey());
            CompletableFuture.runAsync(() -> this.coreEvent.offline((Long)bot.getKey()), (Executor)this.shiroTaskExecutor);
            this.botContainer.robots.clear();
        }
    }

    protected void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        long xSelfId = ConnectionUtils.parseSelfId(session);
        if (xSelfId == 0L) {
            boolean valid = JSON.isValid((String)((String)message.getPayload()));
            if (valid) {
                String selfId = JSONObject.parseObject((String)((String)message.getPayload())).getOrDefault("self_id", (Object)"").toString();
                session.getAttributes().put("x-self-id", selfId);
                xSelfId = ConnectionUtils.parseSelfId(session);
            }
            if (!this.botContainer.robots.containsKey(xSelfId)) {
                this.afterConnectionEstablished(session);
            }
        }
        JSONObject result = JSON.parseObject((String)((String)message.getPayload()));
        log.debug("[Event] {}", (Object)CommonUtils.debugMsgDeleteBase64Content(result.toJSONString(new JSONWriter.Feature[0])));
        if (result.containsKey("echo")) {
            if ("failed".equals(result.get("status"))) {
                log.error("API call failed [{}]: {}", (Object)xSelfId, result.get("wording"));
            }
            this.actionHandler.onReceiveActionResp(result);
        } else {
            this.shiroAsyncTask.execHandlerMsg(this.eventHandler, xSelfId, result);
        }
    }
}

