/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.adapter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.mikuac.shiro.common.utils.CommonUtils;
import com.mikuac.shiro.common.utils.ConnectionUtils;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.core.BotContainer;
import com.mikuac.shiro.core.BotFactory;
import com.mikuac.shiro.core.CoreEvent;
import com.mikuac.shiro.enums.AdapterEnum;
import com.mikuac.shiro.enums.SessionStatusEnum;
import com.mikuac.shiro.handler.ActionHandler;
import com.mikuac.shiro.handler.EventHandler;
import com.mikuac.shiro.properties.ShiroProperties;
import com.mikuac.shiro.properties.WebSocketProperties;
import com.mikuac.shiro.task.ScheduledTask;
import com.mikuac.shiro.task.ShiroAsyncTask;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WebSocketServerHandler
extends TextWebSocketHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerHandler.class);
    private final EventHandler eventHandler;
    private final BotFactory botFactory;
    private final ActionHandler actionHandler;
    private final ShiroAsyncTask shiroAsyncTask;
    private final BotContainer botContainer;
    private final CoreEvent coreEvent;
    private final WebSocketProperties wsProp;
    private final ScheduledTask scheduledTask;
    private final ShiroProperties shiroProps;
    private final ThreadPoolTaskExecutor shiroTaskExecutor;

    public WebSocketServerHandler(EventHandler eventHandler, BotFactory botFactory, ActionHandler actionHandler, ShiroAsyncTask shiroAsyncTask, BotContainer botContainer, CoreEvent coreEvent, WebSocketProperties wsProp, ScheduledTask scheduledTask, ShiroProperties shiroProps, ThreadPoolTaskExecutor shiroTaskExecutor) {
        this.eventHandler = eventHandler;
        this.botFactory = botFactory;
        this.actionHandler = actionHandler;
        this.shiroAsyncTask = shiroAsyncTask;
        this.botContainer = botContainer;
        this.coreEvent = coreEvent;
        this.wsProp = wsProp;
        this.shiroProps = shiroProps;
        this.scheduledTask = scheduledTask;
        this.shiroTaskExecutor = shiroTaskExecutor;
    }

    public void afterConnectionEstablished(@NonNull WebSocketSession session) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        try {
            session.getAttributes().put("adapter", AdapterEnum.SERVER);
            long xSelfId = ConnectionUtils.parseSelfId(session);
            if (xSelfId == 0L) {
                log.error("Failed parse x-self-id for websocket session");
                session.close();
                return;
            }
            if (!ConnectionUtils.checkToken(session, this.wsProp.getAccessToken())) {
                log.error("Invalid access token");
                session.close();
                return;
            }
            if (!this.coreEvent.session(session)) {
                session.close();
                return;
            }
            Map sessionContext = session.getAttributes();
            sessionContext.put("session_status", SessionStatusEnum.ONLINE);
            if (this.shiroProps.getWaitBotConnect() <= 0) {
                if (this.botContainer.robots.containsKey(xSelfId)) {
                    log.info("Bot {} already connected with another instance", (Object)xSelfId);
                    sessionContext.clear();
                    session.close();
                } else {
                    Bot bot2 = ConnectionUtils.handleFirstConnect(xSelfId, session, this.botFactory, this.coreEvent, this.shiroTaskExecutor);
                    this.botContainer.robots.put(xSelfId, bot2);
                }
                return;
            }
            this.botContainer.robots.compute(xSelfId, (id, bot) -> {
                if (Objects.isNull(bot)) {
                    bot = ConnectionUtils.handleFirstConnect(xSelfId, session, this.botFactory, this.coreEvent, this.shiroTaskExecutor);
                } else {
                    ConnectionUtils.handleReConnect(bot, xSelfId, session);
                }
                return bot;
            });
        }
        catch (IOException | ConcurrentModificationException e) {
            log.error("Websocket session close exception: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus status) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        long xSelfId = ConnectionUtils.parseSelfId(session);
        if (xSelfId == 0L || !this.botContainer.robots.containsKey(xSelfId)) {
            return;
        }
        Map sessionContext = session.getAttributes();
        if (this.shiroProps.getWaitBotConnect() <= 0) {
            sessionContext.clear();
            this.botContainer.robots.remove(xSelfId);
            log.warn("Account {} disconnected", (Object)xSelfId);
            CompletableFuture.runAsync(() -> this.coreEvent.offline(xSelfId), (Executor)this.shiroTaskExecutor);
            return;
        }
        ScheduledFuture<?> removeSelfFuture = this.scheduledTask.executor().schedule(() -> {
            if (this.botContainer.robots.containsKey(xSelfId)) {
                this.botContainer.robots.remove(xSelfId);
                log.warn("Account {} disconnected", (Object)xSelfId);
                CompletableFuture.runAsync(() -> this.coreEvent.offline(xSelfId), (Executor)this.shiroTaskExecutor);
            }
        }, (long)this.shiroProps.getWaitBotConnect().intValue(), TimeUnit.SECONDS);
        sessionContext.put("session_status", SessionStatusEnum.OFFLINE);
        sessionContext.put("future", removeSelfFuture);
    }

    protected void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        long xSelfId = ConnectionUtils.parseSelfId(session);
        JSONObject result = JSON.parseObject((String)((String)message.getPayload()));
        log.debug("[Event] {}", (Object)CommonUtils.debugMsgDeleteBase64Content(result.toJSONString(new JSONWriter.Feature[0])));
        if (result.containsKey("echo")) {
            if ("failed".equals(result.get("status"))) {
                log.error("API call failed [{}]: {}", (Object)xSelfId, result.get("wording"));
            }
            this.actionHandler.onReceiveActionResp(result);
        } else {
            this.shiroAsyncTask.execHandlerMsg(this.eventHandler, xSelfId, result);
        }
    }
}

