/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.boot;

import ch.qos.logback.classic.Level;
import com.mikuac.shiro.adapter.WebSocketClientHandler;
import com.mikuac.shiro.adapter.WebSocketServerHandler;
import com.mikuac.shiro.boot.Shiro;
import com.mikuac.shiro.properties.ShiroProperties;
import com.mikuac.shiro.properties.WebSocketClientProperties;
import com.mikuac.shiro.properties.WebSocketProperties;
import com.mikuac.shiro.properties.WebSocketServerProperties;
import com.mikuac.shiro.task.ScheduledTask;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.WebSocketConnectionManager;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Component
@EnableAsync
@EnableWebSocket
@Import(value={Shiro.class})
@ComponentScan(value={"com.mikuac.shiro"})
public class ShiroAutoConfiguration
implements WebSocketConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShiroAutoConfiguration.class);
    private final WebSocketServerProperties wsServerProp;
    private final WebSocketClientProperties wsClientProp;
    private final WebSocketProperties wsProp;
    private final ScheduledTask scheduledTask;
    private final ShiroProperties shiroProperties;
    private final WebSocketServerHandler webSocketServerHandler;
    private final WebSocketClientHandler webSocketClientHandler;

    @Autowired
    public ShiroAutoConfiguration(WebSocketServerProperties wsServerProp, WebSocketClientProperties wsClientProp, WebSocketProperties wsProp, ShiroProperties shiroProperties, ScheduledTask scheduledTask, Optional<WebSocketServerHandler> webSocketServerHandler, Optional<WebSocketClientHandler> webSocketClientHandler) {
        this.wsServerProp = wsServerProp;
        this.wsClientProp = wsClientProp;
        this.scheduledTask = scheduledTask;
        this.wsProp = wsProp;
        this.shiroProperties = shiroProperties;
        this.webSocketServerHandler = webSocketServerHandler.orElse(null);
        this.webSocketClientHandler = webSocketClientHandler.orElse(null);
    }

    public void registerWebSocketHandlers(@Nonnull WebSocketHandlerRegistry registry) {
        this.setLogLevel();
        if (Boolean.TRUE.equals(this.wsServerProp.getEnable()) && Boolean.TRUE.equals(this.wsClientProp.getEnable())) {
            log.error("Cannot be simultaneously enabled ws client and server");
            System.exit(0);
            return;
        }
        if (Boolean.TRUE.equals(this.wsServerProp.getEnable())) {
            registry.addHandler((WebSocketHandler)this.webSocketServerHandler, new String[]{this.wsServerProp.getUrl()}).setAllowedOrigins(new String[]{"*"});
        }
        if (Boolean.TRUE.equals(this.wsClientProp.getEnable())) {
            this.createWebsocketClient();
        }
    }

    private void setLogLevel() {
        if (Boolean.TRUE.equals(this.shiroProperties.getDebug())) {
            ch.qos.logback.classic.Logger pkg = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"com.mikuac.shiro");
            pkg.setLevel(Level.DEBUG);
            log.warn("Enabled debug mode");
        }
    }

    private void createWebsocketClient() {
        StandardWebSocketClient client = new StandardWebSocketClient();
        WebSocketHttpHeaders headers = new WebSocketHttpHeaders();
        if (!Objects.equals(this.wsProp.getAccessToken(), "")) {
            headers.add("Authorization", this.wsProp.getAccessToken());
        }
        WebSocketConnectionManager manager = new WebSocketConnectionManager((WebSocketClient)client, (WebSocketHandler)this.webSocketClientHandler, this.wsClientProp.getUrl(), new Object[0]);
        manager.setHeaders((HttpHeaders)headers);
        manager.setAutoStartup(true);
        this.scheduledTask.executor().scheduleAtFixedRate(() -> {
            if (!manager.isConnected()) {
                manager.startInternal();
            }
        }, 0L, this.wsClientProp.getReconnectInterval().intValue(), TimeUnit.SECONDS);
    }
}

