/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.limit;

import com.mikuac.shiro.properties.RateLimiterProperties;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class RateLimiter
implements ApplicationRunner {
    private final RateLimiterProperties props;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread thread = new Thread(r, "rate-limiter-token-generator-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private double currentTokenQuantities;

    @Autowired
    public RateLimiter(RateLimiterProperties props) {
        if (props == null) {
            throw new IllegalArgumentException("RateLimiterProperties cannot be null");
        }
        if (props.getCapacity() <= 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        if (props.getRate() <= 0) {
            throw new IllegalArgumentException("Rate must be positive");
        }
        if (props.getTimeout() < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        this.props = props;
    }

    public void run(ApplicationArguments args) {
        this.currentTokenQuantities = this.props.getCapacity().intValue();
        long intervalMs = 100L;
        double tokensPerInterval = (double)this.props.getRate().intValue() / (1000.0 / (double)intervalMs);
        this.scheduler.scheduleAtFixedRate(() -> this.supplementToken(tokensPerInterval), 0L, intervalMs, TimeUnit.MILLISECONDS);
    }

    public boolean acquire() {
        return this.acquire(1);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    public boolean tryAcquire(int permits) {
        this.lock.lock();
        try {
            boolean bl = this.getToken(permits);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(int permits) {
        this.lock.lock();
        try {
            while (!this.getToken(permits)) {
                try {
                    boolean await = this.condition.await(this.props.getTimeout().intValue(), TimeUnit.SECONDS);
                    if (await) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean getToken(int permits) {
        if ((double)permits > this.currentTokenQuantities) {
            return false;
        }
        this.currentTokenQuantities -= (double)permits;
        return true;
    }

    private void supplementToken(double tokenAmount) {
        this.lock.lock();
        try {
            this.currentTokenQuantities = Math.min(this.currentTokenQuantities + tokenAmount, (double)this.props.getCapacity().intValue());
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @PreDestroy
    public void destroy() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

