/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class AnnotationScanner
implements ResourceLoaderAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotationScanner.class);
    private ResourceLoader resourceLoader;

    public void setResourceLoader(@NonNull ResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new NullPointerException("resourceLoader is marked non-null but is null");
        }
        this.resourceLoader = resourceLoader;
    }

    public Set<Class<?>> scan(String packageName) {
        HashSet classes = new HashSet();
        try {
            Resource[] resources;
            String packageSearchPath = "classpath*:".concat(ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)packageName)).concat("/*.class"));
            for (Resource resource : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources(packageSearchPath)) {
                MetadataReader metadataReader;
                if (!resource.isReadable() || !(metadataReader = new CachingMetadataReaderFactory(this.resourceLoader).getMetadataReader(resource)).getClassMetadata().isAnnotation()) continue;
                classes.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
            }
            return classes;
        }
        catch (Exception e) {
            log.error("An exception occurred during annotation scanning: {}", (Object)e.getMessage(), (Object)e);
            return classes;
        }
    }
}

