/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.alibaba.fastjson2.JSON;
import com.mikuac.shiro.common.utils.Keyboard;
import com.mikuac.shiro.common.utils.OneBotMedia;
import com.mikuac.shiro.common.utils.ShiroUtils;
import com.mikuac.shiro.model.ArrayMsg;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ArrayMsgUtils {
    private final List<ArrayMsg> builder = new ArrayList<ArrayMsg>();

    public static ArrayMsgUtils builder() {
        return new ArrayMsgUtils();
    }

    public ArrayMsgUtils text(String text) {
        this.builder.add(this.getJsonData("text", m -> m.put("text", text)));
        return this;
    }

    public ArrayMsgUtils img(String img) {
        this.builder.add(this.getJsonData("image", m -> m.put("file", ShiroUtils.escape(img))));
        return this;
    }

    public ArrayMsgUtils img(byte[] image) {
        String img = String.format("base64://%s", Base64.getEncoder().encodeToString(image));
        this.builder.add(this.getJsonData("image", m -> m.put("file", ShiroUtils.escape(img))));
        return this;
    }

    public ArrayMsgUtils img(OneBotMedia media) {
        this.builder.add(this.getJsonData("image", media::escape));
        return this;
    }

    public ArrayMsgUtils video(String video, String cover) {
        this.builder.add(this.getJsonData("video", m -> {
            m.put("file", ShiroUtils.escape(video));
            m.put("cover", ShiroUtils.escape(cover));
        }));
        return this;
    }

    public ArrayMsgUtils flashImg(String img) {
        this.builder.add(this.getJsonData("image", m -> {
            m.put("flash", "flash");
            m.put("file", ShiroUtils.escape(img));
        }));
        return this;
    }

    public ArrayMsgUtils face(int id) {
        this.builder.add(this.getJsonData("face", m -> m.put("id", String.valueOf(id))));
        return this;
    }

    public ArrayMsgUtils voice(OneBotMedia media) {
        this.builder.add(this.getJsonData("record", media::escape));
        return this;
    }

    public ArrayMsgUtils voice(String voice) {
        this.builder.add(this.getJsonData("record", m -> m.put("file", ShiroUtils.escape(voice))));
        return this;
    }

    public ArrayMsgUtils at(long userId) {
        this.builder.add(this.getJsonData("at", m -> m.put("qq", String.valueOf(userId))));
        return this;
    }

    public ArrayMsgUtils atAll() {
        this.builder.add(this.getJsonData("at", m -> m.put("qq", "all")));
        return this;
    }

    public ArrayMsgUtils poke(long userId) {
        this.builder.add(this.getJsonData("poke", m -> m.put("qq", String.valueOf(userId))));
        return this;
    }

    public ArrayMsgUtils reply(int msgId) {
        this.builder.add(this.getJsonData("reply", m -> m.put("id", String.valueOf(msgId))));
        return this;
    }

    public ArrayMsgUtils reply(String msgId) {
        this.builder.add(this.getJsonData("reply", m -> m.put("id", msgId)));
        return this;
    }

    public ArrayMsgUtils gift(long userId, int giftId) {
        this.builder.add(this.getJsonData("gift", m -> {
            m.put("qq", String.valueOf(userId));
            m.put("id", String.valueOf(giftId));
        }));
        return this;
    }

    public ArrayMsgUtils tts(String text) {
        this.builder.add(this.getJsonData("tts", m -> m.put("text", text)));
        return this;
    }

    public ArrayMsgUtils xml(String data) {
        this.builder.add(this.getJsonData("xml", m -> m.put("data", data)));
        return this;
    }

    public ArrayMsgUtils xml(String data, int resId) {
        this.builder.add(this.getJsonData("xml", m -> {
            m.put("data", String.valueOf(data));
            m.put("resid", String.valueOf(resId));
        }));
        return this;
    }

    public ArrayMsgUtils json(String data) {
        this.builder.add(this.getJsonData("json", m -> m.put("data", data)));
        return this;
    }

    public ArrayMsgUtils json(String data, int resId) {
        this.builder.add(this.getJsonData("json", m -> {
            m.put("data", String.valueOf(data));
            m.put("resid", String.valueOf(resId));
        }));
        return this;
    }

    public ArrayMsgUtils cardImage(String file) {
        this.builder.add(this.getJsonData("cardimage", m -> m.put("file", String.valueOf(file))));
        return this;
    }

    public ArrayMsgUtils cardImage(String file, long minWidth, long minHeight, long maxWidth, long maxHeight, String source, String icon) {
        this.builder.add(this.getJsonData("cardimage", m -> {
            m.put("file", ShiroUtils.escape(file));
            m.put("minwidth", String.valueOf(minWidth));
            m.put("minheight", String.valueOf(minHeight));
            m.put("maxwidth", String.valueOf(maxWidth));
            m.put("maxheight", String.valueOf(maxHeight));
            m.put("source", ShiroUtils.escape(source));
            m.put("icon", ShiroUtils.escape(icon));
        }));
        return this;
    }

    public ArrayMsgUtils music(String type, long id) {
        this.builder.add(this.getJsonData("music", m -> {
            m.put("type", String.valueOf(type));
            m.put("id", String.valueOf(id));
        }));
        return this;
    }

    public ArrayMsgUtils music(String type, Map<String, String> params) {
        this.builder.add(this.getJsonData("music", m -> {
            m.put("type", String.valueOf(type));
            for (Map.Entry entry : params.entrySet()) {
                m.put((String)entry.getKey(), ShiroUtils.escape((String)entry.getValue()));
            }
        }));
        return this;
    }

    public ArrayMsgUtils rps(int value) {
        this.builder.add(this.getJsonData("rps", m -> m.put("value", String.valueOf(value))));
        return this;
    }

    public ArrayMsgUtils longMsg(String id) {
        this.builder.add(this.getJsonData("longmsg", m -> m.put("id", id)));
        return this;
    }

    public ArrayMsgUtils forward(String id) {
        this.builder.add(this.getJsonData("forward", m -> m.put("id", id)));
        return this;
    }

    public ArrayMsgUtils markdown(String content) {
        this.builder.add(this.getJsonData("markdown", m -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("content", content);
            m.put("content", JSON.toJSONString(map));
        }));
        return this;
    }

    public ArrayMsgUtils keyboard(Keyboard keyboard) {
        this.builder.add(this.getJsonData("keyboard", m -> m.put("keyboard", JSON.toJSONString((Object)keyboard))));
        return this;
    }

    public String buildCQ() {
        return this.builder.stream().map(ArrayMsg::toCQCode).collect(Collectors.joining());
    }

    public List<ArrayMsg> build() {
        return this.builder;
    }

    private ArrayMsg getJsonData(String type, Consumer<Map<String, String>> consumer) {
        HashMap<String, String> data = new HashMap<String, String>();
        consumer.accept(data);
        return new ArrayMsg().setRawType(type).setData(data);
    }
}

