/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.core.BotMessageEventInterceptor;
import com.mikuac.shiro.core.BotPlugin;
import com.mikuac.shiro.core.DefaultBotMessageEventInterceptor;
import com.mikuac.shiro.dto.event.message.AnyMessageEvent;
import com.mikuac.shiro.dto.event.message.MessageEvent;
import com.mikuac.shiro.handler.injection.InjectionHandler;
import com.mikuac.shiro.model.ArrayMsg;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class EventUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventUtils.class);
    private final ApplicationContext ctx;
    private final InjectionHandler injection;
    private final BotPlugin defaultPlugin = new BotPlugin();

    @Autowired
    public EventUtils(ApplicationContext ctx, InjectionHandler injection) {
        this.ctx = ctx;
        this.injection = injection;
    }

    public BotPlugin getPlugin(Class<? extends BotPlugin> pluginClass) {
        try {
            return (BotPlugin)this.ctx.getBean(pluginClass);
        }
        catch (Exception e) {
            log.error("Plugin {} load failed: {}", (Object)pluginClass.getSimpleName(), (Object)e.getMessage());
            return this.defaultPlugin;
        }
    }

    public BotMessageEventInterceptor getInterceptor(Class<? extends BotMessageEventInterceptor> interceptorClass) {
        try {
            return (BotMessageEventInterceptor)this.ctx.getBean(interceptorClass);
        }
        catch (Exception e) {
            log.warn("Interceptor {} is skipped. Please check the @Component annotation.", (Object)interceptorClass.getSimpleName());
            return (BotMessageEventInterceptor)this.ctx.getBean(DefaultBotMessageEventInterceptor.class);
        }
    }

    public boolean setInterceptor(Bot bot, MessageEvent event) {
        try {
            return !this.getInterceptor(bot.getBotMessageEventInterceptor()).preHandle(bot, event);
        }
        catch (Exception e) {
            log.error("Interceptor set exception: {}", (Object)e.getMessage(), (Object)e);
            return true;
        }
    }

    public void pushAnyMessageEvent(Bot bot, JSONObject resp, List<ArrayMsg> arrayMsg) {
        try {
            AnyMessageEvent event = (AnyMessageEvent)resp.to(AnyMessageEvent.class, new JSONReader.Feature[0]);
            event.setArrayMsg(arrayMsg);
            this.injection.invokeAnyMessage(bot, event);
            for (Class<? extends BotPlugin> pluginClass : bot.getPluginList()) {
                if (this.getPlugin(pluginClass).onAnyMessage(bot, event) == 1) break;
            }
        }
        catch (Exception e) {
            log.error("An exception occurred while pushing the message event: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

