/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.core;

import com.mikuac.shiro.properties.ShiroProperties;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DependencyResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependencyResolver.class);
    public static final File DEPENDENCIES_DIR = Paths.get("dependencies", new String[0]).toFile();
    private final RepositorySystem repositorySystem;
    private final DefaultRepositorySystemSession session;
    private final List<RemoteRepository> repositories;
    private final ConcurrentHashMap<String, Boolean> downloadingArtifacts = new ConcurrentHashMap();

    public DependencyResolver(ShiroProperties properties) {
        log.info("Initializing dependency resolver");
        this.repositorySystem = DependencyResolver.createRepositorySystem();
        this.session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(DEPENDENCIES_DIR);
        this.session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)this.session, localRepo));
        this.session.setTransferListener((TransferListener)new ImprovedTransferListener());
        String repoUrl = properties.getPluginMavenRepositoryUrl();
        if (repoUrl == null || repoUrl.isEmpty()) {
            repoUrl = "https://repo.maven.apache.org/maven2/";
        }
        RemoteRepository mavenRepo = new RemoteRepository.Builder("central", "default", repoUrl).build();
        this.repositories = Collections.singletonList(mavenRepo);
    }

    private static RepositorySystem createRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public void resolveDependency(String coordinates) throws ArtifactResolutionException {
        if (this.downloadingArtifacts.putIfAbsent(coordinates, Boolean.TRUE) != null) {
            log.debug("Dependency {} already in download queue, skipping", (Object)coordinates);
            return;
        }
        try {
            DefaultArtifact artifact = new DefaultArtifact(coordinates);
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact((Artifact)artifact);
            request.setRepositories(this.repositories);
            log.debug("Starting to resolve artifact: {}", (Object)artifact);
            ArtifactResult result = this.repositorySystem.resolveArtifact((RepositorySystemSession)this.session, request);
            log.debug("Successfully resolved artifact: {} stored at: {}", (Object)artifact, (Object)result.getArtifact().getFile().getName());
        }
        catch (ArtifactResolutionException e) {
            log.error("Dependency resolution failed: {}", (Object)e.getMessage());
            throw e;
        }
        finally {
            this.downloadingArtifacts.remove(coordinates);
        }
    }

    private static class ImprovedTransferListener
    implements TransferListener {
        private static final int PROGRESS_BAR_WIDTH = 50;
        private final ConcurrentHashMap<String, DownloadStatus> downloads = new ConcurrentHashMap();
        private static final int[] MILESTONE_PERCENTAGES = new int[]{5, 25, 50, 75, 90, 100};

        private ImprovedTransferListener() {
        }

        public void transferInitiated(TransferEvent event) {
            String resourceName = event.getResource().getResourceName();
            if (resourceName.endsWith(".jar") || resourceName.endsWith(".pom")) {
                log.info("Started downloading: {}", (Object)resourceName);
                this.downloads.put(resourceName, new DownloadStatus());
            }
        }

        public void transferStarted(TransferEvent event) {
        }

        public void transferProgressed(TransferEvent event) {
            String resourceName = event.getResource().getResourceName();
            DownloadStatus status = this.downloads.get(resourceName);
            if (status == null) {
                return;
            }
            long contentLength = event.getResource().getContentLength();
            long transferred = event.getTransferredBytes();
            if (contentLength <= 0L) {
                return;
            }
            double progress = (double)transferred / (double)contentLength;
            status.setProgress(progress);
            boolean isKeyMilestone = this.checkMilestone(status, progress);
            if (isKeyMilestone) {
                String fileName = this.extractFileName(resourceName);
                String progressBar = this.createProgressBar(progress);
                String transferredStr = this.formatSize(transferred);
                String totalStr = this.formatSize(contentLength);
                status.setLastLoggedProgress(progress);
                this.logProgress(fileName, progressBar, progress, transferredStr, totalStr);
            }
        }

        private boolean checkMilestone(DownloadStatus status, double progress) {
            int currentPercentage = (int)(progress * 100.0);
            int previousPercentage = (int)(status.getLastLoggedProgress() * 100.0);
            if (previousPercentage < 100 && progress >= 0.999) {
                status.setProgress(1.0);
                return true;
            }
            for (int milestone : MILESTONE_PERCENTAGES) {
                if (previousPercentage >= milestone || currentPercentage < milestone) continue;
                return true;
            }
            return false;
        }

        private String extractFileName(String resourceName) {
            int lastSlash = resourceName.lastIndexOf(47);
            if (lastSlash >= 0 && lastSlash < resourceName.length() - 1) {
                return resourceName.substring(lastSlash + 1);
            }
            return resourceName;
        }

        private String createProgressBar(double progress) {
            int filledLength = (int)(progress * 50.0);
            String bar = "[" + "=".repeat(filledLength);
            if (filledLength < 50) {
                bar = bar + ">" + " ".repeat(50 - filledLength - 1);
            }
            return bar + "]";
        }

        private void logProgress(String fileName, String progressBar, double progress, String transferredStr, String totalStr) {
            log.info("Downloading: {} {} {}% ({}/{})", new Object[]{this.truncateFileName(fileName), progressBar, String.format("%.2f", progress * 100.0), transferredStr, totalStr});
        }

        private String truncateFileName(String fileName) {
            if (fileName.length() <= 30) {
                return fileName;
            }
            return fileName.substring(0, 27) + "...";
        }

        private String formatSize(long bytes) {
            if (bytes < 1024L) {
                return bytes + " B";
            }
            if (bytes < 0x100000L) {
                return String.format("%.1f KB", (double)bytes / 1024.0);
            }
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }

        public void transferCorrupted(TransferEvent event) {
            String resourceName = event.getResource().getResourceName();
            log.error("Download corrupted: {}", (Object)resourceName);
            this.downloads.remove(resourceName);
        }

        public void transferSucceeded(TransferEvent event) {
            String resourceName = event.getResource().getResourceName();
            DownloadStatus status = this.downloads.remove(resourceName);
            if (status != null) {
                long contentLength = event.getResource().getContentLength();
                String totalStr = this.formatSize(contentLength);
                log.info("Download completed: {} ({})", (Object)resourceName, (Object)totalStr);
            }
        }

        public void transferFailed(TransferEvent event) {
            String resourceName = event.getResource().getResourceName();
            log.error("Download failed: {} - {}", (Object)resourceName, (Object)event.getException().getMessage());
            this.downloads.remove(resourceName);
        }

        private static class DownloadStatus {
            private double progress = 0.0;
            private double lastLoggedProgress = 0.0;

            private DownloadStatus() {
            }

            @Generated
            public double getProgress() {
                return this.progress;
            }

            @Generated
            public double getLastLoggedProgress() {
                return this.lastLoggedProgress;
            }

            @Generated
            public void setProgress(double progress) {
                this.progress = progress;
            }

            @Generated
            public void setLastLoggedProgress(double lastLoggedProgress) {
                this.lastLoggedProgress = lastLoggedProgress;
            }
        }
    }
}

