/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.mikuac.shiro.common.limit.RateLimiter;
import com.mikuac.shiro.common.utils.ConnectionUtils;
import com.mikuac.shiro.common.utils.PayloadSender;
import com.mikuac.shiro.enums.ActionPath;
import com.mikuac.shiro.enums.AdapterEnum;
import com.mikuac.shiro.enums.MsgTypeEnum;
import com.mikuac.shiro.enums.SessionStatusEnum;
import com.mikuac.shiro.exception.ShiroException;
import com.mikuac.shiro.model.ArrayMsg;
import com.mikuac.shiro.properties.RateLimiterProperties;
import com.mikuac.shiro.properties.WebSocketProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class ActionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActionHandler.class);
    private final Map<String, PayloadSender> callback = new HashMap<String, PayloadSender>();
    private final WebSocketProperties wsProp;
    private final RateLimiterProperties rateLimiterProps;
    private final RateLimiter rateLimiter;
    private int echo = 0;

    @Autowired
    public ActionHandler(WebSocketProperties wsProp, RateLimiterProperties rateLimiterProps, RateLimiter rateLimiter) {
        this.wsProp = wsProp;
        this.rateLimiterProps = rateLimiterProps;
        this.rateLimiter = rateLimiter;
    }

    public void onReceiveActionResp(JSONObject resp) {
        String e = resp.get("echo").toString();
        PayloadSender sender = this.callback.get(e);
        if (sender != null) {
            sender.onCallback(resp);
            this.callback.remove(e);
        }
    }

    public JSONObject action(WebSocketSession session, ActionPath action, Map<String, Object> params) {
        return this.act(session, action, ActionHandler.keyboardSerialize(params));
    }

    public JSONObject rawAction(WebSocketSession session, ActionPath action, Map<String, Object> params) {
        return this.act(session, action, params);
    }

    private JSONObject act(WebSocketSession session, ActionPath action, Map<String, Object> params) {
        SessionStatusEnum status;
        JSONObject result = new JSONObject();
        if (Boolean.TRUE.equals(this.rateLimiterProps.getEnable())) {
            if (Boolean.TRUE.equals(this.rateLimiterProps.getAwaitTask()) && !this.rateLimiter.acquire()) {
                return result;
            }
            if (Boolean.TRUE.equals(this.rateLimiterProps.getAwaitTask() == false) && !this.rateLimiter.tryAcquire()) {
                return result;
            }
        }
        if (ConnectionUtils.getAdapter(session) == AdapterEnum.SERVER && !(status = ConnectionUtils.getSessionStatus(session)).equals((Object)SessionStatusEnum.ONLINE)) {
            if (status.equals((Object)SessionStatusEnum.DIE)) {
                throw new ShiroException.SessionCloseException();
            }
            throw new ShiroException.SendMessageException();
        }
        JSONObject payload = this.generatePayload(action, params);
        PayloadSender sender = new PayloadSender(session, this.wsProp.getTimeout());
        this.callback.put(payload.get("echo").toString(), sender);
        try {
            result = sender.send(payload);
        }
        catch (Exception e) {
            result.clear();
            result.put((Object)"status", (Object)"failed");
            result.put((Object)"retcode", (Object)-1);
            long xSelfId = ConnectionUtils.parseSelfId(session);
            log.error("API call failed [{}]: {}", (Object)xSelfId, result.get("wording"));
        }
        return result;
    }

    private JSONObject generatePayload(ActionPath action, Map<String, Object> params) {
        JSONObject payload = new JSONObject();
        payload.put((Object)"action", (Object)action.getPath());
        payload.put((Object)"echo", (Object)this.echo++);
        if (params != null && !params.isEmpty()) {
            payload.put((Object)"params", params);
        }
        return payload;
    }

    private static Map<String, Object> keyboardSerialize(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return params;
        }
        Object msg = params.get("message");
        if (!(msg instanceof List)) {
            return params;
        }
        List original = (List)msg;
        List<Object> modified = original.stream().map(v -> {
            ArrayMsg arrayMsg;
            if (v instanceof ArrayMsg && (arrayMsg = (ArrayMsg)v).getType() == MsgTypeEnum.keyboard) {
                String data = arrayMsg.getData().get("keyboard");
                return JSON.parseObject((String)data);
            }
            return v;
        }).toList();
        if (!modified.equals(original)) {
            HashMap<String, Object> copy = new HashMap<String, Object>(params);
            copy.put("message", modified);
            return copy;
        }
        return params;
    }
}

