/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.event;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.mikuac.shiro.common.utils.EventUtils;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.dto.event.request.FriendAddRequestEvent;
import com.mikuac.shiro.dto.event.request.GroupAddRequestEvent;
import com.mikuac.shiro.enums.RequestEventEnum;
import com.mikuac.shiro.handler.injection.InjectionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestEvent {
    private final EventUtils utils;
    private final InjectionHandler injection;
    public final Map<String, BiConsumer<Bot, JSONObject>> handlers = new HashMap<String, BiConsumer<Bot, JSONObject>>();

    @Autowired
    public RequestEvent(EventUtils eventUtils, InjectionHandler injectionHandler) {
        this.utils = eventUtils;
        this.injection = injectionHandler;
    }

    public void handler(Bot bot, JSONObject resp) {
        String type = resp.getString("request_type");
        this.handlers.getOrDefault(type, (b, e) -> {}).accept(bot, resp);
    }

    private void process(Bot bot, JSONObject resp, RequestEventEnum type) {
        com.mikuac.shiro.dto.event.request.RequestEvent event;
        if (type == RequestEventEnum.GROUP) {
            event = (GroupAddRequestEvent)resp.to(GroupAddRequestEvent.class, new JSONReader.Feature[0]);
            this.injection.invokeGroupAddRequest(bot, (GroupAddRequestEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$1(bot, (GroupAddRequestEvent)event, arg_0));
        }
        if (type == RequestEventEnum.FRIEND) {
            event = (FriendAddRequestEvent)resp.to(FriendAddRequestEvent.class, new JSONReader.Feature[0]);
            this.injection.invokeFriendAddRequest(bot, (FriendAddRequestEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$2(bot, (FriendAddRequestEvent)event, arg_0));
        }
    }

    public void friend(Bot bot, JSONObject resp) {
        this.process(bot, resp, RequestEventEnum.FRIEND);
    }

    public void group(Bot bot, JSONObject resp) {
        this.process(bot, resp, RequestEventEnum.GROUP);
    }

    private /* synthetic */ boolean lambda$process$2(Bot bot, FriendAddRequestEvent event, Class o) {
        return this.utils.getPlugin(o).onFriendAddRequest(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$1(Bot bot, GroupAddRequestEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupAddRequest(bot, event) == 1;
    }
}

