/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.mikuac.shiro.dto.event.message.GroupMessageEvent;
import java.util.concurrent.ConcurrentHashMap;

public class GroupMessageFilterUtils {
    private static final ConcurrentHashMap<String, Long> CACHE = new ConcurrentHashMap();

    private GroupMessageFilterUtils() {
    }

    public static boolean insertMessage(GroupMessageEvent messageEvent, int cacheTime) {
        long cacheNow;
        String messageKey = String.valueOf(messageEvent.getTime()) + messageEvent.getGroupId() + messageEvent.getUserId();
        long now = System.currentTimeMillis();
        GroupMessageFilterUtils.removeExpiredMessageId(now);
        if (CACHE.containsKey(messageKey) && (cacheNow = CACHE.get(messageKey).longValue()) + (long)cacheTime >= now) {
            return false;
        }
        CACHE.put(messageKey, now + (long)cacheTime);
        return true;
    }

    public static void removeExpiredMessageId(long time) {
        CACHE.entrySet().removeIf(entry -> (Long)entry.getValue() < time);
    }
}

