/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mikuac.shiro.common.utils.JsonUtils;
import com.mikuac.shiro.exception.ShiroException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class JsonObjectWrapper {
    private final ObjectNode objectNode;
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.getObjectMapper();
    private static final Map<Class<?>, ValueSetter> VALUE_SETTERS = new HashMap();

    public JsonObjectWrapper() {
        this.objectNode = OBJECT_MAPPER.createObjectNode();
    }

    public JsonObjectWrapper(ObjectNode objectNode) {
        this.objectNode = objectNode != null ? objectNode : OBJECT_MAPPER.createObjectNode();
    }

    public JsonObjectWrapper(String jsonString) {
        this.objectNode = JsonUtils.parseObject(jsonString).filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).orElseGet(() -> ((ObjectMapper)OBJECT_MAPPER).createObjectNode());
    }

    public JsonObjectWrapper put(String key, Object value) {
        if (value == null) {
            this.objectNode.putNull(key);
            return this;
        }
        Class<?> clazz = value.getClass();
        ValueSetter setter = VALUE_SETTERS.get(clazz);
        if (setter != null) {
            setter.set(this.objectNode, key, value);
        } else {
            this.objectNode.set(key, OBJECT_MAPPER.valueToTree(value));
        }
        return this;
    }

    public Object get(String key) {
        JsonNode node = this.objectNode.get(key);
        if (node == null || node.isNull()) {
            return null;
        }
        return switch (node.getNodeType()) {
            case JsonNodeType.STRING -> node.asText();
            case JsonNodeType.NUMBER -> {
                if (node.isInt()) {
                    yield Integer.valueOf(node.asInt());
                }
                if (node.isLong()) {
                    yield Long.valueOf(node.asLong());
                }
                yield Double.valueOf(node.asDouble());
            }
            case JsonNodeType.BOOLEAN -> Boolean.valueOf(node.asBoolean());
            default -> node;
        };
    }

    public String getString(String key) {
        JsonNode node = this.objectNode.get(key);
        return node != null && node.isTextual() ? node.asText() : null;
    }

    public Integer getInt(String key) {
        JsonNode node = this.objectNode.get(key);
        return node != null && node.isInt() ? Integer.valueOf(node.asInt()) : null;
    }

    public Long getLong(String key) {
        JsonNode node = this.objectNode.get(key);
        return node != null && node.isLong() ? Long.valueOf(node.asLong()) : null;
    }

    public Boolean getBoolean(String key) {
        JsonNode node = this.objectNode.get(key);
        return node != null && node.isBoolean() ? Boolean.valueOf(node.asBoolean()) : null;
    }

    public boolean containsKey(String key) {
        return this.objectNode.has(key);
    }

    public Object getOrDefault(String key, Object defaultValue) {
        Object value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public JsonObjectWrapper remove(String key) {
        this.objectNode.remove(key);
        return this;
    }

    public void clear() {
        this.objectNode.removeAll();
    }

    public int size() {
        return this.objectNode.size();
    }

    public Set<String> keySet() {
        Iterable iterable = () -> ((ObjectNode)this.objectNode).fieldNames();
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet());
    }

    public <T> T to(Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)this.objectNode, clazz);
        }
        catch (Exception e) {
            throw new ShiroException("Cannot convert to class: " + clazz.getName(), e);
        }
    }

    public String toJSONString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this.objectNode);
        }
        catch (Exception e) {
            throw new ShiroException("JSON serialization failed", e);
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    public static JsonObjectWrapper parseObject(String jsonString) {
        return new JsonObjectWrapper(jsonString);
    }

    public ObjectNode raw() {
        return this.objectNode;
    }

    static {
        VALUE_SETTERS.put(String.class, (node, key, value) -> node.put(key, (String)value));
        VALUE_SETTERS.put(Integer.class, (node, key, value) -> node.put(key, (Integer)value));
        VALUE_SETTERS.put(Long.class, (node, key, value) -> node.put(key, (Long)value));
        VALUE_SETTERS.put(Boolean.class, (node, key, value) -> node.put(key, (Boolean)value));
        VALUE_SETTERS.put(Double.class, (node, key, value) -> node.put(key, (Double)value));
        VALUE_SETTERS.put(Float.class, (node, key, value) -> node.put(key, (Float)value));
    }

    @FunctionalInterface
    static interface ValueSetter {
        public void set(ObjectNode var1, String var2, Object var3);
    }
}

