/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class JsonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = JsonUtils.createConfiguredObjectMapper();
    private static final AtomicReference<ObjectMapper> customObjectMapper = new AtomicReference();

    private JsonUtils() {
    }

    private static ObjectMapper createConfiguredObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper;
    }

    public static void setCustomObjectMapper(@Nullable ObjectMapper mapper) {
        customObjectMapper.set(mapper);
    }

    public static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = customObjectMapper.get();
        return mapper != null ? mapper : DEFAULT_OBJECT_MAPPER;
    }

    public static Optional<JsonNode> parseObject(String jsonString) {
        try {
            return Optional.ofNullable(JsonUtils.getObjectMapper().readTree(jsonString));
        }
        catch (JsonProcessingException e) {
            log.error("Failed to parse JSON string", (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> List<T> parseArray(JsonNode json, Class<T> clazz) {
        try {
            ObjectMapper mapper = JsonUtils.getObjectMapper();
            return (List)mapper.convertValue((Object)json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to parse JSON array", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Nullable
    public static String toJSONString(Object object) {
        try {
            return JsonUtils.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to convert object to JSON string", (Throwable)e);
            return null;
        }
    }

    public static boolean isValid(String jsonString) {
        if (jsonString == null) {
            return false;
        }
        try {
            JsonUtils.getObjectMapper().readTree(jsonString);
            return true;
        }
        catch (JsonProcessingException e) {
            return false;
        }
    }

    @Nullable
    public static <T> T readValue(String jsonString, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(jsonString, typeReference);
        }
        catch (Exception e) {
            log.error("Failed to read value with TypeReference", (Throwable)e);
            return null;
        }
    }

    public static String nodeToString(JsonNode node) {
        if (node == null) {
            return "";
        }
        if (node.isTextual()) {
            return node.textValue();
        }
        try {
            return JsonUtils.getObjectMapper().writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            return node.toString();
        }
    }

    public static JsonNode parseToJsonNode(Object value) {
        ObjectMapper mapper = JsonUtils.getObjectMapper();
        if (value instanceof String) {
            String s = (String)value;
            JsonNode node = JsonUtils.tryParseJsonString(mapper, s);
            return node != null ? node : mapper.getNodeFactory().textNode(s);
        }
        return mapper.valueToTree(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonNode tryParseJsonString(ObjectMapper mapper, String s) {
        try (JsonParser parser = mapper.createParser(s);){
            JsonToken first = parser.nextToken();
            if (first == null) {
                JsonNode jsonNode = null;
                return jsonNode;
            }
            JsonNode node = (JsonNode)mapper.readTree(parser);
            if (parser.nextToken() != null) return null;
            JsonNode jsonNode = node;
            return jsonNode;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

