/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mikuac.shiro.common.utils.ShiroUtils;
import com.mikuac.shiro.enums.MsgTypeEnum;
import com.mikuac.shiro.model.ArrayMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;

public class MessageConverser {
    private MessageConverser() {
    }

    public static String arraysToString(List<ArrayMsg> array) {
        StringBuilder builder = new StringBuilder();
        for (ArrayMsg item : array) {
            if (!MsgTypeEnum.text.equals((Object)item.getType())) {
                builder.append(item.toCQCode());
                continue;
            }
            builder.append(item.getStringData(MsgTypeEnum.text.toString()));
        }
        return builder.toString();
    }

    public static List<ArrayMsg> stringToArray(@NonNull String msg) {
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (msg.isEmpty()) {
            return new ArrayList<ArrayMsg>();
        }
        ArrayList<ArrayMsg> chain = new ArrayList<ArrayMsg>();
        int len = msg.length();
        int i = 0;
        while (i < len) {
            if (msg.charAt(i) == '[' && i + 1 < len && msg.charAt(i + 1) == 'C' && i + 2 < len && msg.charAt(i + 2) == 'Q' && i + 3 < len && msg.charAt(i + 3) == ':') {
                int start = i;
                i += 4;
                StringBuilder typeBuilder = new StringBuilder();
                while (i < len && msg.charAt(i) != ',' && msg.charAt(i) != ']') {
                    typeBuilder.append(msg.charAt(i));
                    ++i;
                }
                if (i >= len) {
                    MessageConverser.addTextMsg(chain, msg.substring(start, len));
                    break;
                }
                String type = typeBuilder.toString();
                HashMap<String, String> data = new HashMap<String, String>();
                if (msg.charAt(i) == ',') {
                    ++i;
                    while (i < len && msg.charAt(i) != ']') {
                        StringBuilder keyBuilder = new StringBuilder();
                        while (i < len && msg.charAt(i) != '=' && msg.charAt(i) != ']') {
                            keyBuilder.append(msg.charAt(i));
                            ++i;
                        }
                        if (i >= len || msg.charAt(i) == ']') break;
                        ++i;
                        StringBuilder valueBuilder = new StringBuilder();
                        while (i < len && msg.charAt(i) != ',' && msg.charAt(i) != ']') {
                            valueBuilder.append(msg.charAt(i));
                            ++i;
                        }
                        String key = keyBuilder.toString();
                        String value = ShiroUtils.unescape(valueBuilder.toString());
                        if (!key.isEmpty()) {
                            data.put(key, value);
                        }
                        if (i >= len || msg.charAt(i) != ',') continue;
                        ++i;
                    }
                }
                if (i < len && msg.charAt(i) == ']') {
                    ++i;
                    ArrayMsg item = new ArrayMsg();
                    item.setType(MsgTypeEnum.typeOf(type));
                    item.setData(data);
                    chain.add(item);
                    continue;
                }
                MessageConverser.addTextMsg(chain, msg.substring(start, i));
                continue;
            }
            StringBuilder textBuilder = new StringBuilder();
            while (!(i >= len || msg.charAt(i) == '[' && i + 3 < len && msg.startsWith("[CQ:", i))) {
                textBuilder.append(msg.charAt(i));
                ++i;
            }
            String text = textBuilder.toString();
            if (text.isEmpty()) continue;
            MessageConverser.addTextMsg(chain, text);
        }
        return chain;
    }

    private static void addTextMsg(List<ArrayMsg> chain, String text) {
        ArrayMsg lastMsg;
        if (text.isEmpty()) {
            return;
        }
        if (!chain.isEmpty() && (lastMsg = chain.get(chain.size() - 1)).getType() == MsgTypeEnum.text && lastMsg.getData().isObject()) {
            ObjectNode obj = (ObjectNode)lastMsg.getData();
            obj.put("text", obj.get("text").asText("") + ShiroUtils.unescape(text));
            return;
        }
        ArrayMsg item = new ArrayMsg();
        item.setType(MsgTypeEnum.text);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("text", ShiroUtils.unescape(text));
        item.setData(data);
        chain.add(item);
    }
}

