/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.mikuac.shiro.common.utils.CommonUtils;
import com.mikuac.shiro.common.utils.JsonObjectWrapper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class PayloadSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PayloadSender.class);
    private final int timeout;
    private final WebSocketSession session;
    private JsonObjectWrapper resp;
    private static final Lock lock = new ReentrantLock();
    private final Condition condition = lock.newCondition();

    public PayloadSender(WebSocketSession session, int timeout) {
        this.session = session;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObjectWrapper send(@NonNull JsonObjectWrapper payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        lock.lock();
        try {
            String json = payload.toJSONString();
            this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
            log.debug("[Action] {}", (Object)CommonUtils.debugMsgDeleteBase64Content(json));
            long startTime = System.currentTimeMillis();
            long remainingTime = (long)this.timeout * 1000L;
            while (remainingTime > 0L) {
                boolean signalReceived = this.condition.await(remainingTime, TimeUnit.MILLISECONDS);
                if (signalReceived) {
                    JsonObjectWrapper jsonObjectWrapper = this.resp;
                    return jsonObjectWrapper;
                }
                remainingTime = (long)this.timeout * 1000L - (System.currentTimeMillis() - startTime);
            }
            log.warn("Timeout waiting for response");
        }
        catch (IOException e) {
            log.error("Failed to send message: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Thread interrupted while waiting for response: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            lock.unlock();
        }
        return this.resp;
    }

    public void onCallback(JsonObjectWrapper resp) {
        lock.lock();
        try {
            this.resp = resp;
            this.condition.signalAll();
        }
        finally {
            lock.unlock();
        }
    }
}

