/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReqUtils.class);

    private ReqUtils() {
    }

    public static String asyncGet(String url, int timeout) {
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(timeout)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        CompletionStage result = ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).exceptionally(e -> {
            log.error("Request to {} failed: {}", (Object)url, (Object)e.getMessage());
            return null;
        });
        try {
            return (String)((CompletableFuture)result).join();
        }
        catch (CompletionException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                log.warn("Request to {} interrupted", (Object)url);
            } else {
                log.error("Request to {} failed with exception: {}", new Object[]{url, cause.getMessage(), cause});
            }
            return null;
        }
    }
}

