/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.enums.MsgTypeEnum;
import com.mikuac.shiro.model.ArrayMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShiroUtils {
    private ShiroUtils() {
    }

    public static boolean isAtAll(String msg) {
        return msg.contains("[CQ:at,qq=all]");
    }

    public static boolean isAtAll(List<ArrayMsg> arrayMsg) {
        return arrayMsg.stream().anyMatch(it -> it.getType().equals((Object)MsgTypeEnum.at) && it.getLongData("qq") == 0L);
    }

    public static List<Long> getAtList(List<ArrayMsg> arrayMsg) {
        return arrayMsg.stream().filter(it -> MsgTypeEnum.at == it.getType() && it.getLongData("qq") != 0L).map(it -> it.getLongData("qq")).toList();
    }

    public static List<String> getMsgImgUrlList(List<ArrayMsg> arrayMsg) {
        return arrayMsg.stream().filter(it -> MsgTypeEnum.image == it.getType()).map(it -> it.getStringData("url")).toList();
    }

    public static List<String> getMsgVideoUrlList(List<ArrayMsg> arrayMsg) {
        return arrayMsg.stream().filter(it -> MsgTypeEnum.video == it.getType()).map(it -> it.getStringData("url")).toList();
    }

    public static String getGroupAvatar(long groupId, int size) {
        return String.format("https://p.qlogo.cn/gh/%s/%s/%s", groupId, groupId, size);
    }

    public static String getUserAvatar(long userId, int size) {
        return String.format("https://q2.qlogo.cn/headimg_dl?dst_uin=%s&spec=%s", userId, size);
    }

    public static String unescape(String string) {
        return string.replace("&#44;", ",").replace("&#91;", "[").replace("&#93;", "]").replace("&amp;", "&");
    }

    public static String escape(String string) {
        return string.replace("&", "&amp;").replace(",", "&#44;").replace("[", "&#91;").replace("]", "&#93;");
    }

    public static String escape2(String string) {
        return string.replace("[", "&#91;").replace("]", "&#93;");
    }

    public static List<Map<String, Object>> generateForwardMsg(long uin, String name, List<String> contents) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        contents.forEach(msg -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", name);
            data.put("uin", uin);
            data.put("content", msg);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }

    public static List<Map<String, Object>> generateForwardMsg(List<String> contents) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        contents.forEach(msg -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("content", (String)msg);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }

    public static List<Map<String, Object>> generateForwardMsg(String uin, String name, List<?> contents) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        contents.forEach(msg -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", name);
            data.put("uin", uin);
            data.put("content", msg);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }

    public static Map<String, Object> generateSingleMsg(long uin, String name, String msg) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", name);
        data.put("uin", uin);
        data.put("content", msg);
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("type", "node");
        node.put("data", data);
        return node;
    }

    public static List<Map<String, Object>> generateForwardMsg(Bot bot, List<?> contents) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        contents.forEach(msg -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", bot.getLoginInfo().getData().getNickname());
            String appName = bot.getVersionInfo().getData().getAppName();
            if (appName.equals("Lagrange.OneBot")) {
                data.put("uin", String.valueOf(bot.getSelfId()));
            } else {
                data.put("uin", bot.getSelfId());
            }
            data.put("content", msg);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }

    public static List<Map<String, Object>> generateForwardMsg(List<String> contents, List<String> quoteMsgId) {
        List<Map<String, Object>> nodes = ShiroUtils.generateForwardMsg(contents);
        quoteMsgId.forEach(id -> {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("type", "node");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", (String)id);
            node.put("data", data);
            nodes.add(node);
        });
        return nodes;
    }
}

