/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mikuac.shiro.action.GensokyoExtend;
import com.mikuac.shiro.action.GoCQHTTPExtend;
import com.mikuac.shiro.action.LLOneBotExtend;
import com.mikuac.shiro.action.LagrangeExtend;
import com.mikuac.shiro.action.NapCatExtend;
import com.mikuac.shiro.action.OneBot;
import com.mikuac.shiro.common.utils.ConnectionUtils;
import com.mikuac.shiro.common.utils.JsonObjectWrapper;
import com.mikuac.shiro.common.utils.JsonUtils;
import com.mikuac.shiro.core.BotFactory;
import com.mikuac.shiro.core.BotMessageEventInterceptor;
import com.mikuac.shiro.core.BotPlugin;
import com.mikuac.shiro.dto.action.common.ActionData;
import com.mikuac.shiro.dto.action.common.ActionList;
import com.mikuac.shiro.dto.action.common.ActionRaw;
import com.mikuac.shiro.dto.action.common.Anonymous;
import com.mikuac.shiro.dto.action.common.GuildMsgId;
import com.mikuac.shiro.dto.action.common.MsgId;
import com.mikuac.shiro.dto.action.response.BooleanResp;
import com.mikuac.shiro.dto.action.response.ChannelInfoResp;
import com.mikuac.shiro.dto.action.response.CheckUrlSafelyResp;
import com.mikuac.shiro.dto.action.response.ClientsResp;
import com.mikuac.shiro.dto.action.response.DownloadFileResp;
import com.mikuac.shiro.dto.action.response.EssenceMsgResp;
import com.mikuac.shiro.dto.action.response.FriendInfoResp;
import com.mikuac.shiro.dto.action.response.GetForwardMsgResp;
import com.mikuac.shiro.dto.action.response.GetGuildMsgResp;
import com.mikuac.shiro.dto.action.response.GetMsgListResp;
import com.mikuac.shiro.dto.action.response.GetStatusResp;
import com.mikuac.shiro.dto.action.response.GroupAtAllRemainResp;
import com.mikuac.shiro.dto.action.response.GroupFilesResp;
import com.mikuac.shiro.dto.action.response.GroupHonorInfoResp;
import com.mikuac.shiro.dto.action.response.GroupInfoResp;
import com.mikuac.shiro.dto.action.response.GroupMemberInfoResp;
import com.mikuac.shiro.dto.action.response.GuildListResp;
import com.mikuac.shiro.dto.action.response.GuildMemberListResp;
import com.mikuac.shiro.dto.action.response.GuildMemberProfileResp;
import com.mikuac.shiro.dto.action.response.GuildMetaByGuestResp;
import com.mikuac.shiro.dto.action.response.GuildServiceProfileResp;
import com.mikuac.shiro.dto.action.response.LoginInfoResp;
import com.mikuac.shiro.dto.action.response.MsgResp;
import com.mikuac.shiro.dto.action.response.OcrResp;
import com.mikuac.shiro.dto.action.response.StrangerInfoResp;
import com.mikuac.shiro.dto.action.response.UnidirectionalFriendListResp;
import com.mikuac.shiro.dto.action.response.UrlResp;
import com.mikuac.shiro.dto.action.response.VersionInfoResp;
import com.mikuac.shiro.dto.action.response.WordSlicesResp;
import com.mikuac.shiro.dto.event.message.AnyMessageEvent;
import com.mikuac.shiro.enums.ActionPath;
import com.mikuac.shiro.enums.ActionPathEnum;
import com.mikuac.shiro.handler.ActionHandler;
import com.mikuac.shiro.model.ArrayMsg;
import com.mikuac.shiro.model.HandlerMethod;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;

public class Bot
implements OneBot,
GoCQHTTPExtend,
GensokyoExtend,
LagrangeExtend,
LLOneBotExtend,
NapCatExtend,
Closeable {
    private long selfId;
    private String token;
    private ActionHandler actionHandler;
    private WebSocketSession session;
    private List<Class<? extends BotPlugin>> pluginList;
    private BotFactory.AnnotationMethodContainer annotationMethodContainer;
    private Class<? extends BotMessageEventInterceptor> botMessageEventInterceptor;

    public Bot(long selfId, WebSocketSession session, ActionHandler actionHandler, List<Class<? extends BotPlugin>> pluginList, BotFactory.AnnotationMethodContainer annotationMethodContainer, Class<? extends BotMessageEventInterceptor> botMessageEventInterceptor) {
        this.selfId = selfId;
        this.session = session;
        this.actionHandler = actionHandler;
        this.pluginList = pluginList;
        this.annotationMethodContainer = annotationMethodContainer;
        this.botMessageEventInterceptor = botMessageEventInterceptor;
        this.token = ConnectionUtils.getAuthorization(session);
    }

    public MultiValueMap<Class<? extends Annotation>, HandlerMethod> getAnnotationHandler() {
        return this.annotationMethodContainer.getAnnotationHandler();
    }

    @Override
    public void close() throws IOException {
        if (this.session.isOpen()) {
            this.session.close(CloseStatus.NORMAL);
        }
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    public ActionData<MsgId> sendMsg(AnyMessageEvent event, String msg, boolean autoEscape) {
        if ("private".equals(event.getMessageType())) {
            return this.sendPrivateMsg((long)event.getUserId(), msg, autoEscape);
        }
        if ("group".equals(event.getMessageType())) {
            return this.sendGroupMsg((long)event.getGroupId(), msg, autoEscape);
        }
        return null;
    }

    @Override
    public ActionData<MsgId> sendMsg(AnyMessageEvent event, List<ArrayMsg> msg, boolean autoEscape) {
        if ("private".equals(event.getMessageType())) {
            return this.sendPrivateMsg((long)event.getUserId(), msg, autoEscape);
        }
        if ("group".equals(event.getMessageType())) {
            return this.sendGroupMsg((long)event.getGroupId(), msg, autoEscape);
        }
        return null;
    }

    @Override
    public ActionData<MsgId> sendPrivateMsg(long userId, String msg, boolean autoEscape) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        params.put("message", msg);
        params.put("auto_escape", autoEscape);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendPrivateMsg(long userId, List<ArrayMsg> msg, boolean autoEscape) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        params.put("message", msg);
        params.put("auto_escape", autoEscape);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendPrivateMsg(long groupId, long userId, String msg, boolean autoEscape) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("message", msg);
        params.put("auto_escape", autoEscape);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendPrivateMsg(long groupId, long userId, List<ArrayMsg> msg, boolean autoEscape) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("message", msg);
        params.put("auto_escape", autoEscape);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupMsg(long groupId, String msg, boolean autoEscape) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("message", msg);
        params.put("auto_escape", autoEscape);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupMsg(long groupId, List<ArrayMsg> msg, boolean autoEscape) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("message", msg);
        params.put("auto_escape", autoEscape);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupMsg(long groupId, long userId, String msg, boolean autoEscape) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("message", msg);
        params.put("auto_escape", autoEscape);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupMsg(long groupId, long userId, List<ArrayMsg> msg, boolean autoEscape) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("message", msg);
        params.put("auto_escape", autoEscape);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<GuildMemberListResp> getGuildMemberList(String guildId, String nextToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("guild_id", guildId);
        params.put("next_token", nextToken);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_LIST, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GuildMemberListResp>>(){}) : null;
    }

    @Override
    public ActionData<GuildMsgId> sendGuildMsg(String guildId, String channelId, String msg) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("guild_id", guildId);
        params.put("channel_id", channelId);
        params.put("message", msg);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GUILD_CHANNEL_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GuildMsgId>>(){}) : null;
    }

    @Override
    public ActionData<GetGuildMsgResp> getGuildMsg(String guildMsgId, boolean noCache) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", guildMsgId);
        params.put("no_cache", noCache);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GetGuildMsgResp>>(){}) : null;
    }

    @Override
    public ActionData<GuildServiceProfileResp> getGuildServiceProfile() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_SERVICE_PROFILE, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GuildServiceProfileResp>>(){}) : null;
    }

    @Override
    public ActionList<GuildListResp> getGuildList() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_LIST, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<GuildListResp>>(){}) : null;
    }

    @Override
    public ActionData<GuildMetaByGuestResp> getGuildMetaByGuest(String guildId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("guild_id", guildId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_META_BY_GUEST, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GuildMetaByGuestResp>>(){}) : null;
    }

    @Override
    public ActionList<ChannelInfoResp> getGuildChannelList(String guildId, boolean noCache) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("guild_id", guildId);
        params.put("no_cache", noCache);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_CHANNEL_LIST, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<ChannelInfoResp>>(){}) : null;
    }

    @Override
    public ActionData<GuildMemberProfileResp> getGuildMemberProfile(String guildId, String userId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("guild_id", guildId);
        params.put("user_id", userId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GUILD_MEMBER_PROFILE, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GuildMemberProfileResp>>(){}) : null;
    }

    @Override
    public ActionData<MsgResp> getMsg(int msgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", msgId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgResp>>(){}) : null;
    }

    @Override
    public ActionRaw deleteMsg(int msgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", msgId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_MSG, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw deleteMsg(long groupId, long userId, int msgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", msgId);
        params.put("group_id", groupId);
        params.put("user_id", userId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_MSG, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupKick(long groupId, long userId, boolean rejectAddRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("reject_add_request", rejectAddRequest);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_KICK, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupBan(long groupId, long userId, int duration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("duration", duration);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_BAN, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupWholeBan(long groupId, boolean enable) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("enable", enable);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_WHOLE_BAN, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupAdmin(long groupId, long userId, boolean enable) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("enable", enable);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ADMIN, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupAnonymous(long groupId, boolean enable) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("enable", enable);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ANONYMOUS, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupCard(long groupId, long userId, String card) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("card", card);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_CARD, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupName(long groupId, String groupName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("group_name", groupName);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_NAME, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupLeave(long groupId, boolean isDismiss) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("is_dismiss", isDismiss);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_LEAVE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupSpecialTitle(long groupId, long userId, String specialTitle, int duration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("special_title", specialTitle);
        params.put("duration", duration);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_SPECIAL_TITLE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setFriendAddRequest(String flag, boolean approve, String remark) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flag", flag);
        params.put("approve", approve);
        params.put("remark", remark);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_FRIEND_ADD_REQUEST, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupAddRequest(String flag, String subType, boolean approve, String reason) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flag", flag);
        params.put("sub_type", subType);
        params.put("approve", approve);
        params.put("reason", reason);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ADD_REQUEST, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionData<LoginInfoResp> getLoginInfo() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_LOGIN_INFO, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<LoginInfoResp>>(){}) : null;
    }

    @Override
    public ActionData<StrangerInfoResp> getStrangerInfo(long userId, boolean noCache) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        params.put("no_cache", noCache);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_STRANGER_INFO, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<StrangerInfoResp>>(){}) : null;
    }

    @Override
    public ActionList<FriendInfoResp> getFriendList() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_FRIEND_LIST, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<FriendInfoResp>>(){}) : null;
    }

    @Override
    public ActionRaw deleteFriend(long friendId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", friendId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_FRIEND, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionData<GroupInfoResp> getGroupInfo(long groupId, boolean noCache) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("no_cache", noCache);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_INFO, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GroupInfoResp>>(){}) : null;
    }

    @Override
    public ActionList<GroupInfoResp> getGroupList() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_LIST, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<GroupInfoResp>>(){}) : null;
    }

    @Override
    public ActionData<GroupMemberInfoResp> getGroupMemberInfo(long groupId, long userId, boolean noCache) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("user_id", userId);
        params.put("no_cache", noCache);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_MEMBER_INFO, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GroupMemberInfoResp>>(){}) : null;
    }

    @Override
    public ActionList<GroupMemberInfoResp> getGroupMemberList(long groupId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_MEMBER_LIST, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<GroupMemberInfoResp>>(){}) : null;
    }

    @Override
    public ActionList<GroupMemberInfoResp> getGroupMemberList(long groupId, boolean noCache) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("no_cache", noCache);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_MEMBER_LIST, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<GroupMemberInfoResp>>(){}) : null;
    }

    @Override
    public ActionData<VersionInfoResp> getVersionInfo() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_VERSION_INFO, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<VersionInfoResp>>(){}) : null;
    }

    @Override
    public ActionData<GroupHonorInfoResp> getGroupHonorInfo(long groupId, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("type", type);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_HONOR_INFO, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GroupHonorInfoResp>>(){}) : null;
    }

    @Override
    public ActionData<BooleanResp> canSendImage() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.CAN_SEND_IMAGE, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<BooleanResp>>(){}) : null;
    }

    @Override
    public ActionData<BooleanResp> canSendRecord() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.CAN_SEND_RECORD, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<BooleanResp>>(){}) : null;
    }

    @Override
    public ActionRaw setGroupPortrait(long groupId, String file, int cache) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("file", file);
        params.put("cache", cache);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_PORTRAIT, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionData<CheckUrlSafelyResp> checkUrlSafely(String url) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", url);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.CHECK_URL_SAFELY, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<CheckUrlSafelyResp>>(){}) : null;
    }

    @Override
    public ActionRaw sendGroupNotice(long groupId, String content) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("content", content);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEN_GROUP_NOTICE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionData<GroupAtAllRemainResp> getGroupAtAllRemain(long groupId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_AT_ALL_REMAIN, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GroupAtAllRemainResp>>(){}) : null;
    }

    @Override
    public ActionRaw uploadGroupFile(long groupId, String file, String name, String folder) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("file", file);
        params.put("name", name);
        params.put("folder", folder);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.UPLOAD_GROUP_FILE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw uploadGroupFile(long groupId, String file, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("file", file);
        params.put("name", name);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.UPLOAD_GROUP_FILE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupAnonymousBan(long groupId, Anonymous anonymous, int duration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("anonymous", anonymous);
        params.put("duration", duration);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ANONYMOUS_BAN, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setGroupAnonymousBan(long groupId, String flag, int duration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("flag", flag);
        params.put("duration", duration);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_ANONYMOUS_BAN, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionData<DownloadFileResp> downloadFile(String url, int threadCount, String headers) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", url);
        params.put("headers", headers);
        params.put("thread_count", threadCount);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DOWNLOAD_FILE, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<DownloadFileResp>>(){}) : null;
    }

    @Override
    public ActionData<DownloadFileResp> downloadFile(String url) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", url);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DOWNLOAD_FILE, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<DownloadFileResp>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendGroupForwardMsg(long groupId, List<Map<String, Object>> msg) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("messages", msg);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_FORWARD_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<GroupFilesResp> getGroupRootFiles(long groupId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_ROOT_FILES, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GroupFilesResp>>(){}) : null;
    }

    @Override
    public ActionData<GroupFilesResp> getGroupFilesByFolder(long groupId, String folderId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("folder_id", folderId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_FILES_BY_FOLDER, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GroupFilesResp>>(){}) : null;
    }

    @Override
    public ActionList<EssenceMsgResp> getEssenceMsgList(long groupId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_ESSENCE_MSG_LIST, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<EssenceMsgResp>>(){}) : null;
    }

    @Override
    public ActionRaw setEssenceMsg(int msgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", msgId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_ESSENCE_MSG, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw deleteEssenceMsg(int msgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", msgId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_ESSENCE_MSG, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setBotProfile(String nickname, String company, String email, String college, String personalNote) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nickname", nickname);
        params.put("company", company);
        params.put("email", email);
        params.put("college", college);
        params.put("personalNote", personalNote);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_QQ_PROFILE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionData<MsgId> sendPrivateForwardMsg(long userId, List<Map<String, Object>> msg) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        params.put("messages", msg);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_FORWARD_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<MsgId> sendForwardMsg(AnyMessageEvent event, List<Map<String, Object>> msg) {
        JsonObjectWrapper result;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("messages", msg);
        if ("group".equals(event.getMessageType())) {
            params.put("group_id", event.getGroupId());
        }
        if ("private".equals(event.getMessageType())) {
            params.put("user_id", event.getUserId());
        }
        return (result = this.actionHandler.action(this.session, ActionPathEnum.SEND_FORWARD_MSG, params)) != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    public ActionData<MsgId> sendGroupForwardMsg(long groupId, List<Map<String, Object>> msg, String prompt, String source, String summary, List<Map<String, String>> news) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("messages", msg);
        params.put("news", news);
        params.put("prompt", prompt);
        params.put("source", source);
        params.put("summary", summary);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_FORWARD_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    public ActionData<MsgId> sendPrivateForwardMsg(long userId, List<Map<String, Object>> msg, String prompt, String source, String summary, List<Map<String, String>> news) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        params.put("messages", msg);
        params.put("news", news);
        params.put("prompt", prompt);
        params.put("source", source);
        params.put("summary", summary);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_PRIVATE_FORWARD_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<MsgId>>(){}) : null;
    }

    @Override
    public ActionData<WordSlicesResp> getWordSlices(String content) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("content", content);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_WORD_SLICES, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<WordSlicesResp>>(){}) : null;
    }

    @Override
    public ActionData<ClientsResp> getOnlineClients(boolean noCache) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("no_cache", noCache);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_ONLINE_CLIENTS, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<ClientsResp>>(){}) : null;
    }

    @Override
    public ActionData<OcrResp> ocrImage(String image) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("image", image);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.OCR_IMAGE, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<OcrResp>>(){}) : null;
    }

    @Override
    public ActionRaw uploadPrivateFile(long userId, String file, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        params.put("file", file);
        params.put("name", name);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.UPLOAD_PRIVATE_FILE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw sendGroupSign(long groupId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_GROUP_SIGN, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw deleteUnidirectionalFriend(long userId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_UNIDIRECTIONAL_FRIEND, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionList<UnidirectionalFriendListResp> getUnidirectionalFriendList() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_UNIDIRECTIONAL_FRIEND_LIST, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<UnidirectionalFriendListResp>>(){}) : null;
    }

    @Override
    public ActionData<UrlResp> getGroupFileUrl(long groupId, String fileId, int busId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("file_id", fileId);
        params.put("busid", busId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_FILE_URL, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<UrlResp>>(){}) : null;
    }

    @Override
    public ActionData<GroupFilesResp> getFile(long groupId, String fileId, int busId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("file_id", fileId);
        params.put("busid", busId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_FILE, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GroupFilesResp>>(){}) : null;
    }

    @Override
    public ActionRaw createGroupFileFolder(long groupId, String folderName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("name", folderName);
        params.put("parent_id", "/");
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.CREATE_GROUP_FILE_FOLDER, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw deleteGroupFileFolder(long groupId, String folderId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("folder_id", folderId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_GROUP_FOLDER, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw deleteGroupFile(long groupId, String fileId, int busId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("file_id", fileId);
        params.put("busid", busId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.DELETE_GROUP_FILE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw sendLike(long userId, int times) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        params.put("times", times);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_LIKE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionData<GetStatusResp> getStatus() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_STATUS, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GetStatusResp>>(){}) : null;
    }

    @Override
    public ActionList<String> fetchCustomFace() {
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.FETCH_CUSTOM_FACE, null);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionList<String>>(){}) : null;
    }

    @Override
    public ActionData<String> sendForwardMsg(List<Map<String, Object>> msg) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("messages", msg);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SEND_FORWARD_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<String>>(){}) : null;
    }

    @Override
    public ActionData<GetMsgListResp> getGroupMsgHistory(long groupId, Long messageSeq, int count, boolean reverseOrder) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        if (messageSeq != null) {
            params.put("messageSeq", messageSeq);
        }
        params.put("count", count);
        params.put("reverseOrder", reverseOrder);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_GROUP_MSG_HISTORY, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GetMsgListResp>>(){}) : null;
    }

    @Override
    public ActionData<GetMsgListResp> getFriendMsgHistory(long userId, Long messageSeq, int count, boolean reverseOrder) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_id", userId);
        if (messageSeq != null) {
            params.put("messageSeq", messageSeq);
        }
        params.put("count", count);
        params.put("reverseOrder", reverseOrder);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_FRIEND_MSG_HISTORY, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GetMsgListResp>>(){}) : null;
    }

    private ActionRaw doPoke(ActionPathEnum path, Consumer<Map<String, Object>> paramFiller) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        paramFiller.accept(params);
        JsonObjectWrapper result = this.actionHandler.action(this.session, path, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw sendFriendPoke(long userId) {
        return this.doPoke(ActionPathEnum.FRIEND_POKE, p -> p.put("user_id", userId));
    }

    @Override
    public ActionRaw sendFriendPoke(long userId, long targetId) {
        return this.doPoke(ActionPathEnum.FRIEND_POKE, p -> {
            p.put("user_id", userId);
            p.put("target_id", targetId);
        });
    }

    @Override
    public ActionRaw sendGroupPoke(long groupId, long userId) {
        return this.doPoke(ActionPathEnum.GROUP_POKE, p -> {
            p.put("group_id", groupId);
            p.put("user_id", userId);
        });
    }

    @Override
    public ActionRaw setGroupReaction(long groupId, int msgId, String code, boolean isAdd) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("group_id", groupId);
        params.put("message_id", msgId);
        params.put("code", code);
        params.put("is_add", isAdd);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_GROUP_REACTION, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    @Override
    public ActionRaw setMsgEmojiLike(int msgId, String code, boolean isSet) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", msgId);
        params.put("emoji_id", code);
        params.put("set", isSet);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.SET_MSG_EMOJI_LIKE, params);
        return result != null ? result.to(ActionRaw.class) : null;
    }

    public ActionData<GetForwardMsgResp> getForwardMsg(int msgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", msgId);
        JsonObjectWrapper result = this.actionHandler.action(this.session, ActionPathEnum.GET_FORWARD_MSG, params);
        return result != null ? JsonUtils.readValue(result.toJSONString(), new TypeReference<ActionData<GetForwardMsgResp>>(){}) : null;
    }

    public ActionData customRequest(ActionPath action, Map<String, Object> params) {
        JsonObjectWrapper result = this.actionHandler.action(this.session, action, params);
        return result != null ? result.to(ActionData.class) : null;
    }

    public <T> ActionData<T> customRequest(ActionPath action, Map<String, Object> params, Class<T> clazz) {
        JsonObjectWrapper result = this.actionHandler.action(this.session, action, params);
        try {
            return result != null ? (ActionData)JsonUtils.getObjectMapper().readValue(result.toJSONString(), JsonUtils.getObjectMapper().getTypeFactory().constructParametricType(ActionData.class, new Class[]{clazz})) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ActionData customRawRequest(ActionPath action, Map<String, Object> params) {
        JsonObjectWrapper result = this.actionHandler.rawAction(this.session, action, params);
        return result != null ? result.to(ActionData.class) : null;
    }

    public <T> ActionData<T> customRawRequest(ActionPath action, Map<String, Object> params, Class<T> clazz) {
        JsonObjectWrapper result = this.actionHandler.rawAction(this.session, action, params);
        try {
            return result != null ? (ActionData)JsonUtils.getObjectMapper().readValue(result.toJSONString(), JsonUtils.getObjectMapper().getTypeFactory().constructParametricType(ActionData.class, new Class[]{clazz})) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Generated
    public long getSelfId() {
        return this.selfId;
    }

    @Generated
    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    @Generated
    public WebSocketSession getSession() {
        return this.session;
    }

    @Generated
    public List<Class<? extends BotPlugin>> getPluginList() {
        return this.pluginList;
    }

    @Generated
    public BotFactory.AnnotationMethodContainer getAnnotationMethodContainer() {
        return this.annotationMethodContainer;
    }

    @Generated
    public Class<? extends BotMessageEventInterceptor> getBotMessageEventInterceptor() {
        return this.botMessageEventInterceptor;
    }

    @Generated
    public void setSelfId(long selfId) {
        this.selfId = selfId;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Generated
    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    @Generated
    public void setPluginList(List<Class<? extends BotPlugin>> pluginList) {
        this.pluginList = pluginList;
    }

    @Generated
    public void setAnnotationMethodContainer(BotFactory.AnnotationMethodContainer annotationMethodContainer) {
        this.annotationMethodContainer = annotationMethodContainer;
    }

    @Generated
    public void setBotMessageEventInterceptor(Class<? extends BotMessageEventInterceptor> botMessageEventInterceptor) {
        this.botMessageEventInterceptor = botMessageEventInterceptor;
    }
}

