/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.core;

import com.mikuac.shiro.annotation.common.Order;
import com.mikuac.shiro.annotation.common.Shiro;
import com.mikuac.shiro.common.utils.AnnotationScanner;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.handler.ActionHandler;
import com.mikuac.shiro.model.HandlerMethod;
import com.mikuac.shiro.properties.ShiroProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.WebSocketSession;

@Component
public class BotFactory
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BotFactory.class);
    private static Set<Class<?>> annotations = new LinkedHashSet();
    private final ActionHandler actionHandler;
    private final ShiroProperties shiroProps;
    private final ApplicationContext applicationContext;
    private final AnnotationMethodContainer annotationMethodContainer = new AnnotationMethodContainer();

    @Autowired
    public BotFactory(ActionHandler actionHandler, ShiroProperties shiroProps, ApplicationContext applicationContext) {
        this.actionHandler = actionHandler;
        this.shiroProps = shiroProps;
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(@NonNull ContextRefreshedEvent event) {
        log.debug("Starting to collect beans with @Shiro annotation");
        HashMap<String, Object> beans = new HashMap<String, Object>(this.applicationContext.getBeansWithAnnotation(Shiro.class));
        log.debug("Found {} beans with @Shiro annotation", (Object)beans.size());
        MultiValueMap<Class<? extends Annotation>, HandlerMethod> annotationHandler = this.extractMethods(beans);
        log.debug("Starting handler method sorting");
        this.sort(annotationHandler);
        log.debug("Handler methods sorted, total size: {}", (Object)annotationHandler.size());
        this.annotationMethodContainer.setAnnotationHandler(annotationHandler);
    }

    private static Set<Class<?>> getAnnotations() {
        if (!annotations.isEmpty()) {
            log.debug("Using cached annotations, size: {}", (Object)annotations.size());
            return annotations;
        }
        log.debug("Scanning for annotations in package: com.mikuac.shiro.annotation");
        annotations = new AnnotationScanner().scan("com.mikuac.shiro.annotation");
        log.debug("Found {} annotations", (Object)annotations.size());
        return annotations;
    }

    private MultiValueMap<Class<? extends Annotation>, HandlerMethod> extractMethods(Map<String, Object> beans) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        beans.values().forEach(arg_0 -> BotFactory.lambda$extractMethods$2((MultiValueMap)result, arg_0));
        return result;
    }

    public Bot createBot(long selfId, WebSocketSession session) {
        log.debug("Bot instance creation started: {}", (Object)selfId);
        log.debug("Using WebSocket session: {}", (Object)session.getId());
        log.debug("Plugin list size: {}", (Object)this.shiroProps.getPluginList().size());
        Bot bot = new Bot(selfId, session, this.actionHandler, this.shiroProps.getPluginList(), this.annotationMethodContainer, this.shiroProps.getInterceptor());
        log.debug("Bot instance created successfully for ID: {}", (Object)selfId);
        return bot;
    }

    private void sort(MultiValueMap<Class<? extends Annotation>, HandlerMethod> annotationHandler) {
        if (annotationHandler.isEmpty()) {
            log.debug("No handlers to sort");
            return;
        }
        log.debug("Starting to sort handlers by @Order annotation");
        annotationHandler.keySet().forEach(annotation -> {
            log.debug("Sorting handlers for annotation: {}", (Object)annotation.getSimpleName());
            List handlers = (List)annotationHandler.get(annotation);
            handlers = handlers.stream().distinct().sorted(Comparator.comparing(handlerMethod -> {
                Order order = handlerMethod.getMethod().getAnnotation(Order.class);
                int orderValue = Optional.ofNullable(order == null ? null : Integer.valueOf(order.value())).orElse(Integer.MAX_VALUE);
                log.debug("Method: {}.{} has order value: {}", new Object[]{handlerMethod.getType().getSimpleName(), handlerMethod.getMethod().getName(), orderValue});
                return orderValue;
            })).collect(Collectors.toCollection(ArrayList::new));
            log.debug("Sorted {} handlers for annotation: {}", (Object)handlers.size(), (Object)annotation.getSimpleName());
            annotationHandler.put(annotation, (Object)handlers);
            log.debug("Handler sorting completed");
        });
    }

    private static /* synthetic */ void lambda$extractMethods$2(MultiValueMap result, Object obj) {
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)obj);
        log.debug("Processing class: {}", (Object)targetClass.getName());
        Arrays.stream(targetClass.getMethods()).forEach(method -> {
            HandlerMethod handlerMethod = new HandlerMethod();
            handlerMethod.setMethod((Method)method);
            handlerMethod.setType(targetClass);
            handlerMethod.setObject(obj);
            log.debug("Processing method: {}.{}", (Object)targetClass.getSimpleName(), (Object)method.getName());
            Arrays.stream(method.getDeclaredAnnotations()).forEach(annotation -> {
                Class<? extends Annotation> annotationType;
                Set<Class<?>> as = BotFactory.getAnnotations();
                if (as.contains(annotationType = annotation.annotationType())) {
                    log.debug("Adding handler for annotation: {} on method: {}.{}", new Object[]{annotationType.getSimpleName(), targetClass.getSimpleName(), method.getName()});
                    result.add(annotation.annotationType(), (Object)handlerMethod);
                }
            });
        });
    }

    public static class AnnotationMethodContainer {
        private volatile MultiValueMap<Class<? extends Annotation>, HandlerMethod> annotationHandler = new LinkedMultiValueMap();

        @Generated
        public MultiValueMap<Class<? extends Annotation>, HandlerMethod> getAnnotationHandler() {
            return this.annotationHandler;
        }

        @Generated
        public void setAnnotationHandler(MultiValueMap<Class<? extends Annotation>, HandlerMethod> annotationHandler) {
            this.annotationHandler = annotationHandler;
        }
    }
}

