/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.dto.event.message;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.mikuac.shiro.common.utils.JsonUtils;
import com.mikuac.shiro.common.utils.MessageConverser;
import com.mikuac.shiro.dto.event.Event;
import com.mikuac.shiro.model.ArrayMsg;
import java.util.List;
import lombok.Generated;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MessageEvent
extends Event {
    @JsonProperty(value="message_type")
    private String messageType;
    @JsonProperty(value="user_id")
    private Long userId;
    @JsonIgnore
    private String message;
    @JsonProperty(value="raw_message")
    private String rawMessage;
    @JsonProperty(value="font")
    private Integer font;
    @JsonIgnore
    private List<ArrayMsg> arrayMsg;

    @JsonSetter(value="message")
    private void setMessageFromJson(JsonNode json) {
        if (json.isTextual()) {
            this.message = json.asText();
            this.arrayMsg = MessageConverser.stringToArray(this.message);
        } else if (json.isArray()) {
            this.arrayMsg = JsonUtils.parseArray(json, ArrayMsg.class);
            this.message = MessageConverser.arraysToString(this.arrayMsg);
        } else {
            throw new IllegalArgumentException("Invalid message format: " + String.valueOf(json));
        }
    }

    @JsonIgnore
    public void setMessage(String message) {
        this.message = message;
        this.arrayMsg = MessageConverser.stringToArray(message);
    }

    @JsonGetter(value="message")
    public String getMessage() {
        if (!StringUtils.hasText((String)this.message) && !CollectionUtils.isEmpty(this.arrayMsg)) {
            this.message = MessageConverser.arraysToString(this.arrayMsg);
        }
        return this.message;
    }

    @Generated
    protected MessageEvent(MessageEventBuilder<?, ?> b) {
        super(b);
        this.messageType = b.messageType;
        this.userId = b.userId;
        this.message = b.message;
        this.rawMessage = b.rawMessage;
        this.font = b.font;
        this.arrayMsg = b.arrayMsg;
    }

    @Generated
    public static MessageEventBuilder<?, ?> builder() {
        return new MessageEventBuilderImpl();
    }

    @Generated
    public MessageEventBuilder<?, ?> toBuilder() {
        return new MessageEventBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getMessageType() {
        return this.messageType;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public String getRawMessage() {
        return this.rawMessage;
    }

    @Generated
    public Integer getFont() {
        return this.font;
    }

    @Generated
    public List<ArrayMsg> getArrayMsg() {
        return this.arrayMsg;
    }

    @JsonProperty(value="message_type")
    @Generated
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @JsonProperty(value="raw_message")
    @Generated
    public void setRawMessage(String rawMessage) {
        this.rawMessage = rawMessage;
    }

    @JsonProperty(value="font")
    @Generated
    public void setFont(Integer font) {
        this.font = font;
    }

    @JsonIgnore
    @Generated
    public void setArrayMsg(List<ArrayMsg> arrayMsg) {
        this.arrayMsg = arrayMsg;
    }

    @Override
    @Generated
    public String toString() {
        return "MessageEvent(messageType=" + this.getMessageType() + ", userId=" + this.getUserId() + ", message=" + this.getMessage() + ", rawMessage=" + this.getRawMessage() + ", font=" + this.getFont() + ", arrayMsg=" + String.valueOf(this.getArrayMsg()) + ")";
    }

    @Generated
    public MessageEvent() {
    }

    @Generated
    public MessageEvent(String messageType, Long userId, String message, String rawMessage, Integer font, List<ArrayMsg> arrayMsg) {
        this.messageType = messageType;
        this.userId = userId;
        this.message = message;
        this.rawMessage = rawMessage;
        this.font = font;
        this.arrayMsg = arrayMsg;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEvent)) {
            return false;
        }
        MessageEvent other = (MessageEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$font = this.getFont();
        Integer other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        String this$messageType = this.getMessageType();
        String other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$rawMessage = this.getRawMessage();
        String other$rawMessage = other.getRawMessage();
        if (this$rawMessage == null ? other$rawMessage != null : !this$rawMessage.equals(other$rawMessage)) {
            return false;
        }
        List<ArrayMsg> this$arrayMsg = this.getArrayMsg();
        List<ArrayMsg> other$arrayMsg = other.getArrayMsg();
        return !(this$arrayMsg == null ? other$arrayMsg != null : !((Object)this$arrayMsg).equals(other$arrayMsg));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        String $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $rawMessage = this.getRawMessage();
        result = result * 59 + ($rawMessage == null ? 43 : $rawMessage.hashCode());
        List<ArrayMsg> $arrayMsg = this.getArrayMsg();
        result = result * 59 + ($arrayMsg == null ? 43 : ((Object)$arrayMsg).hashCode());
        return result;
    }

    @Generated
    public static abstract class MessageEventBuilder<C extends MessageEvent, B extends MessageEventBuilder<C, B>>
    extends Event.EventBuilder<C, B> {
        @Generated
        private String messageType;
        @Generated
        private Long userId;
        @Generated
        private String message;
        @Generated
        private String rawMessage;
        @Generated
        private Integer font;
        @Generated
        private List<ArrayMsg> arrayMsg;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MessageEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MessageEvent instance, MessageEventBuilder<?, ?> b) {
            b.messageType(instance.messageType);
            b.userId(instance.userId);
            b.message(instance.message);
            b.rawMessage(instance.rawMessage);
            b.font(instance.font);
            b.arrayMsg(instance.arrayMsg);
        }

        @JsonProperty(value="message_type")
        @Generated
        public B messageType(String messageType) {
            this.messageType = messageType;
            return (B)this.self();
        }

        @JsonProperty(value="user_id")
        @Generated
        public B userId(Long userId) {
            this.userId = userId;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B message(String message) {
            this.message = message;
            return (B)this.self();
        }

        @JsonProperty(value="raw_message")
        @Generated
        public B rawMessage(String rawMessage) {
            this.rawMessage = rawMessage;
            return (B)this.self();
        }

        @JsonProperty(value="font")
        @Generated
        public B font(Integer font) {
            this.font = font;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B arrayMsg(List<ArrayMsg> arrayMsg) {
            this.arrayMsg = arrayMsg;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MessageEvent.MessageEventBuilder(super=" + super.toString() + ", messageType=" + this.messageType + ", userId=" + this.userId + ", message=" + this.message + ", rawMessage=" + this.rawMessage + ", font=" + this.font + ", arrayMsg=" + String.valueOf(this.arrayMsg) + ")";
        }
    }

    @Generated
    private static final class MessageEventBuilderImpl
    extends MessageEventBuilder<MessageEvent, MessageEventBuilderImpl> {
        @Generated
        private MessageEventBuilderImpl() {
        }

        @Override
        @Generated
        protected MessageEventBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MessageEvent build() {
            return new MessageEvent(this);
        }
    }
}

