/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler;

import com.mikuac.shiro.common.utils.JsonObjectWrapper;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.handler.event.MessageEvent;
import com.mikuac.shiro.handler.event.MetaEvent;
import com.mikuac.shiro.handler.event.NoticeEvent;
import com.mikuac.shiro.handler.event.NotifyEvent;
import com.mikuac.shiro.handler.event.RequestEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class EventHandler
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventHandler.class);
    private final MetaEvent meta;
    private final NoticeEvent notice;
    private final NotifyEvent notify;
    private final MessageEvent message;
    private final RequestEvent request;
    private final Map<String, BiConsumer<Bot, JsonObjectWrapper>> handlers = new HashMap<String, BiConsumer<Bot, JsonObjectWrapper>>();

    @Autowired
    public EventHandler(MetaEvent meta, NoticeEvent notice, NotifyEvent notify, MessageEvent message, RequestEvent request) {
        this.meta = meta;
        this.notice = notice;
        this.notify = notify;
        this.message = message;
        this.request = request;
    }

    public void run(ApplicationArguments args) {
        this.handlers.put("meta_event", this.meta::handler);
        this.handlers.put("message", this.message::handler);
        this.handlers.put("notice", this.notice::handler);
        this.handlers.put("request", this.request::handler);
        this.meta.handlers.put("heartbeat", this.meta::heartbeat);
        this.meta.handlers.put("lifecycle", this.meta::lifecycle);
        this.message.handlers.put("private", this.message::friend);
        this.message.handlers.put("group", this.message::group);
        this.message.handlers.put("guild", this.message::guild);
        this.notice.handlers.put("notify", this.notice::notify);
        this.notice.handlers.put("group_upload", this.notice::groupUpload);
        this.notice.handlers.put("group_admin", this.notice::groupAdmin);
        this.notice.handlers.put("group_decrease", this.notice::groupDecrease);
        this.notice.handlers.put("group_increase", this.notice::groupIncrease);
        this.notice.handlers.put("group_ban", this.notice::groupBan);
        this.notice.handlers.put("friend_add", this.notice::friendAdd);
        this.notice.handlers.put("group_recall", this.notice::groupMsgDelete);
        this.notice.handlers.put("friend_recall", this.notice::privateMsgDelete);
        this.notice.handlers.put("group_card", this.notice::groupCardChange);
        this.notice.handlers.put("offline_file", this.notice::offlineFile);
        this.notice.handlers.put("channel_created", this.notice::channelCreated);
        this.notice.handlers.put("channel_destroyed", this.notice::channelDestroyed);
        this.notice.handlers.put("channel_updated", this.notice::channelUpdated);
        this.notice.handlers.put("message_reactions_updated", this.notice::messageReactionsUpdated);
        this.notice.handlers.put("reaction", this.notice::groupReactionMessage);
        this.notice.handlers.put("group_msg_emoji_like", this.notice::messageEmojiLikeMessage);
        this.notify.handlers.put("poke", this.notify::poke);
        this.notify.handlers.put("lucky_king", this.notify::luckyKing);
        this.notify.handlers.put("honor", this.notify::honor);
        this.request.handlers.put("friend", this.request::friend);
        this.request.handlers.put("group", this.request::group);
    }

    public void handler(Bot bot, JsonObjectWrapper resp) {
        String postType = resp.getString("post_type");
        this.handlers.getOrDefault(postType, (b, e) -> {}).accept(bot, resp);
    }
}

