/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.event;

import com.mikuac.shiro.common.utils.EventUtils;
import com.mikuac.shiro.common.utils.GroupMessageFilterUtils;
import com.mikuac.shiro.common.utils.JsonObjectWrapper;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.core.BotContainer;
import com.mikuac.shiro.dto.event.message.GroupMessageEvent;
import com.mikuac.shiro.dto.event.message.GuildMessageEvent;
import com.mikuac.shiro.dto.event.message.PrivateMessageEvent;
import com.mikuac.shiro.enums.MessageEventEnum;
import com.mikuac.shiro.handler.injection.InjectionHandler;
import com.mikuac.shiro.properties.ShiroProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageEvent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageEvent.class);
    private final EventUtils utils;
    private final ShiroProperties shiroProperties;
    private final BotContainer botContainer;
    private final InjectionHandler injection;
    public final Map<String, BiConsumer<Bot, JsonObjectWrapper>> handlers = new HashMap<String, BiConsumer<Bot, JsonObjectWrapper>>();

    @Autowired
    public MessageEvent(EventUtils utils, ShiroProperties shiroProperties, BotContainer botContainer, InjectionHandler injection) {
        this.utils = utils;
        this.shiroProperties = shiroProperties;
        this.botContainer = botContainer;
        this.injection = injection;
    }

    public void handler(Bot bot, JsonObjectWrapper resp) {
        String type = resp.getString("message_type");
        this.handlers.getOrDefault(type, (b, e) -> {}).accept(bot, resp);
    }

    private void process(Bot bot, JsonObjectWrapper resp, MessageEventEnum type) {
        try {
            boolean messageBlocked;
            com.mikuac.shiro.dto.event.message.MessageEvent event;
            if (type == MessageEventEnum.FRIEND) {
                event = resp.to(PrivateMessageEvent.class);
                if (this.utils.setInterceptor(bot, event)) {
                    return;
                }
                resp.put("message", event.getMessage());
                messageBlocked = this.utils.pushAnyMessageEvent(bot, resp, event.getArrayMsg());
                if (!messageBlocked) {
                    messageBlocked = this.injection.invokePrivateMessage(bot, (PrivateMessageEvent)event);
                }
                if (!messageBlocked) {
                    bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$1(bot, (PrivateMessageEvent)event, arg_0));
                }
                this.utils.getInterceptor(bot.getBotMessageEventInterceptor()).afterCompletion(bot, event);
            }
            if (type == MessageEventEnum.GROUP) {
                event = resp.to(GroupMessageEvent.class);
                if (Boolean.TRUE.equals(this.shiroProperties.getGroupEventFilter())) {
                    Long senderId = ((GroupMessageEvent)event).getSender().getUserId();
                    if (!GroupMessageFilterUtils.insertMessage((GroupMessageEvent)event, this.shiroProperties.getGroupEventFilterTime()) || this.shiroProperties.getGroupSelfBotEventFilter().booleanValue() && this.botContainer.robots.containsKey(senderId)) {
                        return;
                    }
                }
                if (this.utils.setInterceptor(bot, event)) {
                    return;
                }
                resp.put("message", event.getMessage());
                messageBlocked = this.utils.pushAnyMessageEvent(bot, resp, event.getArrayMsg());
                if (!messageBlocked) {
                    messageBlocked = this.injection.invokeGroupMessage(bot, (GroupMessageEvent)event);
                }
                if (!messageBlocked) {
                    bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$2(bot, (GroupMessageEvent)event, arg_0));
                }
                this.utils.getInterceptor(bot.getBotMessageEventInterceptor()).afterCompletion(bot, event);
            }
            if (type == MessageEventEnum.GUILD) {
                event = resp.to(GuildMessageEvent.class);
                if (this.utils.setInterceptor(bot, event)) {
                    return;
                }
                messageBlocked = this.injection.invokeGuildMessage(bot, (GuildMessageEvent)event);
                if (!messageBlocked) {
                    bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$3(bot, (GuildMessageEvent)event, arg_0));
                }
                this.utils.getInterceptor(bot.getBotMessageEventInterceptor()).afterCompletion(bot, event);
            }
        }
        catch (Exception e) {
            log.error("Message event process exception: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void friend(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, MessageEventEnum.FRIEND);
    }

    public void group(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, MessageEventEnum.GROUP);
    }

    public void guild(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, MessageEventEnum.GUILD);
    }

    private /* synthetic */ boolean lambda$process$3(Bot bot, GuildMessageEvent event, Class o) {
        return this.utils.getPlugin(o).onGuildMessage(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$2(Bot bot, GroupMessageEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupMessage(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$1(Bot bot, PrivateMessageEvent event, Class o) {
        return this.utils.getPlugin(o).onPrivateMessage(bot, event) == 1;
    }
}

