/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.event;

import com.mikuac.shiro.common.utils.JsonObjectWrapper;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.dto.event.meta.HeartbeatMetaEvent;
import com.mikuac.shiro.dto.event.meta.LifecycleMetaEvent;
import com.mikuac.shiro.enums.MetaEventEnum;
import com.mikuac.shiro.handler.injection.InjectionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetaEvent {
    private final InjectionHandler injection;
    public final Map<String, BiConsumer<Bot, JsonObjectWrapper>> handlers = new HashMap<String, BiConsumer<Bot, JsonObjectWrapper>>();

    @Autowired
    public MetaEvent(InjectionHandler injectionHandler) {
        this.injection = injectionHandler;
    }

    public void handler(Bot bot, JsonObjectWrapper resp) {
        String type = resp.getString("meta_event_type");
        this.handlers.getOrDefault(type, (b, e) -> {}).accept(bot, resp);
    }

    public void heartbeat(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, MetaEventEnum.HEARTBEAT);
    }

    public void lifecycle(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, MetaEventEnum.LIFECYCLE);
    }

    private void process(Bot bot, JsonObjectWrapper resp, MetaEventEnum type) {
        switch (type) {
            case HEARTBEAT: {
                HeartbeatMetaEvent event = resp.to(HeartbeatMetaEvent.class);
                this.injection.invokeHeartbeat(bot, event);
                break;
            }
            case LIFECYCLE: {
                LifecycleMetaEvent event = resp.to(LifecycleMetaEvent.class);
                this.injection.invokeLifecycle(bot, event);
                break;
            }
        }
    }
}

