/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.event;

import com.mikuac.shiro.common.utils.EventUtils;
import com.mikuac.shiro.common.utils.JsonObjectWrapper;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.dto.event.notice.ChannelCreatedNoticeEvent;
import com.mikuac.shiro.dto.event.notice.ChannelDestroyedNoticeEvent;
import com.mikuac.shiro.dto.event.notice.ChannelUpdatedNoticeEvent;
import com.mikuac.shiro.dto.event.notice.FriendAddNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupAdminNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupBanNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupCardChangeNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupDecreaseNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupIncreaseNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupMessageReactionNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupMsgDeleteNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupUploadNoticeEvent;
import com.mikuac.shiro.dto.event.notice.MessageEmojiLikeNoticeEvent;
import com.mikuac.shiro.dto.event.notice.MessageReactionsUpdatedNoticeEvent;
import com.mikuac.shiro.dto.event.notice.PrivateMsgDeleteNoticeEvent;
import com.mikuac.shiro.dto.event.notice.ReceiveOfflineFilesNoticeEvent;
import com.mikuac.shiro.enums.NoticeEventEnum;
import com.mikuac.shiro.handler.event.NotifyEvent;
import com.mikuac.shiro.handler.injection.InjectionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoticeEvent {
    private final EventUtils utils;
    private final NotifyEvent notify;
    private final InjectionHandler injection;
    public final Map<String, BiConsumer<Bot, JsonObjectWrapper>> handlers = new HashMap<String, BiConsumer<Bot, JsonObjectWrapper>>();

    @Autowired
    public NoticeEvent(EventUtils eventUtils, NotifyEvent notifyEvent, InjectionHandler injectionHandler) {
        this.utils = eventUtils;
        this.notify = notifyEvent;
        this.injection = injectionHandler;
    }

    public void handler(Bot bot, JsonObjectWrapper resp) {
        String type = resp.getString("notice_type");
        this.handlers.getOrDefault(type, (b, e) -> {}).accept(bot, resp);
    }

    private void process(Bot bot, JsonObjectWrapper resp, NoticeEventEnum type) {
        com.mikuac.shiro.dto.event.notice.NoticeEvent event;
        if (type == NoticeEventEnum.GROUP_UPLOAD) {
            event = resp.to(GroupUploadNoticeEvent.class);
            this.injection.invokeGroupUploadNotice(bot, (GroupUploadNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$1(bot, (GroupUploadNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.GROUP_ADMIN) {
            event = resp.to(GroupAdminNoticeEvent.class);
            this.injection.invokeGroupAdmin(bot, (GroupAdminNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$2(bot, (GroupAdminNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.GROUP_DECREASE) {
            event = resp.to(GroupDecreaseNoticeEvent.class);
            this.injection.invokeGroupDecrease(bot, (GroupDecreaseNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$3(bot, (GroupDecreaseNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.GROUP_INCREASE) {
            event = resp.to(GroupIncreaseNoticeEvent.class);
            this.injection.invokeGroupIncrease(bot, (GroupIncreaseNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$4(bot, (GroupIncreaseNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.GROUP_BAN) {
            event = resp.to(GroupBanNoticeEvent.class);
            this.injection.invokeGroupBanNotice(bot, (GroupBanNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$5(bot, (GroupBanNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.FRIEND_ADD) {
            event = resp.to(FriendAddNoticeEvent.class);
            this.injection.invokeFriendAdd(bot, (FriendAddNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$6(bot, (FriendAddNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.GROUP_MSG_DELETE) {
            event = resp.to(GroupMsgDeleteNoticeEvent.class);
            this.injection.invokeGroupRecall(bot, (GroupMsgDeleteNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$7(bot, (GroupMsgDeleteNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.PRIVATE_MSG_DELETE) {
            event = resp.to(PrivateMsgDeleteNoticeEvent.class);
            this.injection.invokeFriendRecall(bot, (PrivateMsgDeleteNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$8(bot, (PrivateMsgDeleteNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.GROUP_CARD_CHANGE) {
            event = resp.to(GroupCardChangeNoticeEvent.class);
            this.injection.invokeGroupCardChangeNotice(bot, (GroupCardChangeNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$9(bot, (GroupCardChangeNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.GROUP_MESSAGE_REACTION) {
            event = resp.to(GroupMessageReactionNoticeEvent.class);
            this.injection.invokeGroupReactionNotice(bot, (GroupMessageReactionNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$10(bot, (GroupMessageReactionNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.MESSAGE_EMOJI_LIKE) {
            event = resp.to(MessageEmojiLikeNoticeEvent.class);
            this.injection.invokeMessageEmojiLikeNotice(bot, (MessageEmojiLikeNoticeEvent)event);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$11(bot, (MessageEmojiLikeNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.OFFLINE_FILE) {
            event = resp.to(ReceiveOfflineFilesNoticeEvent.class);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$12(bot, (ReceiveOfflineFilesNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.CHANNEL_CREATED) {
            event = resp.to(ChannelCreatedNoticeEvent.class);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$13(bot, (ChannelCreatedNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.CHANNEL_DESTROYED) {
            event = resp.to(ChannelDestroyedNoticeEvent.class);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$14(bot, (ChannelDestroyedNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.CHANNEL_UPDATED) {
            event = resp.to(ChannelUpdatedNoticeEvent.class);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$15(bot, (ChannelUpdatedNoticeEvent)event, arg_0));
        }
        if (type == NoticeEventEnum.MESSAGE_REACTIONS_UPDATED) {
            event = resp.to(MessageReactionsUpdatedNoticeEvent.class);
            bot.getPluginList().stream().anyMatch(arg_0 -> this.lambda$process$16(bot, (MessageReactionsUpdatedNoticeEvent)event, arg_0));
        }
    }

    public void groupUpload(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.GROUP_UPLOAD);
    }

    public void groupAdmin(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.GROUP_ADMIN);
    }

    public void groupDecrease(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.GROUP_DECREASE);
    }

    public void groupIncrease(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.GROUP_INCREASE);
    }

    public void groupBan(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.GROUP_BAN);
    }

    public void friendAdd(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.FRIEND_ADD);
    }

    public void groupMsgDelete(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.GROUP_MSG_DELETE);
    }

    public void privateMsgDelete(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.PRIVATE_MSG_DELETE);
    }

    public void groupCardChange(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.GROUP_CARD_CHANGE);
    }

    public void offlineFile(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.OFFLINE_FILE);
    }

    public void channelCreated(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.CHANNEL_CREATED);
    }

    public void channelDestroyed(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.CHANNEL_DESTROYED);
    }

    public void channelUpdated(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.CHANNEL_UPDATED);
    }

    public void messageReactionsUpdated(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.MESSAGE_REACTIONS_UPDATED);
    }

    public void notify(Bot bot, JsonObjectWrapper resp) {
        this.notify.handler(bot, resp);
    }

    public void groupReactionMessage(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.GROUP_MESSAGE_REACTION);
    }

    public void messageEmojiLikeMessage(Bot bot, JsonObjectWrapper resp) {
        this.process(bot, resp, NoticeEventEnum.MESSAGE_EMOJI_LIKE);
    }

    private /* synthetic */ boolean lambda$process$16(Bot bot, MessageReactionsUpdatedNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onMessageReactionsUpdatedNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$15(Bot bot, ChannelUpdatedNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onChannelUpdatedNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$14(Bot bot, ChannelDestroyedNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onChannelDestroyedNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$13(Bot bot, ChannelCreatedNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onChannelCreatedNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$12(Bot bot, ReceiveOfflineFilesNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onReceiveOfflineFilesNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$11(Bot bot, MessageEmojiLikeNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onMessageEmojiLikeNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$10(Bot bot, GroupMessageReactionNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupReactionNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$9(Bot bot, GroupCardChangeNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupCardChangeNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$8(Bot bot, PrivateMsgDeleteNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onPrivateMsgDeleteNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$7(Bot bot, GroupMsgDeleteNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupMsgDeleteNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$6(Bot bot, FriendAddNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onFriendAddNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$5(Bot bot, GroupBanNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupBanNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$4(Bot bot, GroupIncreaseNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupIncreaseNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$3(Bot bot, GroupDecreaseNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupDecreaseNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$2(Bot bot, GroupAdminNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupAdminNotice(bot, event) == 1;
    }

    private /* synthetic */ boolean lambda$process$1(Bot bot, GroupUploadNoticeEvent event, Class o) {
        return this.utils.getPlugin(o).onGroupUploadNotice(bot, event) == 1;
    }
}

