/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.handler.injection;

import com.mikuac.shiro.annotation.AnyMessageHandler;
import com.mikuac.shiro.annotation.FriendAddNoticeHandler;
import com.mikuac.shiro.annotation.FriendAddRequestHandler;
import com.mikuac.shiro.annotation.GroupAddRequestHandler;
import com.mikuac.shiro.annotation.GroupAdminHandler;
import com.mikuac.shiro.annotation.GroupBanNoticeHandler;
import com.mikuac.shiro.annotation.GroupCardChangeNoticeHandler;
import com.mikuac.shiro.annotation.GroupDecreaseHandler;
import com.mikuac.shiro.annotation.GroupIncreaseHandler;
import com.mikuac.shiro.annotation.GroupMessageHandler;
import com.mikuac.shiro.annotation.GroupMsgDeleteNoticeHandler;
import com.mikuac.shiro.annotation.GroupPokeNoticeHandler;
import com.mikuac.shiro.annotation.GroupReactionNoticeHandler;
import com.mikuac.shiro.annotation.GroupUploadNoticeHandler;
import com.mikuac.shiro.annotation.GuildMessageHandler;
import com.mikuac.shiro.annotation.MessageEmojiLikeNoticeHandler;
import com.mikuac.shiro.annotation.MessageHandlerFilter;
import com.mikuac.shiro.annotation.MetaHandler;
import com.mikuac.shiro.annotation.PrivateMessageHandler;
import com.mikuac.shiro.annotation.PrivateMsgDeleteNoticeHandler;
import com.mikuac.shiro.annotation.PrivatePokeNoticeHandler;
import com.mikuac.shiro.common.utils.CheckResult;
import com.mikuac.shiro.common.utils.CommonUtils;
import com.mikuac.shiro.common.utils.InternalUtils;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.dto.event.message.AnyMessageEvent;
import com.mikuac.shiro.dto.event.message.GroupMessageEvent;
import com.mikuac.shiro.dto.event.message.GuildMessageEvent;
import com.mikuac.shiro.dto.event.message.MessageEvent;
import com.mikuac.shiro.dto.event.message.PrivateMessageEvent;
import com.mikuac.shiro.dto.event.meta.HeartbeatMetaEvent;
import com.mikuac.shiro.dto.event.meta.LifecycleMetaEvent;
import com.mikuac.shiro.dto.event.notice.FriendAddNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupAdminNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupBanNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupCardChangeNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupDecreaseNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupIncreaseNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupMessageReactionNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupMsgDeleteNoticeEvent;
import com.mikuac.shiro.dto.event.notice.GroupUploadNoticeEvent;
import com.mikuac.shiro.dto.event.notice.MessageEmojiLikeNoticeEvent;
import com.mikuac.shiro.dto.event.notice.PokeNoticeEvent;
import com.mikuac.shiro.dto.event.notice.PrivateMsgDeleteNoticeEvent;
import com.mikuac.shiro.dto.event.request.FriendAddRequestEvent;
import com.mikuac.shiro.dto.event.request.GroupAddRequestEvent;
import com.mikuac.shiro.enums.AdminNoticeTypeEnum;
import com.mikuac.shiro.enums.CommonEnum;
import com.mikuac.shiro.enums.MetaEventEnum;
import com.mikuac.shiro.model.HandlerMethod;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InjectionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InjectionHandler.class);

    private Object invokeMethod(HandlerMethod method, Map<Class<?>, Object> params) {
        Class<?>[] paramTypes = method.getMethod().getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        Arrays.stream(paramTypes).forEach(InternalUtils.consumerWithIndex((paramType, index) -> {
            args[index] = params.get(paramType);
        }));
        Object invokeResult = null;
        try {
            invokeResult = method.getMethod().invoke(method.getObject(), args);
        }
        catch (Exception e) {
            String methodName = method.getMethod().getDeclaringClass().getSimpleName() + "#" + method.getMethod().getName();
            log.error("Invoke method exception on [{}]: {}", new Object[]{methodName, e.getMessage(), e});
        }
        return invokeResult;
    }

    private <T> void invoke(Bot bot, T event, Class<? extends Annotation> type) {
        HandlerMethod method;
        Optional<List> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(type));
        if (methods.isEmpty()) {
            return;
        }
        HashMap params = new HashMap();
        params.put(Bot.class, bot);
        params.put(event.getClass(), event);
        Iterator iterator = methods.get().iterator();
        while (iterator.hasNext() && !this.isBlockingResult(this.invokeMethod(method = (HandlerMethod)iterator.next(), params))) {
        }
    }

    private <T> Object invoke(Bot bot, T event, HandlerMethod method, Matcher matcher) {
        HashMap params = new HashMap();
        if (matcher != null) {
            params.put(Matcher.class, matcher);
        }
        params.put(Bot.class, bot);
        params.put(event.getClass(), event);
        return this.invokeMethod(method, params);
    }

    public void invokeGroupRecall(Bot bot, GroupMsgDeleteNoticeEvent event) {
        this.invoke(bot, event, GroupMsgDeleteNoticeHandler.class);
    }

    public void invokeFriendRecall(Bot bot, PrivateMsgDeleteNoticeEvent event) {
        this.invoke(bot, event, PrivateMsgDeleteNoticeHandler.class);
    }

    public void invokeFriendAdd(Bot bot, FriendAddNoticeEvent event) {
        this.invoke(bot, event, FriendAddNoticeHandler.class);
    }

    public void invokeGroupIncrease(Bot bot, GroupIncreaseNoticeEvent event) {
        this.invoke(bot, event, GroupIncreaseHandler.class);
    }

    public void invokeGroupDecrease(Bot bot, GroupDecreaseNoticeEvent event) {
        this.invoke(bot, event, GroupDecreaseHandler.class);
    }

    public void invokeFriendAddRequest(Bot bot, FriendAddRequestEvent event) {
        this.invoke(bot, event, FriendAddRequestHandler.class);
    }

    public void invokeGroupAddRequest(Bot bot, GroupAddRequestEvent event) {
        this.invoke(bot, event, GroupAddRequestHandler.class);
    }

    public void invokeGroupBanNotice(Bot bot, GroupBanNoticeEvent event) {
        this.invoke(bot, event, GroupBanNoticeHandler.class);
    }

    public void invokeGroupCardChangeNotice(Bot bot, GroupCardChangeNoticeEvent event) {
        this.invoke(bot, event, GroupCardChangeNoticeHandler.class);
    }

    public void invokeGroupPokeNotice(Bot bot, PokeNoticeEvent event) {
        this.invoke(bot, event, GroupPokeNoticeHandler.class);
    }

    public void invokeGroupUploadNotice(Bot bot, GroupUploadNoticeEvent event) {
        this.invoke(bot, event, GroupUploadNoticeHandler.class);
    }

    public void invokePrivatePokeNotice(Bot bot, PokeNoticeEvent event) {
        this.invoke(bot, event, PrivatePokeNoticeHandler.class);
    }

    public void invokeGroupReactionNotice(Bot bot, GroupMessageReactionNoticeEvent event) {
        this.invoke(bot, event, GroupReactionNoticeHandler.class);
    }

    public void invokeMessageEmojiLikeNotice(Bot bot, MessageEmojiLikeNoticeEvent event) {
        this.invoke(bot, event, MessageEmojiLikeNoticeHandler.class);
    }

    public boolean invokeAnyMessage(Bot bot, AnyMessageEvent event) {
        Optional<List<HandlerMethod>> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(AnyMessageHandler.class));
        return this.invokeMessage(bot, event, methods);
    }

    public boolean invokeGuildMessage(Bot bot, GuildMessageEvent event) {
        Optional<List<HandlerMethod>> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(GuildMessageHandler.class));
        return this.invokeMessage(bot, event, methods);
    }

    public boolean invokeGroupMessage(Bot bot, GroupMessageEvent event) {
        Optional<List<HandlerMethod>> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(GroupMessageHandler.class));
        return this.invokeMessage(bot, event, methods);
    }

    public boolean invokePrivateMessage(Bot bot, PrivateMessageEvent event) {
        Optional<List<HandlerMethod>> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(PrivateMessageHandler.class));
        return this.invokeMessage(bot, event, methods);
    }

    public boolean invokeMessage(Bot bot, MessageEvent event, Optional<List<HandlerMethod>> handlerMethods) {
        if (handlerMethods.isEmpty()) {
            return false;
        }
        for (HandlerMethod method : handlerMethods.get()) {
            MessageHandlerFilter filter = method.getMethod().getAnnotation(MessageHandlerFilter.class);
            Object invokeResult = null;
            if (Objects.isNull(filter)) {
                invokeResult = this.invoke(bot, event, method, null);
            } else {
                CheckResult result = CommonUtils.allFilterCheck(event, bot.getSelfId(), filter);
                if (result.isResult()) {
                    invokeResult = this.invoke(bot, event, method, result.getMatcher());
                }
            }
            if (!this.isBlockingResult(invokeResult)) continue;
            return true;
        }
        return false;
    }

    public void invokeGroupAdmin(Bot bot, GroupAdminNoticeEvent event) {
        Optional<List> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(GroupAdminHandler.class));
        if (methods.isEmpty()) {
            return;
        }
        methods.get().forEach(method -> {
            AdminNoticeTypeEnum type = method.getMethod().getAnnotation(GroupAdminHandler.class).type();
            if (type == AdminNoticeTypeEnum.OFF) {
                return;
            }
            if (type == AdminNoticeTypeEnum.UNSET && !CommonEnum.UNSET.value().equals(event.getSubType())) {
                return;
            }
            if (type == AdminNoticeTypeEnum.SET && !CommonEnum.SET.value().equals(event.getSubType())) {
                return;
            }
            this.invoke(bot, event, GroupAdminHandler.class);
        });
    }

    public void invokeHeartbeat(Bot bot, HeartbeatMetaEvent event) {
        Optional<List> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(MetaHandler.class));
        if (methods.isEmpty()) {
            return;
        }
        HashMap<Class, Object> params = new HashMap<Class, Object>();
        params.put(Bot.class, bot);
        params.put(HeartbeatMetaEvent.class, event);
        methods.get().forEach(method -> {
            MetaHandler anno = method.getMethod().getAnnotation(MetaHandler.class);
            if (anno.type() != MetaEventEnum.HEARTBEAT) {
                return;
            }
            this.invokeMethod((HandlerMethod)method, (Map<Class<?>, Object>)params);
        });
    }

    public void invokeLifecycle(Bot bot, LifecycleMetaEvent event) {
        Optional<List> methods = Optional.ofNullable((List)bot.getAnnotationHandler().get(MetaHandler.class));
        HashMap<Class, Object> params = new HashMap<Class, Object>();
        if (methods.isEmpty()) {
            return;
        }
        params.put(Bot.class, bot);
        params.put(LifecycleMetaEvent.class, event);
        methods.get().forEach(method -> {
            MetaHandler anno = method.getMethod().getAnnotation(MetaHandler.class);
            if (anno.type() != MetaEventEnum.LIFECYCLE) {
                return;
            }
            this.invokeMethod((HandlerMethod)method, (Map<Class<?>, Object>)params);
        });
    }

    private boolean isBlockingResult(Object result) {
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean && Boolean.TRUE.equals(result)) {
            return true;
        }
        return result.equals(1);
    }
}

