/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mikuac.shiro.common.utils.JsonUtils;
import com.mikuac.shiro.common.utils.ShiroUtils;
import com.mikuac.shiro.enums.MsgTypeEnum;
import java.util.Map;
import lombok.Generated;

public class ArrayMsg {
    @JsonIgnore
    private String type;
    @JsonProperty(value="data")
    private JsonNode data;

    @JsonIgnore
    public MsgTypeEnum getType() {
        return MsgTypeEnum.typeOf(this.type);
    }

    @JsonIgnore
    public ArrayMsg setType(MsgTypeEnum typeEnum) {
        this.type = typeEnum == null || !MsgTypeEnum.isValidMsgType(typeEnum) ? MsgTypeEnum.unknown.name() : typeEnum.name();
        return this;
    }

    @JsonGetter(value="type")
    private String getTypeString() {
        return this.type;
    }

    @JsonSetter
    public void setTypeString(String type) {
        this.type = type;
    }

    public String getRawType() {
        return this.type;
    }

    public ArrayMsg setRawType(String type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public <T> ArrayMsg setData(Map<String, T> map) {
        if (this.data == null) {
            this.data = JsonUtils.getObjectMapper().createObjectNode();
        }
        map.forEach((key, value) -> ((ObjectNode)this.data).set(key, JsonUtils.parseToJsonNode(value)));
        return this;
    }

    @JsonSetter(value="data")
    private void setData(JsonNode node) {
        this.data = node;
    }

    public String toCQCode() {
        if ("text".equalsIgnoreCase(this.type)) {
            return this.getStringData("text");
        }
        StringBuilder stringBuilder = new StringBuilder("[CQ:");
        stringBuilder.append(this.getRawType());
        this.data.properties().forEach(v -> {
            stringBuilder.append(',');
            stringBuilder.append((String)v.getKey());
            stringBuilder.append('=');
            stringBuilder.append(ShiroUtils.escape(JsonUtils.nodeToString((JsonNode)v.getValue())));
        });
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public long getLongData(String key) {
        return this.data.has(key) ? this.data.get(key).asLong() : 0L;
    }

    public String getStringData(String key) {
        return this.data.has(key) ? JsonUtils.nodeToString(this.data.get(key)) : "";
    }

    @Generated
    public ArrayMsg() {
    }

    @Generated
    public JsonNode getData() {
        return this.data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayMsg)) {
            return false;
        }
        ArrayMsg other = (ArrayMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MsgTypeEnum this$type = this.getType();
        MsgTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        JsonNode this$data = this.getData();
        JsonNode other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArrayMsg;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MsgTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        JsonNode $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArrayMsg(type=" + String.valueOf((Object)this.getType()) + ", data=" + String.valueOf(this.getData()) + ")";
    }
}

