/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.milaboratory.cli.Action;
import com.milaboratory.cli.ActionHelpProvider;
import com.milaboratory.cli.ActionHelper;
import com.milaboratory.cli.ActionParametersParser;
import com.milaboratory.cli.AllowNoArguments;
import com.milaboratory.cli.HiddenAction;
import com.milaboratory.cli.ProcessException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class JCommanderBasedMain
implements ActionHelper {
    protected final Map<String, Action> actions = new LinkedHashMap<String, Action>();
    protected final String command;
    protected boolean printHelpOnError = false;
    protected boolean printStackTrace = false;
    protected Runnable shortVersionInfoCallback = null;
    protected Runnable fullVersionInfoCallback = null;
    protected PrintStream outputStream = System.err;
    protected String[] arguments;

    public JCommanderBasedMain(String command, Action ... actions) {
        this.command = command;
        for (Action action : actions) {
            this.reg(action);
        }
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public PrintStream getDefaultPrintStream() {
        return this.outputStream;
    }

    @Override
    public String getCommandLineArguments() {
        StringBuilder builder = new StringBuilder();
        for (String arg : this.arguments) {
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(arg);
        }
        return builder.toString();
    }

    public boolean isPrintStackTrace() {
        return this.printStackTrace;
    }

    public void setPrintStackTrace(boolean printStackTrace) {
        this.printStackTrace = printStackTrace;
    }

    protected void reg(Action a) {
        this.actions.put(a.command(), a);
    }

    public ProcessResult main(String ... args) throws Exception {
        this.arguments = args;
        if (args.length == 0) {
            this.printGlobalHelp();
            return ProcessResult.Help;
        }
        MainParameters mainParameters = this.getMainParameters();
        JCommander commander = new JCommander((Object)mainParameters);
        commander.setProgramName(this.command);
        for (Action a : this.actions.values()) {
            commander.addCommand(a.command(), (Object)a.params());
        }
        String commandName = args[0];
        Action action = this.actions.get(commandName);
        try {
            if (action != null && action instanceof ActionParametersParser) {
                ((ActionParametersParser)((Object)action)).parseParameters(Arrays.copyOfRange(args, 1, args.length));
            } else {
                commander.parse(args);
                if (mainParameters instanceof MainParametersWithVersion && ((MainParametersWithVersion)mainParameters).shortVersion()) {
                    this.shortVersionInfoCallback.run();
                    return ProcessResult.Version;
                }
                if (mainParameters instanceof MainParametersWithVersion && ((MainParametersWithVersion)mainParameters).fullVersion()) {
                    this.fullVersionInfoCallback.run();
                    return ProcessResult.Version;
                }
                if (mainParameters.help()) {
                    this.printGlobalHelp();
                    return ProcessResult.Help;
                }
                if (args.length == 1 && !args[0].startsWith("-") && !(action = this.actions.get(commandName)).getClass().isAnnotationPresent(AllowNoArguments.class)) {
                    System.out.println("Error: missing required arguments.\n");
                    this.printActionHelp(commander, action);
                    return ProcessResult.Error;
                }
                String parsedCommand = commander.getParsedCommand();
                if (parsedCommand == null || !this.actions.containsKey(parsedCommand)) {
                    if (parsedCommand == null) {
                        this.outputStream.println("No command specified.");
                    } else {
                        this.outputStream.println("Command " + parsedCommand + " not supported.");
                    }
                    this.outputStream.println("Use -h option to get a list of supported commands.");
                    return ProcessResult.Error;
                }
                action = this.actions.get(parsedCommand);
            }
            if (action.params().help()) {
                this.printActionHelp(commander, action);
            } else {
                action.params().validate();
                action.go(this);
            }
        }
        catch (ParameterException | ProcessException pe) {
            this.printException((RuntimeException)pe, commander, action);
            return ProcessResult.Error;
        }
        return ProcessResult.Ok;
    }

    private MainParameters getMainParameters() {
        return this.shortVersionInfoCallback != null ? new MainParametersWithVersion() : new MainParameters();
    }

    protected void printGlobalHelp() {
        JCommander tmpCommander = new JCommander((Object)this.getMainParameters());
        tmpCommander.setProgramName(this.command);
        for (Action a : this.actions.values()) {
            if (a.getClass().isAnnotationPresent(HiddenAction.class)) continue;
            tmpCommander.addCommand(a.command(), (Object)a.params());
        }
        StringBuilder builder = new StringBuilder();
        tmpCommander.usage(builder);
        this.outputStream.print(builder);
    }

    protected void printActionHelp(JCommander commander, Action action) {
        StringBuilder builder = new StringBuilder();
        if (action instanceof ActionHelpProvider) {
            if (((ActionHelpProvider)((Object)action)).printDefaultHelp()) {
                commander.usage(action.command(), builder);
                builder.append("\n");
            }
            ((ActionHelpProvider)((Object)action)).printHelp(builder);
        } else {
            commander.usage(action.command(), builder);
        }
        this.outputStream.print(builder);
    }

    protected void printException(RuntimeException e, JCommander commander, Action action) {
        this.outputStream.println("Error: " + e.getMessage());
        if (this.printStackTrace) {
            e.printStackTrace(new PrintStream(this.outputStream));
        }
        if (this.printHelpOnError) {
            this.printActionHelp(commander, action);
        }
    }

    public void setVersionInfoCallback(Runnable versionInfoCallback) {
        if (versionInfoCallback == null) {
            throw new NullPointerException();
        }
        this.shortVersionInfoCallback = versionInfoCallback;
        this.fullVersionInfoCallback = versionInfoCallback;
    }

    public void setVersionInfoCallback(Runnable shortVersionInfoCallback, Runnable fullVersionInfoCallback) {
        if (shortVersionInfoCallback == null || fullVersionInfoCallback == null) {
            throw new NullPointerException();
        }
        this.shortVersionInfoCallback = shortVersionInfoCallback;
        this.fullVersionInfoCallback = fullVersionInfoCallback;
    }

    public void removeVersionInfoCallback() {
        this.shortVersionInfoCallback = null;
        this.fullVersionInfoCallback = null;
    }

    public static class MainParametersWithVersion
    extends MainParameters {
        @Parameter(names={"-v"}, help=true, description="Output short version information.")
        public Boolean shortVersion;
        @Parameter(names={"--version"}, help=true, description="Output full version information.")
        public Boolean fullVersion;

        public boolean shortVersion() {
            return this.shortVersion != null && this.shortVersion != false;
        }

        public boolean fullVersion() {
            return this.fullVersion != null && this.fullVersion != false;
        }
    }

    public static class MainParameters {
        @Parameter(names={"-h", "--help"}, help=true, description="Displays this help message.")
        public Boolean help;

        public boolean help() {
            return this.help != null && this.help != false;
        }
    }

    public static enum ProcessResult {
        Ok,
        Version,
        Help,
        Error;

    }
}

