/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core;

import com.milaboratory.core.Target;
import com.milaboratory.core.io.sequence.PairedRead;
import com.milaboratory.core.io.sequence.SequenceRead;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import java.io.Serializable;

public enum PairedEndReadsLayout implements Serializable
{
    DirectOnly(new PairedTargetProvider(1, -2), new SingleTargetProvider(false), true),
    ReverseOnly(new PairedTargetProvider(2, -1), new SingleTargetProvider(true), true),
    Opposite(new PairedTargetProvider(1, -2, 2, -1), new SingleTargetProvider(false, true), true),
    Collinear(new PairedTargetProvider(1, 2, -2, -1), new SingleTargetProvider(false, true), false),
    CollinearDirect(new PairedTargetProvider(1, 2), new SingleTargetProvider(false), false),
    Unknown(new PairedTargetProvider(1, -2, 2, -1, 1, 2, -2, -1), new SingleTargetProvider(false, true), false, true);

    private final PairedTargetProvider pairedProvider;
    private final SingleTargetProvider singleProvider;
    private final boolean[] possibleRelativeStrands;

    private PairedEndReadsLayout(PairedTargetProvider pairedProvider, SingleTargetProvider singleProvider, boolean ... possibleRelativeStrands) {
        this.pairedProvider = pairedProvider;
        this.singleProvider = singleProvider;
        this.possibleRelativeStrands = possibleRelativeStrands;
    }

    public Target[] createTargets(PairedRead read) {
        return this.pairedProvider.createTargets(read);
    }

    public Target[] createTargets(SingleRead read) {
        return this.singleProvider.createTargets(read);
    }

    public Target[] createTargets(SequenceRead read) {
        if (read instanceof PairedRead) {
            return this.pairedProvider.createTargets((PairedRead)read);
        }
        if (read instanceof SingleRead) {
            return this.singleProvider.createTargets((SingleRead)read);
        }
        throw new IllegalArgumentException("Unknown read type.");
    }

    public boolean[] getPossibleRelativeStrands() {
        return this.possibleRelativeStrands;
    }

    private static final class PairedTargetProvider {
        final byte[][] ids;

        PairedTargetProvider(int ... ids) {
            assert (ids.length % 2 == 0);
            this.ids = new byte[ids.length / 2][];
            for (int i = 0; i < ids.length / 2; ++i) {
                this.ids[i] = new byte[]{(byte)ids[i * 2], (byte)ids[i * 2 + 1]};
            }
        }

        Target[] createTargets(PairedRead read) {
            Target[] result = new Target[this.ids.length];
            for (int i = 0; i < this.ids.length; ++i) {
                byte[] ii = this.ids[i];
                result[i] = new Target(this.dataFromId(read, ii[0]), this.dataFromId(read, ii[1]), ii);
            }
            return result;
        }

        NSequenceWithQuality dataFromId(PairedRead read, byte id) {
            switch (id) {
                case 1: {
                    return read.getR1().getData();
                }
                case 2: {
                    return read.getR2().getData();
                }
                case -1: {
                    return read.getR1().getData().getReverseComplement();
                }
                case -2: {
                    return read.getR2().getData().getReverseComplement();
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static final class SingleTargetProvider {
        final boolean[] states;

        public SingleTargetProvider(boolean ... states) {
            this.states = states;
        }

        Target[] createTargets(SingleRead read) {
            Target[] ts = new Target[this.states.length];
            int i = 0;
            for (boolean state : this.states) {
                ts[i++] = new Target(state ? read.getData().getReverseComplement() : read.getData(), state);
            }
            return ts;
        }
    }
}

