/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.milaboratory.core.io.binary.RangeSerializer;
import com.milaboratory.primitivio.annotations.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
@Serializable(by=RangeSerializer.class)
public final class Range
implements java.io.Serializable,
Comparable<Range> {
    static final long serialVersionUID = 1L;
    private final int lower;
    private final int upper;
    private final boolean reversed;
    public static final Comparator<Range> COMPARATOR_BY_FROM = new Comparator<Range>(){

        @Override
        public int compare(Range o1, Range o2) {
            return Integer.compare(o1.getFrom(), o2.getTo());
        }
    };

    public Range(int lower, int upper, boolean reversed) {
        if (lower > upper) {
            throw new IllegalArgumentException();
        }
        this.lower = lower;
        this.upper = upper;
        this.reversed = reversed;
    }

    @JsonCreator
    public Range(@JsonProperty(value="from") int from, @JsonProperty(value="to") int to) {
        this.reversed = from > to;
        if (this.reversed) {
            this.upper = from;
            this.lower = to;
        } else {
            this.upper = to;
            this.lower = from;
        }
    }

    public Range expand(int offset) {
        return this.expand(offset, offset);
    }

    public Range expand(int leftOffset, int rightOffset) {
        return new Range(this.lower - leftOffset, this.upper + rightOffset, this.reversed);
    }

    public boolean isEmpty() {
        return this.upper == this.lower;
    }

    public int length() {
        return this.upper - this.lower;
    }

    public boolean isReverse() {
        return this.reversed;
    }

    public int sig() {
        return this.reversed ? -1 : 1;
    }

    public Range reverse() {
        return new Range(this.lower, this.upper, !this.reversed);
    }

    public boolean hasSameDirection(Range other) {
        return this.isEmpty() || other.isEmpty() || this.isReverse() == other.isReverse();
    }

    @JsonProperty(value="from")
    public int getFrom() {
        return this.reversed ? this.upper : this.lower;
    }

    @JsonProperty(value="to")
    public int getTo() {
        return this.reversed ? this.lower : this.upper;
    }

    public int getUpper() {
        return this.upper;
    }

    public int getLower() {
        return this.lower;
    }

    public Range inverse() {
        return new Range(this.lower, this.upper, !this.reversed);
    }

    public boolean contains(int position) {
        return position >= this.lower && position < this.upper;
    }

    public boolean containsBoundary(int position) {
        return position >= this.lower && position <= this.upper;
    }

    public boolean contains(Range other) {
        return this.lower <= other.lower && this.upper >= other.upper;
    }

    public boolean intersectsWith(Range other) {
        return !other.isEmpty() && !this.isEmpty() && (this.contains(other.lower) || other.contains(this.lower) || other.upper > this.upper && other.lower < this.lower);
    }

    public boolean intersectsWithOrTouches(Range other) {
        return this.contains(other.lower) || this.contains(other.upper - 1) || other.upper > this.upper && other.lower < this.lower || other.lower == this.upper || other.upper == this.lower;
    }

    public Range intersection(Range other) {
        if (!this.intersectsWith(other)) {
            return null;
        }
        return new Range(Math.max(this.lower, other.lower), Math.min(this.upper, other.upper), this.reversed && other.reversed);
    }

    public Range intersectionWithTouch(Range other) {
        if (!this.intersectsWithOrTouches(other)) {
            return null;
        }
        return new Range(Math.max(this.lower, other.lower), Math.min(this.upper, other.upper), this.reversed && other.reversed);
    }

    public Range tryMerge(Range other) {
        if (!this.intersectsWithOrTouches(other)) {
            return null;
        }
        return new Range(Math.min(this.lower, other.lower), Math.max(this.upper, other.upper), this.reversed && other.reversed);
    }

    public Range move(int offset) {
        if (offset == 0) {
            return this;
        }
        return new Range(this.lower + offset, this.upper + offset, this.reversed);
    }

    public int convertPointToRelativePosition(int absolutePosition) {
        if (absolutePosition < this.lower || absolutePosition >= this.upper) {
            throw new IllegalArgumentException("Position outside this range (" + absolutePosition + ").");
        }
        if (this.reversed) {
            return this.upper - 1 - absolutePosition;
        }
        return absolutePosition - this.lower;
    }

    public int convertBoundaryToRelativePosition(int absolutePosition) {
        if (absolutePosition < this.lower || absolutePosition > this.upper) {
            throw new IllegalArgumentException("Position outside this range (" + absolutePosition + ") this=" + this + ".");
        }
        if (this.reversed) {
            return this.upper - absolutePosition;
        }
        return absolutePosition - this.lower;
    }

    public List<Range> without(Range range) {
        if (!this.intersectsWith(range)) {
            return Collections.singletonList(this);
        }
        if (this.upper <= range.upper) {
            return range.lower <= this.lower ? Collections.EMPTY_LIST : Collections.singletonList(new Range(this.lower, range.lower, this.reversed));
        }
        if (range.lower <= this.lower) {
            return Collections.singletonList(new Range(range.upper, this.upper, this.reversed));
        }
        return Arrays.asList(new Range(this.lower, range.lower, this.reversed), new Range(range.upper, this.upper, this.reversed));
    }

    public Range getRelativeRangeOf(Range absoluteRange) {
        int from = this.convertBoundaryToRelativePosition(absoluteRange.getFrom());
        int to = this.convertBoundaryToRelativePosition(absoluteRange.getTo());
        if (from == -1 || to == -1) {
            return null;
        }
        return new Range(from, to);
    }

    public int[] convertBoundariesToRelativePosition(int ... absolutePositions) {
        int[] result = new int[absolutePositions.length];
        for (int i = 0; i < absolutePositions.length; ++i) {
            result[i] = this.convertBoundaryToRelativePosition(absolutePositions[i]);
        }
        return result;
    }

    public int[] convertPointsToRelativePosition(int ... absolutePositions) {
        int[] result = new int[absolutePositions.length];
        for (int i = 0; i < absolutePositions.length; ++i) {
            result[i] = this.convertPointToRelativePosition(absolutePositions[i]);
        }
        return result;
    }

    public int convertPointToAbsolutePosition(int relativePosition) {
        if (relativePosition < 0 || relativePosition >= this.length()) {
            throw new IllegalArgumentException("Relative position outside this range (" + relativePosition + ").");
        }
        if (this.reversed) {
            return this.upper - 1 - relativePosition;
        }
        return relativePosition + this.lower;
    }

    public int convertBoundaryToAbsolutePosition(int relativePosition) {
        if (relativePosition < 0 || relativePosition > this.length()) {
            throw new IllegalArgumentException("Relative position outside this range (" + relativePosition + ").");
        }
        if (this.reversed) {
            return this.upper - relativePosition;
        }
        return relativePosition + this.lower;
    }

    public Range getAbsoluteRangeFor(Range relativeRange) {
        int from = this.convertBoundaryToAbsolutePosition(relativeRange.getFrom());
        int to = this.convertBoundaryToAbsolutePosition(relativeRange.getTo());
        return new Range(from, to);
    }

    @Override
    public int compareTo(Range o) {
        int cmp = Integer.compare(this.getLower(), o.getLower());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.getUpper(), o.getUpper());
        if (cmp != 0) {
            return cmp;
        }
        return Boolean.compare(this.isReverse(), o.isReverse());
    }

    public String toString() {
        return "(" + this.lower + (this.reversed ? "<-" : "->") + this.upper + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.lower == range.lower && this.reversed == range.reversed && this.upper == range.upper;
    }

    public int hashCode() {
        int result = this.lower;
        result = 31 * result + this.upper;
        result = 31 * result + (this.reversed ? 1 : 0);
        return result;
    }
}

