/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core;

import com.milaboratory.core.sequence.NSequenceWithQuality;

public final class Target {
    private static final byte[] SINGLE_FORWARD = new byte[]{1};
    private static final byte[] SINGLE_REVERSED = new byte[]{-1};
    public final NSequenceWithQuality[] targets;
    private final byte[] readIds;

    Target(NSequenceWithQuality target, boolean reversed) {
        this.targets = new NSequenceWithQuality[]{target};
        this.readIds = reversed ? SINGLE_REVERSED : SINGLE_FORWARD;
    }

    Target(NSequenceWithQuality target1, NSequenceWithQuality target2, byte[] readIds) {
        this.targets = new NSequenceWithQuality[]{target1, target2};
        this.readIds = readIds;
    }

    public int numberOfParts() {
        return this.readIds.length;
    }

    public int getReadIdOfTarget(int targetId) {
        return Math.abs(this.readIds[targetId]) - 1;
    }

    public boolean getRCStateOfTarget(int targetId) {
        return this.readIds[targetId] < 0;
    }

    public byte getFullSourceId(int targetId) {
        return this.readIds[targetId];
    }
}

