/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.milaboratory.core.alignment.AlignmentScoring;
import com.milaboratory.core.alignment.SubstitutionMatrix;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import java.util.Arrays;

@JsonIgnoreProperties(value={"minimalMatchScore", "maximalMatchScore", "minimalMismatchScore", "maximalMismatchScore"})
public class AbstractAlignmentScoring<S extends Sequence<S>>
implements AlignmentScoring<S> {
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    protected final Alphabet<S> alphabet;
    protected final SubstitutionMatrix subsMatrix;
    @JsonIgnore
    protected final int[] subsMatrixActual;
    @JsonIgnore
    final boolean uniformBasicMatch;
    private final transient int minimalMatchScore;
    private final transient int maximalMatchScore;
    private final transient int minimalMismatchScore;
    private final transient int maximalMismatchScore;

    protected AbstractAlignmentScoring(Alphabet<S> alphabet, SubstitutionMatrix subsMatrix) {
        int minimalMismatchScore;
        int minimalMatchScore;
        this.alphabet = alphabet;
        this.subsMatrix = subsMatrix;
        this.subsMatrixActual = subsMatrix.createSubstitutionMatrix(alphabet);
        int val = this.getScore((byte)0, (byte)0);
        boolean e = true;
        for (byte i = (byte)(alphabet.basicSize() - 1); i > 0; i = (byte)(i - 1)) {
            if (this.getScore(i, i) == val) continue;
            e = false;
            break;
        }
        this.uniformBasicMatch = e;
        int maximalMatchScore = minimalMatchScore = this.getScore((byte)0, (byte)0);
        int maximalMismatchScore = minimalMismatchScore = this.getScore((byte)0, (byte)1);
        for (byte c0 = 0; c0 < alphabet.size(); c0 = (byte)(c0 + 1)) {
            for (byte c1 = 0; c1 < alphabet.size(); c1 = (byte)(c1 + 1)) {
                int score = this.getScore(c0, c1);
                if (c0 == c1) {
                    minimalMatchScore = Math.min(minimalMatchScore, score);
                    maximalMatchScore = Math.max(maximalMatchScore, score);
                    continue;
                }
                minimalMismatchScore = Math.min(minimalMismatchScore, score);
                maximalMismatchScore = Math.max(maximalMismatchScore, score);
            }
        }
        this.minimalMatchScore = minimalMatchScore;
        this.maximalMatchScore = maximalMatchScore;
        this.minimalMismatchScore = minimalMismatchScore;
        this.maximalMismatchScore = maximalMismatchScore;
    }

    @Override
    public int getScore(byte from, byte to) {
        return this.subsMatrixActual[from * this.alphabet.size() + to];
    }

    @Override
    public Alphabet<S> getAlphabet() {
        return this.alphabet;
    }

    public boolean uniformBasicMatchScore() {
        return this.uniformBasicMatch;
    }

    @Override
    public int getMinimalMatchScore() {
        return this.minimalMatchScore;
    }

    @Override
    public int getMaximalMatchScore() {
        return this.maximalMatchScore;
    }

    @Override
    public int getMinimalMismatchScore() {
        return this.minimalMismatchScore;
    }

    @Override
    public int getMaximalMismatchScore() {
        return this.maximalMismatchScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAlignmentScoring that = (AbstractAlignmentScoring)o;
        if (this.getAlphabet() != ((AbstractAlignmentScoring)o).getAlphabet()) {
            return false;
        }
        return Arrays.equals(this.subsMatrixActual, that.subsMatrixActual);
    }

    public int hashCode() {
        return Arrays.hashCode(this.subsMatrixActual) + 31 * this.getAlphabet().hashCode();
    }
}

