/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.milaboratory.core.alignment.AbstractAlignmentScoring;
import com.milaboratory.core.alignment.BLASTMatrix;
import com.milaboratory.core.alignment.ScoringUtils;
import com.milaboratory.core.alignment.SubstitutionMatrix;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.AminoAcidSequence;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class AffineGapAlignmentScoring<S extends Sequence<S>>
extends AbstractAlignmentScoring<S>
implements Serializable {
    private final int gapOpenPenalty;
    private final int gapExtensionPenalty;
    public static final AffineGapAlignmentScoring<NucleotideSequence> IGBLAST_NUCLEOTIDE_SCORING = new AffineGapAlignmentScoring<NucleotideSequence>(NucleotideSequence.ALPHABET, 10, -30, -40, -10);
    public static final int IGBLAST_NUCLEOTIDE_SCORING_THRESHOLD = 150;

    private AffineGapAlignmentScoring() {
        super(NucleotideSequence.ALPHABET, new SubstitutionMatrix(Integer.MIN_VALUE, Integer.MIN_VALUE));
        this.gapExtensionPenalty = Integer.MIN_VALUE;
        this.gapOpenPenalty = Integer.MIN_VALUE;
    }

    @JsonCreator
    public AffineGapAlignmentScoring(@JsonProperty(value="alphabet") Alphabet<S> alphabet, @JsonProperty(value="subsMatrix") SubstitutionMatrix subsMatrix, @JsonProperty(value="gapOpenPenalty") int gapOpenPenalty, @JsonProperty(value="gapExtensionPenalty") int gapExtensionPenalty) {
        super(alphabet, subsMatrix);
        if (gapOpenPenalty >= 0 || gapExtensionPenalty >= 0) {
            throw new IllegalArgumentException();
        }
        this.gapOpenPenalty = gapOpenPenalty;
        this.gapExtensionPenalty = gapExtensionPenalty;
    }

    public AffineGapAlignmentScoring(Alphabet<S> alphabet, int[] subsMatrix, int gapOpenPenalty, int gapExtensionPenalty) {
        super(alphabet, new SubstitutionMatrix(subsMatrix));
        if (gapOpenPenalty >= 0 || gapExtensionPenalty >= 0) {
            throw new IllegalArgumentException();
        }
        this.gapOpenPenalty = gapOpenPenalty;
        this.gapExtensionPenalty = gapExtensionPenalty;
    }

    public AffineGapAlignmentScoring(Alphabet<S> alphabet, int match, int mismatch, int gapOpen, int gapExtension) {
        this(alphabet, new SubstitutionMatrix(match, mismatch), gapOpen, gapExtension);
    }

    public int getAffineGapPenalty(int l) {
        return l == 0 ? 0 : this.gapOpenPenalty + (l - 1) * this.gapExtensionPenalty;
    }

    public int getGapOpenPenalty() {
        return this.gapOpenPenalty;
    }

    public int getGapExtensionPenalty() {
        return this.gapExtensionPenalty;
    }

    public AffineGapAlignmentScoring<S> setMatchScore(int matchScore) {
        return new AffineGapAlignmentScoring<S>(this.alphabet, ScoringUtils.setMatchScore(this.alphabet, this.subsMatrixActual, matchScore), this.gapOpenPenalty, this.gapExtensionPenalty);
    }

    public AffineGapAlignmentScoring<S> setMismatchScore(int mismatchScore) {
        return new AffineGapAlignmentScoring<S>(this.alphabet, ScoringUtils.setMismatchScore(this.alphabet, this.subsMatrixActual, mismatchScore), this.gapOpenPenalty, this.gapExtensionPenalty);
    }

    public AffineGapAlignmentScoring<S> setGapOpenScore(int gapOpenPenalty) {
        return new AffineGapAlignmentScoring<S>(this.alphabet, (int[])this.subsMatrixActual.clone(), gapOpenPenalty, this.gapExtensionPenalty);
    }

    public AffineGapAlignmentScoring<S> setGapExtensionScore(int gapExtensionPenalty) {
        return new AffineGapAlignmentScoring<S>(this.alphabet, (int[])this.subsMatrixActual.clone(), this.gapOpenPenalty, gapExtensionPenalty);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AffineGapAlignmentScoring that = (AffineGapAlignmentScoring)o;
        if (this.gapExtensionPenalty != that.gapExtensionPenalty) {
            return false;
        }
        return this.gapOpenPenalty == that.gapOpenPenalty;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.gapOpenPenalty;
        result = 31 * result + this.gapExtensionPenalty;
        return result;
    }

    public static AffineGapAlignmentScoring<NucleotideSequence> getNucleotideBLASTScoring() {
        return AffineGapAlignmentScoring.getNucleotideBLASTScoring(-10, -1);
    }

    public static AffineGapAlignmentScoring<NucleotideSequence> getNucleotideBLASTScoring(int gapOpenPenalty, int gapExtensionPenalty) {
        return new AffineGapAlignmentScoring<NucleotideSequence>(NucleotideSequence.ALPHABET, 5, -4, gapOpenPenalty, gapExtensionPenalty);
    }

    public static AffineGapAlignmentScoring<AminoAcidSequence> getAminoAcidBLASTScoring(BLASTMatrix matrix) {
        return AffineGapAlignmentScoring.getAminoAcidBLASTScoring(matrix, -10, -1);
    }

    public static AffineGapAlignmentScoring<AminoAcidSequence> getAminoAcidBLASTScoring(BLASTMatrix matrix, int gapOpenPenalty, int gapExtensionPenalty) {
        return new AffineGapAlignmentScoring<AminoAcidSequence>(AminoAcidSequence.ALPHABET, matrix.getMatrix(), gapOpenPenalty, gapExtensionPenalty);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerializationObject(this.alphabet, this.subsMatrix, this.gapOpenPenalty, this.gapExtensionPenalty);
    }

    protected static class SerializationObject
    implements Serializable {
        final Alphabet alphabet;
        final SubstitutionMatrix matrix;
        private final int gapOpenPenalty;
        private final int gapExtensionPenalty;

        public SerializationObject() {
            this(null, null, 0, 0);
        }

        public SerializationObject(Alphabet alphabet, SubstitutionMatrix matrix, int gapOpenPenalty, int gapExtensionPenalty) {
            this.alphabet = alphabet;
            this.matrix = matrix;
            this.gapOpenPenalty = gapOpenPenalty;
            this.gapExtensionPenalty = gapExtensionPenalty;
        }

        private Object readResolve() throws ObjectStreamException {
            return new AffineGapAlignmentScoring(this.alphabet, this.matrix, this.gapOpenPenalty, this.gapExtensionPenalty);
        }
    }
}

