/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.AlignmentScoring;
import com.milaboratory.core.alignment.LinearGapAlignmentScoring;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.sequence.Sequence;

public final class Aligner {
    private Aligner() {
    }

    public static <S extends Sequence<S>> int alignOnlySubstitutions0(S seq1, S seq2, int seq1From, int seq1Length, int seq2From, int seq2Length, AlignmentScoring<S> scoring, MutationsBuilder<S> builder) {
        if (seq1Length != seq2Length) {
            throw new IllegalArgumentException("Size of 'seq1' and 'seq2' sequences must be the same.");
        }
        int score = 0;
        for (int i = 0; i < seq1Length; ++i) {
            byte c2;
            byte c1 = seq1.codeAt(seq1From + i);
            if (c1 != (c2 = seq2.codeAt(seq2From + i))) {
                builder.appendSubstitution(seq1From + i, c1, c2);
            }
            score += scoring.getScore(c1, c2);
        }
        return score;
    }

    public static <S extends Sequence<S>> Alignment<S> alignOnlySubstitutions(S seq1, S seq2, int seq1From, int seq1Length, int seq2From, int seq2Length, AlignmentScoring<S> scoring) {
        MutationsBuilder<S> builder = new MutationsBuilder<S>(seq1.getAlphabet());
        int score = Aligner.alignOnlySubstitutions0(seq1, seq2, seq1From, seq1Length, seq2From, seq2Length, scoring, builder);
        return new Alignment<S>(seq1, builder.createAndDestroy(), new Range(seq1From, seq1From + seq1Length), new Range(seq2From, seq2From + seq2Length), score);
    }

    public static <S extends Sequence<S>> Alignment<S> alignOnlySubstitutions(S from, S to) {
        if (from.getAlphabet() != to.getAlphabet()) {
            throw new IllegalArgumentException();
        }
        if (from.size() != to.size()) {
            throw new IllegalArgumentException("Size of 'from' and 'to' sequences must be the same.");
        }
        MutationsBuilder<S> builder = new MutationsBuilder<S>(from.getAlphabet());
        int score = 0;
        for (int i = 0; i < from.size(); ++i) {
            if (from.codeAt(i) != to.codeAt(i)) {
                builder.appendSubstitution(i, from.codeAt(i), to.codeAt(i));
                --score;
                continue;
            }
            ++score;
        }
        Range range = new Range(0, from.size());
        return new Alignment<S>(from, builder.createAndDestroy(), range, range, score);
    }

    public static <S extends Sequence<S>> Alignment<S> alignGlobal(AlignmentScoring<S> alignmentScoring, S seq1, S seq2, int offset1, int length1, int offset2, int length2) {
        Range seq1Range = new Range(offset1, offset1 + length1);
        Range seq2Range = new Range(offset2, offset2 + length2);
        Alignment<Sequence> al = Aligner.alignGlobal(alignmentScoring, (Sequence)seq1.getRange(seq1Range), (Sequence)seq2.getRange(seq2Range));
        return new Alignment<Sequence>(seq1, al.getAbsoluteMutations().move(offset1), seq1Range, seq2Range, al.getScore());
    }

    public static <S extends Sequence<S>> Alignment<S> alignGlobal(AlignmentScoring<S> alignmentScoring, S seq1, S seq2) {
        if (alignmentScoring instanceof AffineGapAlignmentScoring) {
            return Aligner.alignGlobalAffine((AffineGapAlignmentScoring)alignmentScoring, seq1, seq2);
        }
        if (alignmentScoring instanceof LinearGapAlignmentScoring) {
            return Aligner.alignGlobalLinear((LinearGapAlignmentScoring)alignmentScoring, seq1, seq2);
        }
        throw new RuntimeException("Unknown scoring type.");
    }

    public static <S extends Sequence<S>> Alignment<S> alignGlobalLinear(LinearGapAlignmentScoring scoring, S seq1, S seq2) {
        int i2;
        int i1;
        if (seq1.getAlphabet() != seq2.getAlphabet() || seq1.getAlphabet() != scoring.getAlphabet()) {
            throw new IllegalArgumentException("Different alphabets.");
        }
        int size1 = seq1.size() + 1;
        int size2 = seq2.size() + 1;
        int[] matrix = new int[size1 * (seq2.size() + 1)];
        for (int i = 0; i < size2; ++i) {
            matrix[i] = scoring.getGapPenalty() * i;
        }
        for (int j = 1; j < size1; ++j) {
            matrix[size2 * j] = scoring.getGapPenalty() * j;
        }
        for (i1 = 0; i1 < seq1.size(); ++i1) {
            for (i2 = 0; i2 < seq2.size(); ++i2) {
                int match = matrix[i1 * size2 + i2] + scoring.getScore(seq1.codeAt(i1), seq2.codeAt(i2));
                int delete = matrix[i1 * size2 + i2 + 1] + scoring.getGapPenalty();
                int insert = matrix[(i1 + 1) * size2 + i2] + scoring.getGapPenalty();
                matrix[(i1 + 1) * size2 + i2 + 1] = Math.max(match, Math.max(delete, insert));
            }
        }
        MutationsBuilder<byte> builder = new MutationsBuilder<byte>(seq1.getAlphabet(), true);
        i1 = seq1.size() - 1;
        i2 = seq2.size() - 1;
        int score = matrix[(i1 + 1) * size2 + i2 + 1];
        while (i1 >= 0 || i2 >= 0) {
            if (i1 >= 0 && i2 >= 0 && matrix[(i1 + 1) * size2 + i2 + 1] == matrix[i1 * size2 + i2] + scoring.getScore(seq1.codeAt(i1), seq2.codeAt(i2))) {
                if (seq1.codeAt(i1) != seq2.codeAt(i2)) {
                    builder.appendSubstitution(i1, seq1.codeAt(i1), seq2.codeAt(i2));
                }
                --i1;
                --i2;
                continue;
            }
            if (i1 >= 0 && matrix[(i1 + 1) * size2 + i2 + 1] == matrix[i1 * size2 + i2 + 1] + scoring.getGapPenalty()) {
                builder.appendDeletion(i1, seq1.codeAt(i1));
                --i1;
                continue;
            }
            if (i2 >= 0 && matrix[(i1 + 1) * size2 + i2 + 1] == matrix[(i1 + 1) * size2 + i2] + scoring.getGapPenalty()) {
                builder.appendInsertion(i1 + 1, seq2.codeAt(i2));
                --i2;
                continue;
            }
            throw new RuntimeException();
        }
        return new Alignment<S>(seq1, builder.createAndDestroy(), new Range(0, seq1.size()), new Range(0, seq2.size()), score);
    }

    public static <S extends Sequence<S>> Alignment<S> alignGlobalAffine(AffineGapAlignmentScoring<S> scoring, S seq1, S seq2) {
        int v;
        int i;
        if (seq1.getAlphabet() != seq2.getAlphabet() || seq1.getAlphabet() != scoring.getAlphabet()) {
            throw new IllegalArgumentException("Different alphabets.");
        }
        int size1 = seq1.size() + 1;
        int size2 = seq2.size() + 1;
        int[] alignXToGapAfterY = new int[size1 * size2];
        int[] alignYTOGapAfterX = new int[size1 * size2];
        int[] matrix = new int[size1 * size2];
        for (int j = 0; j < size2; ++j) {
            matrix[j] = scoring.getAffineGapPenalty(j);
        }
        for (i = 0; i < size1; ++i) {
            matrix[i * size2] = scoring.getAffineGapPenalty(i);
        }
        matrix[0] = 0;
        for (i = 0; i < size2; ++i) {
            alignXToGapAfterY[i] = -10000;
        }
        for (i = 0; i < size1; ++i) {
            alignYTOGapAfterX[i * size2] = -10000;
        }
        for (i = 1; i < size1; ++i) {
            for (int j = 1; j < size2; ++j) {
                int match = matrix[(i - 1) * size2 + j - 1] + scoring.getScore(seq1.codeAt(i - 1), seq2.codeAt(j - 1));
                alignXToGapAfterY[i * size2 + j] = Math.max(matrix[(i - 1) * size2 + j] + scoring.getGapOpenPenalty(), alignXToGapAfterY[(i - 1) * size2 + j] + scoring.getGapExtensionPenalty());
                alignYTOGapAfterX[i * size2 + j] = Math.max(matrix[i * size2 + j - 1] + scoring.getGapOpenPenalty(), alignYTOGapAfterX[i * size2 + j - 1] + scoring.getGapExtensionPenalty());
                matrix[i * size2 + j] = Math.max(match, Math.max(alignXToGapAfterY[i * size2 + j], alignYTOGapAfterX[i * size2 + j]));
            }
        }
        int i1 = seq1.size() - 1;
        int i2 = seq2.size() - 1;
        int maxV = v = matrix[(i1 + 1) * size2 + i2 + 1];
        MutationsBuilder<byte> builder = new MutationsBuilder<byte>(seq1.getAlphabet(), true);
        while (i1 >= 0 || i2 >= 0) {
            if (i1 >= 0 && v == alignXToGapAfterY[(i1 + 1) * size2 + i2 + 1]) {
                v = v == alignXToGapAfterY[i1 * size2 + i2 + 1] + scoring.getGapExtensionPenalty() ? alignXToGapAfterY[i1 * size2 + i2 + 1] : matrix[i1 * size2 + i2 + 1];
                builder.appendDeletion(i1, seq1.codeAt(i1));
                --i1;
                continue;
            }
            if (i2 >= 0 && v == alignYTOGapAfterX[(i1 + 1) * size2 + i2 + 1]) {
                v = v == alignYTOGapAfterX[(i1 + 1) * size2 + i2] + scoring.getGapExtensionPenalty() ? alignYTOGapAfterX[(i1 + 1) * size2 + i2] : matrix[(i1 + 1) * size2 + i2];
                builder.appendInsertion(i1 + 1, seq2.codeAt(i2));
                --i2;
                continue;
            }
            if (i1 >= 0 && i2 >= 0 && v == matrix[i1 * size2 + i2] + scoring.getScore(seq1.codeAt(i1), seq2.codeAt(i2))) {
                v = matrix[i1 * size2 + i2];
                if (seq1.codeAt(i1) != seq2.codeAt(i2)) {
                    builder.appendSubstitution(i1, seq1.codeAt(i1), seq2.codeAt(i2));
                }
                --i1;
                --i2;
                continue;
            }
            if (i1 == -1) {
                builder.appendInsertion(i1 + 1, seq2.codeAt(i2));
                --i2;
                continue;
            }
            if (i2 == -1) {
                builder.appendDeletion(i1, seq1.codeAt(i1));
                --i1;
                continue;
            }
            throw new RuntimeException();
        }
        return new Alignment<S>(seq1, builder.createAndDestroy(), new Range(0, seq1.size()), new Range(0, seq2.size()), maxV);
    }

    public static <S extends Sequence<S>> Alignment<S> alignLocal(AlignmentScoring<S> alignmentScoring, S seq1, S seq2) {
        if (alignmentScoring instanceof AffineGapAlignmentScoring) {
            return Aligner.alignLocalAffine((AffineGapAlignmentScoring)alignmentScoring, seq1, seq2);
        }
        if (alignmentScoring instanceof LinearGapAlignmentScoring) {
            return Aligner.alignLocalLinear((LinearGapAlignmentScoring)alignmentScoring, seq1, seq2);
        }
        throw new RuntimeException("Unknown scoring type.");
    }

    public static <S extends Sequence<S>> Alignment<S> alignLocalLinear(LinearGapAlignmentScoring<S> scoring, S seq1, S seq2) {
        int i2;
        int i1;
        if (seq1.getAlphabet() != seq2.getAlphabet() || seq1.getAlphabet() != scoring.getAlphabet()) {
            throw new IllegalArgumentException("Different alphabets.");
        }
        int size1 = seq1.size() + 1;
        int size2 = seq2.size() + 1;
        int[] matrix = new int[size1 * (seq2.size() + 1)];
        int max = -1;
        int i1Start = 0;
        int i2Start = 0;
        for (i1 = 0; i1 < seq1.size(); ++i1) {
            for (i2 = 0; i2 < seq2.size(); ++i2) {
                int match = matrix[i1 * size2 + i2] + scoring.getScore(seq1.codeAt(i1), seq2.codeAt(i2));
                int delete = matrix[i1 * size2 + i2 + 1] + scoring.getGapPenalty();
                int insert = matrix[(i1 + 1) * size2 + i2] + scoring.getGapPenalty();
                matrix[(i1 + 1) * size2 + i2 + 1] = Math.max(0, Math.max(match, Math.max(delete, insert)));
                if (matrix[(i1 + 1) * size2 + i2 + 1] <= max || matrix[(i1 + 1) * size2 + i2 + 1] <= 0) continue;
                i1Start = i1 + 1;
                i2Start = i2 + 1;
                max = matrix[(i1 + 1) * size2 + i2 + 1];
            }
        }
        if (max == -1) {
            return null;
        }
        MutationsBuilder<byte> builder = new MutationsBuilder<byte>(seq1.getAlphabet(), true);
        i1 = i1Start - 1;
        i2 = i2Start - 1;
        while (i1 >= 0 || i2 >= 0) {
            if (i1 >= 0 && i2 >= 0 && matrix[(i1 + 1) * size2 + i2 + 1] == matrix[i1 * size2 + i2] + scoring.getScore(seq1.codeAt(i1), seq2.codeAt(i2))) {
                if (seq1.codeAt(i1) != seq2.codeAt(i2)) {
                    builder.appendSubstitution(i1, seq1.codeAt(i1), seq2.codeAt(i2));
                }
                if (matrix[i1 * size2 + i2] == 0) break;
                --i1;
                --i2;
                continue;
            }
            if (i1 >= 0 && matrix[(i1 + 1) * size2 + i2 + 1] == matrix[i1 * size2 + i2 + 1] + scoring.getGapPenalty()) {
                builder.appendDeletion(i1, seq1.codeAt(i1));
                if (matrix[i1 * size2 + i2 + 1] == 0) break;
                --i1;
                continue;
            }
            if (i2 >= 0 && matrix[(i1 + 1) * size2 + i2 + 1] == matrix[(i1 + 1) * size2 + i2] + scoring.getGapPenalty()) {
                builder.appendInsertion(i1 + 1, seq2.codeAt(i2));
                if (matrix[(i1 + 1) * size2 + i2] == 0) break;
                --i2;
                continue;
            }
            throw new RuntimeException();
        }
        int seq1Start = i1;
        int seq2Start = i2;
        return new Alignment<S>(seq1, builder.createAndDestroy(), new Range(seq1Start, i1Start), new Range(seq2Start, i2Start), max);
    }

    public static <S extends Sequence<S>> Alignment<S> alignLocalAffine(AffineGapAlignmentScoring<S> scoring, S seq1, S seq2) {
        int i;
        if (seq1.getAlphabet() != seq2.getAlphabet() || seq1.getAlphabet() != scoring.getAlphabet()) {
            throw new IllegalArgumentException("Different alphabets.");
        }
        int size1 = seq1.size() + 1;
        int size2 = seq2.size() + 1;
        int[] alignXToGapAfterY = new int[size1 * size2];
        int[] alignYTOGapAfterX = new int[size1 * size2];
        int[] matrix = new int[size1 * size2];
        for (i = 0; i < size2; ++i) {
            alignXToGapAfterY[i] = -10000;
        }
        for (i = 0; i < size1; ++i) {
            alignYTOGapAfterX[i * size2] = -10000;
        }
        int max = -1;
        int i1Start = 0;
        int i2Start = 0;
        for (int i2 = 1; i2 < size1; ++i2) {
            for (int j = 1; j < size2; ++j) {
                int match = matrix[(i2 - 1) * size2 + j - 1] + scoring.getScore(seq1.codeAt(i2 - 1), seq2.codeAt(j - 1));
                alignXToGapAfterY[i2 * size2 + j] = Math.max(matrix[(i2 - 1) * size2 + j] + scoring.getGapOpenPenalty(), alignXToGapAfterY[(i2 - 1) * size2 + j] + scoring.getGapExtensionPenalty());
                alignYTOGapAfterX[i2 * size2 + j] = Math.max(matrix[i2 * size2 + j - 1] + scoring.getGapOpenPenalty(), alignYTOGapAfterX[i2 * size2 + j - 1] + scoring.getGapExtensionPenalty());
                matrix[i2 * size2 + j] = Math.max(0, Math.max(match, Math.max(alignXToGapAfterY[i2 * size2 + j], alignYTOGapAfterX[i2 * size2 + j])));
                if (matrix[i2 * size2 + j] <= max || matrix[i2 * size2 + j] <= 0) continue;
                i1Start = i2;
                i2Start = j;
                max = matrix[i2 * size2 + j];
            }
        }
        if (max == -1) {
            return null;
        }
        MutationsBuilder<byte> builder = new MutationsBuilder<byte>(seq1.getAlphabet(), true);
        int i1 = i1Start - 1;
        int i2 = i2Start - 1;
        int v = matrix[(i1 + 1) * size2 + i2 + 1];
        while (i1 >= 0 && i2 >= 0) {
            if (i1 >= 0 && v == alignXToGapAfterY[(i1 + 1) * size2 + i2 + 1]) {
                if ((v = v == alignXToGapAfterY[i1 * size2 + i2 + 1] + scoring.getGapExtensionPenalty() ? alignXToGapAfterY[i1 * size2 + i2 + 1] : matrix[i1 * size2 + i2 + 1]) == 0) break;
                builder.appendDeletion(i1, seq1.codeAt(i1));
                --i1;
                continue;
            }
            if (i2 >= 0 && v == alignYTOGapAfterX[(i1 + 1) * size2 + i2 + 1]) {
                if ((v = v == alignYTOGapAfterX[(i1 + 1) * size2 + i2] + scoring.getGapExtensionPenalty() ? alignYTOGapAfterX[(i1 + 1) * size2 + i2] : matrix[(i1 + 1) * size2 + i2]) == 0) break;
                builder.appendInsertion(i1 + 1, seq2.codeAt(i2));
                --i2;
                continue;
            }
            if (i1 >= 0 && i2 >= 0 && v == matrix[i1 * size2 + i2] + scoring.getScore(seq1.codeAt(i1), seq2.codeAt(i2))) {
                v = matrix[i1 * size2 + i2];
                if (seq1.codeAt(i1) != seq2.codeAt(i2)) {
                    builder.appendSubstitution(i1, seq1.codeAt(i1), seq2.codeAt(i2));
                }
                if (v == 0) break;
                --i1;
                --i2;
                continue;
            }
            throw new RuntimeException();
        }
        int seq1Start = i1;
        int seq2Start = i2;
        return new Alignment<S>(seq1, builder.createAndDestroy(), new Range(seq1Start, i1Start), new Range(seq2Start, i2Start), max);
    }
}

