/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AffineGapAlignmentScoring;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.alignment.CachedIntArray;
import com.milaboratory.core.alignment.LinearGapAlignmentScoring;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;

public class AlignerCustom {
    public static final int MIN_VALUE = -1073741824;

    public static <S extends Sequence<S>> Alignment<S> alignLinearSemiLocalLeft0(LinearGapAlignmentScoring<S> scoring, S seq1, S seq2, int offset1, int length1, int offset2, int length2, boolean boundSeq1, boolean boundSeq2, Alphabet<S> alphabet, LinearMatrixCache cache) {
        int j;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        Matrix matrix = cache.getMatrix(size1, size2);
        if (boundSeq1) {
            for (i = 1; i < size1; ++i) {
                matrix.set(i, 0, scoring.getGapPenalty() * i);
            }
        } else {
            for (i = 1; i < size1; ++i) {
                matrix.set(i, 0, 0);
            }
        }
        if (boundSeq2) {
            for (i = 1; i < size2; ++i) {
                matrix.set(0, i, scoring.getGapPenalty() * i);
            }
        } else {
            for (i = 1; i < size2; ++i) {
                matrix.set(0, i, 0);
            }
        }
        matrix.set(0, 0, 0);
        int max = 0;
        int iStop = 0;
        int jStop = 0;
        for (i = 0; i < length1; ++i) {
            for (j = 0; j < length2; ++j) {
                int match = matrix.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + i), seq2.codeAt(offset2 + j));
                int delete = matrix.get(i, j + 1) + scoring.getGapPenalty();
                int insert = matrix.get(i + 1, j) + scoring.getGapPenalty();
                match = Math.max(match, Math.max(delete, insert));
                matrix.set(i + 1, j + 1, match);
                if (max >= match) continue;
                iStop = i + 1;
                jStop = j + 1;
                max = match;
            }
        }
        MutationsBuilder<byte> mutations = new MutationsBuilder<byte>(alphabet);
        i = iStop - 1;
        j = jStop - 1;
        while (!(i < 0 && j < 0 || i == -1 && !boundSeq2 || j == -1 && !boundSeq1)) {
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + i);
                byte c2 = seq2.codeAt(offset2 + j);
                if (matrix.get(i + 1, j + 1) == matrix.get(i, j) + scoring.getScore(c1, c2)) {
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            if (i >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i, j + 1) + scoring.getGapPenalty()) {
                mutations.appendDeletion(offset1 + i, seq1.codeAt(offset1 + i));
                --i;
                continue;
            }
            if (j >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i + 1, j) + scoring.getGapPenalty()) {
                mutations.appendInsertion(offset1 + i + 1, seq2.codeAt(offset2 + j));
                --j;
                continue;
            }
            throw new RuntimeException();
        }
        mutations.reverseRange(0, mutations.size());
        return new Alignment<S>(seq1, mutations.createAndDestroy(), new Range(offset1 + i + 1, offset1 + iStop), new Range(offset2 + j + 1, offset2 + jStop), max);
    }

    public static <S extends Sequence<S>> Alignment<S> alignLinearSemiLocalRight0(LinearGapAlignmentScoring<S> scoring, S seq1, S seq2, int offset1, int length1, int offset2, int length2, boolean boundSeq1, boolean boundSeq2, Alphabet<S> alphabet, LinearMatrixCache cache) {
        int j;
        int i;
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        Matrix matrix = cache.getMatrix(size1, size2);
        if (boundSeq1) {
            for (i = 1; i < size1; ++i) {
                matrix.set(i, 0, scoring.getGapPenalty() * i);
            }
        } else {
            for (i = 1; i < size1; ++i) {
                matrix.set(i, 0, 0);
            }
        }
        if (boundSeq2) {
            for (i = 1; i < size2; ++i) {
                matrix.set(0, i, scoring.getGapPenalty() * i);
            }
        } else {
            for (i = 1; i < size2; ++i) {
                matrix.set(0, i, 0);
            }
        }
        matrix.set(0, 0, 0);
        int max = 0;
        int iStop = 0;
        int jStop = 0;
        for (i = 0; i < length1; ++i) {
            for (j = 0; j < length2; ++j) {
                int match = matrix.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + length1 - 1 - i), seq2.codeAt(offset2 + length2 - 1 - j));
                int delete = matrix.get(i, j + 1) + scoring.getGapPenalty();
                int insert = matrix.get(i + 1, j) + scoring.getGapPenalty();
                match = Math.max(match, Math.max(delete, insert));
                matrix.set(i + 1, j + 1, match);
                if (max >= match) continue;
                iStop = i + 1;
                jStop = j + 1;
                max = match;
            }
        }
        MutationsBuilder<byte> mutations = new MutationsBuilder<byte>(alphabet);
        i = iStop - 1;
        j = jStop - 1;
        while (!(i < 0 && j < 0 || i == -1 && !boundSeq2 || j == -1 && !boundSeq1)) {
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + length1 - 1 - i);
                byte c2 = seq2.codeAt(offset2 + length2 - 1 - j);
                if (matrix.get(i + 1, j + 1) == matrix.get(i, j) + scoring.getScore(c1, c2)) {
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + length1 - 1 - i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            if (i >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i, j + 1) + scoring.getGapPenalty()) {
                mutations.appendDeletion(offset1 + length1 - 1 - i, seq1.codeAt(offset1 + length1 - 1 - i));
                --i;
                continue;
            }
            if (j >= 0 && matrix.get(i + 1, j + 1) == matrix.get(i + 1, j) + scoring.getGapPenalty()) {
                mutations.appendInsertion(offset1 + length1 - 1 - i, seq2.codeAt(offset2 + length2 - 1 - j));
                --j;
                continue;
            }
            throw new RuntimeException();
        }
        return new Alignment<S>(seq1, mutations.createAndDestroy(), new Range(offset1 + length1 - iStop, offset1 + length1 - i - 1), new Range(offset2 + length2 - jStop, offset2 + length2 - j - 1), max);
    }

    public static <S extends Sequence<S>> Alignment<S> alignAffineSemiLocalLeft0(AffineGapAlignmentScoring<S> scoring, S seq1, S seq2, int offset1, int length1, int offset2, int length2, boolean boundSeq1, boolean boundSeq2, Alphabet<S> alphabet, AffineMatrixCache cache) {
        int j;
        int v;
        int i;
        if (length1 == 0 || length2 == 0) {
            return new Alignment<S>(seq1, Mutations.empty(alphabet), new Range(offset1, offset1), new Range(offset2, offset2), 0.0f);
        }
        int size1 = length1 + 1;
        int size2 = length2 + 1;
        cache.initMatrices(size1, size2);
        Matrix main = cache.main;
        Matrix gapIn1 = cache.gapIn1;
        Matrix gapIn2 = cache.gapIn2;
        for (i = 1; i < size1; ++i) {
            v = scoring.getGapOpenPenalty() + scoring.getGapExtensionPenalty() * (i - 1);
            main.set(i, 0, boundSeq1 ? v : 0);
            gapIn1.set(i, 0, -1073741824);
            gapIn2.set(i, 0, v);
        }
        for (i = 1; i < size2; ++i) {
            v = scoring.getGapOpenPenalty() + scoring.getGapExtensionPenalty() * (i - 1);
            main.set(0, i, boundSeq2 ? v : 0);
            gapIn1.set(0, i, v);
            gapIn2.set(0, i, -1073741824);
        }
        main.set(0, 0, 0);
        gapIn1.set(0, 0, -1073741824);
        gapIn2.set(0, 0, -1073741824);
        int maxI = -1;
        int maxJ = -1;
        int maxScore = 0;
        int gapExtensionPenalty = scoring.getGapExtensionPenalty();
        for (i = 0; i < length1; ++i) {
            for (j = 0; j < length2; ++j) {
                int match = main.get(i, j) + scoring.getScore(seq1.codeAt(offset1 + i), seq2.codeAt(offset2 + j));
                int gap1 = Math.max(main.get(i + 1, j) + scoring.getGapOpenPenalty(), gapIn1.get(i + 1, j) + gapExtensionPenalty);
                int gap2 = Math.max(main.get(i, j + 1) + scoring.getGapOpenPenalty(), gapIn2.get(i, j + 1) + gapExtensionPenalty);
                gapIn1.set(i + 1, j + 1, gap1);
                gapIn2.set(i + 1, j + 1, gap2);
                int score = Math.max(match, Math.max(gap1, gap2));
                main.set(i + 1, j + 1, score);
                if (score <= maxScore) continue;
                maxScore = score;
                maxI = i;
                maxJ = j;
            }
        }
        MutationsBuilder<byte> mutations = new MutationsBuilder<byte>(alphabet);
        i = maxI;
        j = maxJ;
        int pScore = main.get(i + 1, j + 1);
        while (i >= 0 || j >= 0) {
            if (i >= 0 && pScore == gapIn2.get(i + 1, j + 1)) {
                pScore = pScore == gapIn2.get(i, j + 1) + gapExtensionPenalty ? gapIn2.get(i, j + 1) : main.get(i, j + 1);
                mutations.appendDeletion(offset1 + i, seq1.codeAt(offset1 + i));
                --i;
                continue;
            }
            if (j >= 0 && pScore == gapIn1.get(i + 1, j + 1)) {
                pScore = pScore == gapIn1.get(i + 1, j) + gapExtensionPenalty ? gapIn1.get(i + 1, j) : main.get(i + 1, j);
                mutations.appendInsertion(offset1 + i + 1, seq2.codeAt(offset2 + j));
                --j;
                continue;
            }
            if (i >= 0 && j >= 0) {
                byte c1 = seq1.codeAt(offset1 + i);
                byte c2 = seq2.codeAt(offset2 + j);
                if (pScore == main.get(i, j) + scoring.getScore(c1, c2)) {
                    pScore = main.get(i, j);
                    if (c1 != c2) {
                        mutations.appendSubstitution(offset1 + i, c1, c2);
                    }
                    --i;
                    --j;
                    continue;
                }
            }
            if (i == -1 && !boundSeq2 || j == -1 && !boundSeq1) break;
            throw new RuntimeException();
        }
        mutations.reverseRange(0, mutations.size());
        return new Alignment<S>(seq1, mutations.createAndDestroy(), new Range(offset1 + i + 1, offset1 + maxI + 1), new Range(offset2 + j + 1, offset2 + maxJ + 1), maxScore);
    }

    public static final class AffineMatrixCache
    implements MatrixCache {
        private final CachedIntArray mainCache = new CachedIntArray();
        private final CachedIntArray gapIn1Cache = new CachedIntArray();
        private final CachedIntArray gapIn2Cache = new CachedIntArray();
        Matrix main;
        Matrix gapIn1;
        Matrix gapIn2;

        void initMatrices(int height, int width) {
            this.main = new Matrix(this.mainCache.get(height * width), height, width);
            this.gapIn1 = new Matrix(this.gapIn1Cache.get(height * width), height, width);
            this.gapIn2 = new Matrix(this.gapIn2Cache.get(height * width), height, width);
        }
    }

    public static final class LinearMatrixCache
    implements MatrixCache {
        final CachedIntArray cache = new CachedIntArray();

        Matrix getMatrix(int height, int width) {
            return new Matrix(this.cache.get(height * width), height, width);
        }
    }

    public static interface MatrixCache {
    }

    public static final class Matrix {
        private final int[] data;
        private final int height;
        private final int width;

        public Matrix(int[] data, int height, int width) {
            this.data = data;
            this.height = height;
            this.width = width;
        }

        public int get(int row, int col) {
            return this.data[this.width * row + col];
        }

        public void set(int row, int col, int value) {
            this.data[this.width * row + col] = value;
        }
    }
}

