/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.alignment;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AlignmentHelper;
import com.milaboratory.core.alignment.AlignmentIteratorForward;
import com.milaboratory.core.alignment.AlignmentIteratorReverse;
import com.milaboratory.core.alignment.AlignmentScoring;
import com.milaboratory.core.alignment.AlignmentUtils;
import com.milaboratory.core.io.binary.AlignmentSerializer;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.primitivio.annotations.Serializable;
import com.milaboratory.util.BitArray;
import com.milaboratory.util.IntArrayList;
import java.util.ArrayList;

@Serializable(by=AlignmentSerializer.class)
public final class Alignment<S extends Sequence<S>>
implements java.io.Serializable {
    final S sequence1;
    final Mutations<S> mutations;
    final Range sequence1Range;
    final Range sequence2Range;
    final float score;

    public Alignment(S sequence1, Mutations<S> mutations, float score) {
        this(sequence1, mutations, new Range(0, sequence1.size()), new Range(0, sequence1.size() + mutations.getLengthDelta()), score);
    }

    public Alignment(S sequence1, Mutations<S> mutations, AlignmentScoring<S> scoring) {
        this(sequence1, mutations, new Range(0, sequence1.size()), new Range(0, sequence1.size() + mutations.getLengthDelta()), scoring);
    }

    public Alignment(S sequence1, Mutations<S> mutations, Range sequence1Range, Range sequence2Range, AlignmentScoring<S> scoring) {
        this(sequence1, mutations, sequence1Range, sequence2Range, AlignmentUtils.calculateScore(sequence1, sequence1Range, mutations, scoring));
    }

    public Alignment(S sequence1, Mutations<S> mutations, Range sequence1Range, Range sequence2Range, float score) {
        if (!mutations.isEmpty()) {
            if (!mutations.isCompatibleWith(sequence1) || !sequence1Range.contains(mutations.getMutatedRange()) || sequence1Range.length() + mutations.getLengthDelta() != sequence2Range.length()) {
                throw new IllegalArgumentException("Not compatible arguments: muts: " + mutations + " range1: " + sequence1Range + " range2: " + sequence2Range);
            }
        } else if (sequence1Range.length() != sequence2Range.length()) {
            throw new IllegalArgumentException("Not compatible arguments.");
        }
        this.sequence1 = sequence1;
        this.mutations = mutations;
        this.sequence1Range = sequence1Range;
        this.sequence2Range = sequence2Range;
        this.score = score;
    }

    public int calculateScore(AlignmentScoring<S> scoring) {
        return AlignmentUtils.calculateScore(this.sequence1, this.sequence1Range, this.mutations, scoring);
    }

    public AlignmentIteratorForward<S> forwardIterator() {
        return new AlignmentIteratorForward<S>(this.mutations, this.sequence1Range, this.sequence2Range.getFrom());
    }

    public AlignmentIteratorReverse<S> reverseIterator() {
        return new AlignmentIteratorReverse<S>(this.mutations, this.sequence1Range, this.sequence2Range.getTo());
    }

    public S getSequence1() {
        return this.sequence1;
    }

    public Mutations<S> getAbsoluteMutations() {
        return this.mutations;
    }

    public Mutations<S> getRelativeMutations() {
        return this.mutations.move(-this.sequence1Range.getLower());
    }

    public Range getSequence1Range() {
        return this.sequence1Range;
    }

    public Range getSequence2Range() {
        return this.sequence2Range;
    }

    public int convertToSeq2Position(int positionInSeq1) {
        if (!this.sequence1Range.containsBoundary(positionInSeq1)) {
            return -1;
        }
        int p = this.mutations.convertToSeq2Position(positionInSeq1);
        if (p < 0) {
            return -2 - (~p + this.sequence2Range.getFrom() - this.sequence1Range.getFrom());
        }
        return p + this.sequence2Range.getFrom() - this.sequence1Range.getFrom();
    }

    public int convertToSeq1Position(int positionInSeq2) {
        if (!this.sequence2Range.containsBoundary(positionInSeq2)) {
            return -1;
        }
        int p = this.mutations.convertToSeq1Position(positionInSeq2 += -this.sequence2Range.getFrom() + this.sequence1Range.getFrom());
        return p < 0 ? -2 - ~p : p;
    }

    public Range convertToSeq1Range(Range rangeInSeq2) {
        int from = Alignment.aabs(this.convertToSeq1Position(rangeInSeq2.getFrom()));
        int to = Alignment.aabs(this.convertToSeq1Position(rangeInSeq2.getTo()));
        if (from == -1 || to == -1) {
            return null;
        }
        return new Range(from, to);
    }

    public Range convertToSeq2Range(Range rangeInSeq1) {
        int from = Alignment.aabs(this.convertToSeq2Position(rangeInSeq1.getFrom()));
        int to = Alignment.aabs(this.convertToSeq2Position(rangeInSeq1.getTo()));
        if (from == -1 || to == -1) {
            return null;
        }
        return new Range(from, to);
    }

    public float getScore() {
        return this.score;
    }

    public Alignment<S> invert(S sequence2) {
        return new Alignment<S>(sequence2, this.getRelativeMutations().invert().move(this.sequence2Range.getFrom()), this.sequence2Range, this.sequence1Range, this.score);
    }

    public float similarity() {
        int match = 0;
        int mismatch = 0;
        AlignmentIteratorForward<S> iterator = this.forwardIterator();
        while (iterator.advance()) {
            int mut = iterator.getCurrentMutation();
            if (mut == 0) {
                ++match;
                continue;
            }
            ++mismatch;
        }
        return 1.0f * (float)match / (float)(match + mismatch);
    }

    public AlignmentHelper getAlignmentHelper() {
        ArrayList<Boolean> matches = new ArrayList<Boolean>();
        IntArrayList pos1 = new IntArrayList(this.sequence1.size() + this.mutations.size());
        IntArrayList pos2 = new IntArrayList(this.sequence1.size() + this.mutations.size());
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        Alphabet<S> alphabet = this.mutations.getAlphabet();
        AlignmentIteratorForward<S> iterator = this.forwardIterator();
        block5: while (iterator.advance()) {
            int mut = iterator.getCurrentMutation();
            switch (Mutation.getRawTypeCode(mut)) {
                case 32: {
                    pos1.add(iterator.getSeq1Position());
                    pos2.add(iterator.getSeq2Position());
                    sb1.append(((Sequence)this.sequence1).symbolAt(iterator.getSeq1Position()));
                    sb2.append(Mutation.getToSymbol(mut, alphabet));
                    matches.add(false);
                    continue block5;
                }
                case 64: {
                    pos1.add(iterator.getSeq1Position());
                    pos2.add(-1 - iterator.getSeq2Position());
                    sb1.append(((Sequence)this.sequence1).symbolAt(iterator.getSeq1Position()));
                    sb2.append("-");
                    matches.add(false);
                    continue block5;
                }
                case 96: {
                    pos1.add(-1 - iterator.getSeq1Position());
                    pos2.add(iterator.getSeq2Position());
                    sb1.append("-");
                    sb2.append(Mutation.getToSymbol(mut, alphabet));
                    matches.add(false);
                    continue block5;
                }
            }
            pos1.add(iterator.getSeq1Position());
            pos2.add(iterator.getSeq2Position());
            char c = ((Sequence)this.sequence1).symbolAt(iterator.getSeq1Position());
            sb1.append(c);
            sb2.append(c);
            matches.add(true);
        }
        return new AlignmentHelper(sb1.toString(), sb2.toString(), pos1.toArray(), pos2.toArray(), new BitArray(matches));
    }

    public Alignment<S> move(int offset) {
        return new Alignment<S>(this.sequence1, this.mutations, this.sequence1Range, this.sequence2Range.move(offset), this.score);
    }

    public String toString() {
        return this.getAlignmentHelper().toCompactString();
    }

    public String toCompactString() {
        return "" + this.sequence1Range.getFrom() + "|" + this.sequence1Range.getTo() + "|" + this.sequence1.size() + "|" + this.sequence2Range.getFrom() + "|" + this.sequence2Range.getTo() + "|" + this.mutations.encode() + "|" + this.score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alignment alignment = (Alignment)o;
        if (Float.compare(alignment.score, this.score) != 0) {
            return false;
        }
        if (!this.mutations.equals(alignment.mutations)) {
            return false;
        }
        if (!((Sequence)this.sequence1).equals(alignment.sequence1)) {
            return false;
        }
        if (!this.sequence1Range.equals(alignment.sequence1Range)) {
            return false;
        }
        return this.sequence2Range.equals(alignment.sequence2Range);
    }

    public int hashCode() {
        int result = ((Sequence)this.sequence1).hashCode();
        result = 31 * result + this.mutations.hashCode();
        result = 31 * result + this.sequence1Range.hashCode();
        result = 31 * result + this.sequence2Range.hashCode();
        result = 31 * result + (this.score != 0.0f ? Float.floatToIntBits(this.score) : 0);
        return result;
    }

    public static int aabs(int position) {
        if (position == -1) {
            return -1;
        }
        if (position < 0) {
            return -2 - position;
        }
        return position;
    }
}

